/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import ksp.org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isDeclaredInAny", "", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDataObjectContentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataObjectContentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1755#2,3:40\n*S KotlinDebug\n*F\n+ 1 DataObjectContentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DataObjectContentChecker\n*L\n28#1:40,3\n*E\n"})
public final class DataObjectContentChecker
implements DeclarationChecker {
    @NotNull
    public static final DataObjectContentChecker INSTANCE = new DataObjectContentChecker();

    private DataObjectContentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(descriptor instanceof FunctionDescriptor)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getName(), (Object)OperatorNameConventions.EQUALS) && !Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getName(), (Object)OperatorNameConventions.HASH_CODE)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)descriptor).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            DeclarationDescriptor container = declarationDescriptor;
            if (!(container instanceof ClassDescriptor)) {
                return;
            }
            if (!((ClassDescriptor)container).isData() || ((ClassDescriptor)container).getKind() != ClassKind.OBJECT) {
                return;
            }
            Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)descriptor);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAllOverriddenDescriptors(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunctionDescriptor p0 = (FunctionDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!this.isDeclaredInAny(p0)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            PsiElement psiElement = declaration2.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) {
                psiElement = declaration2;
            }
            PsiElement target = psiElement;
            context2.getTrace().report(Errors.DATA_OBJECT_CUSTOM_EQUALS_OR_HASH_CODE.on(target));
        }
    }

    private final boolean isDeclaredInAny(FunctionDescriptor descriptor) {
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        return container instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)container);
    }
}

