/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.reference;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class ReferenceAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JsExpression reference;

    @NotNull
    static ReferenceAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context2) {
        if (expression2 == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(1);
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context2.bindingContext(), expression2);
        assert (referenceDescriptor != null) : "KtSimpleName expression must reference a descriptor " + expression2.getText();
        return new ReferenceAccessTranslator(referenceDescriptor, context2);
    }

    private ReferenceAccessTranslator(@NotNull DeclarationDescriptor descriptor, @NotNull TranslationContext context2) {
        if (descriptor == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(3);
        }
        super(context2);
        this.reference = ReferenceTranslator.translateAsValueReference(descriptor, this.context());
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.reference;
        if (jsExpression == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(4);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(5);
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(this.reference, toSetTo);
        if (jsBinaryOperation == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(6);
        }
        return jsBinaryOperation;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        ReferenceAccessTranslator referenceAccessTranslator = this;
        if (referenceAccessTranslator == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(7);
        }
        return referenceAccessTranslator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/ReferenceAccessTranslator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSetTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/ReferenceAccessTranslator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

