/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0004!\"#$B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\u0010*\u0004\u0018\u00010\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "mppKind", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInheritance", "", "throwsAnnotation", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "getInheritedThrows", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "hasUnresolvedArgument", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "decodeThrowsFilter", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "getClassIds", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "Regular", "ForExpectClass", "Companion", "ThrowsFilter", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,202:1\n2632#2,3:203\n1663#2,8:206\n1611#2,9:214\n1863#2:223\n1864#2:225\n1620#2:226\n1611#2,9:228\n1863#2:237\n1864#2:239\n1620#2:240\n1#3:224\n1#3:238\n26#4:227\n227#5:241\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker\n*L\n79#1:203,3\n97#1:206,8\n103#1:214,9\n103#1:223\n103#1:225\n103#1:226\n197#1:228,9\n197#1:237\n197#1:239\n197#1:240\n103#1:224\n197#1:238\n182#1:227\n139#1:241\n*E\n"})
public abstract class FirNativeThrowsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId throwsClassId = ClassId.Companion.topLevel(ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME());
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private FirNativeThrowsChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirAnnotation throwsAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, throwsClassId, context2.getSession());
        if (!this.checkInheritance(declaration2, throwsAnnotation, context2, reporter)) {
            return;
        }
        if (this.hasUnresolvedArgument(throwsAnnotation)) {
            return;
        }
        Object object = throwsAnnotation;
        if (object == null || (object = this.getClassIds((FirAnnotation)object, context2.getSession())) == null) {
            return;
        }
        Object classIds = object;
        if (classIds.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getTHROWS_LIST_EMPTY(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        FirElement firElement = declaration2;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"SUSPEND_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            boolean bl;
            block9: {
                Iterable $this$none$iv = (Iterable)classIds;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ClassId it = (ClassId)element$iv;
                        boolean bl2 = false;
                        if (!cancellationExceptionAndSupersClassIds.contains(it)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getMISSING_EXCEPTION_IN_THROWS_ON_SUSPEND(), (Object)cancellationExceptionFqName, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(FirDeclaration declaration2, FirAnnotation throwsAnnotation, CheckerContext context2, DiagnosticReporter reporter) {
        if (!(declaration2 instanceof FirSimpleFunction)) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.getInheritedThrows((FirSimpleFunction)declaration2, throwsAnnotation, context2).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$distinctBy$iv = inherited;
            KtDiagnosticFactory1<Collection<FirRegularClassSymbol>> ktDiagnosticFactory1 = FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_INHERITED();
            AbstractKtSourceElement abstractKtSourceElement = ((FirSimpleFunction)declaration2).getSource();
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$mapNotNull = false;
            set$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)it.getKey());
                if ((coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)list, (DiagnosticContext)context2, null, 16, null);
            return false;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((List)inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        FirNamedFunctionSymbol overriddenMember = (FirNamedFunctionSymbol)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        FirAnnotation firAnnotation = throwsAnnotation;
        if ((firAnnotation != null ? firAnnotation.getSource() : null) != null && !Intrinsics.areEqual((Object)this.decodeThrowsFilter(throwsAnnotation, context2.getSession()), (Object)overriddenThrows)) {
            FirRegularClassSymbol containingClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overriddenMember);
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
            if (containingClassSymbol != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_OVERRIDE(), (Object)containingClassSymbol, (DiagnosticContext)context2, null, 16, null);
            }
            return false;
        }
        return true;
    }

    private final Map<FirNamedFunctionSymbol, ThrowsFilter> getInheritedThrows(FirSimpleFunction function2, FirAnnotation throwsAnnotation, CheckerContext context2) {
        Set visited2 = new LinkedHashSet();
        Map result2 = new LinkedHashMap();
        FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, context2, function2, result2, this, throwsAnnotation, function2.getSymbol());
        return result2;
    }

    private final boolean hasUnresolvedArgument(FirElement $this$hasUnresolvedArgument) {
        if ($this$hasUnresolvedArgument instanceof FirWrappedArgumentExpression) {
            return this.hasUnresolvedArgument(((FirWrappedArgumentExpression)$this$hasUnresolvedArgument).getExpression());
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvable && FirReferenceUtilsKt.isError(((FirResolvable)$this$hasUnresolvedArgument).getCalleeReference())) {
            return true;
        }
        if ($this$hasUnresolvedArgument instanceof FirVarargArgumentsExpression) {
            for (FirExpression argument : ((FirVarargArgumentsExpression)$this$hasUnresolvedArgument).getArguments()) {
                if (!this.hasUnresolvedArgument(argument)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirCall) {
            for (FirExpression argument : ((FirCall)$this$hasUnresolvedArgument).getArgumentList().getArguments()) {
                if (!this.hasUnresolvedArgument(argument)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirResolvedQualifier)$this$hasUnresolvedArgument).getSymbol();
            if (firClassLikeSymbol != null) {
                FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
                boolean bl = false;
                if (symbol instanceof FirTypeAliasSymbol) {
                    FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeKotlinType)) {
                        coneKotlinType = null;
                    }
                    boolean bl2 = coneKotlinType != null ? ConeTypeUtilsKt.hasError(coneKotlinType) : false;
                    if (bl2) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final ThrowsFilter decodeThrowsFilter(FirAnnotation throwsAnnotation, FirSession session) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getClassIds((FirAnnotation)object, session)) != null ? CollectionsKt.toSet((Iterable)((Iterable)object)) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> getClassIds(FirAnnotation $this$getClassIds, FirSession session) {
        void $this$mapNotNullTo$iv$iv;
        Object object = (FirExpression)CollectionsKt.firstOrNull((Iterable)$this$getClassIds.getArgumentMapping().getMapping().values());
        if (object == null || (object = FirAnnotationUtilsKt.unwrapVarargValue((FirExpression)object)) == null) {
            return CollectionsKt.emptyList();
        }
        Object unwrappedArgs = object;
        Iterable $this$mapNotNull$iv = (Iterable)unwrappedArgs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(it, session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void getInheritedThrows$getInheritedThrows(Set<FirNamedFunctionSymbol> visited2, CheckerContext $context, FirSimpleFunction $function, Map<FirNamedFunctionSymbol, ThrowsFilter> result2, FirNativeThrowsChecker this$0, FirAnnotation localThrowsAnnotation, FirNamedFunctionSymbol localFunctionSymbol) {
        FirRegularClassSymbol containingClassSymbol;
        if (!visited2.add(localFunctionSymbol)) {
            return;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(localFunctionSymbol);
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, $context.getSession()) : null;
        if (containingClassSymbol != null) {
            List<FirNamedFunctionSymbol> overriddenFunctions = FirHelpersKt.directOverriddenFunctions(localFunctionSymbol, $context.getSession(), $context.getScopeSession());
            if (Intrinsics.areEqual((Object)localFunctionSymbol, (Object)$function.getSymbol()) || localThrowsAnnotation == null && !((Collection)overriddenFunctions).isEmpty()) {
                for (FirNamedFunctionSymbol overriddenFunction : overriddenFunctions) {
                    FirAnnotation firAnnotation;
                    boolean condition$iv = ClassMembersKt.isSubstitutionOrIntersectionOverride(overriddenFunction);
                    boolean $i$f$runUnless = false;
                    if (condition$iv) {
                        firAnnotation = null;
                    } else {
                        boolean bl = false;
                        firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(overriddenFunction, throwsClassId, $context.getSession());
                    }
                    FirAnnotation annotation = firAnnotation;
                    FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, $context, $function, result2, this$0, annotation, overriddenFunction);
                }
            } else {
                result2.put(localFunctionSymbol, this$0.decodeThrowsFilter(localThrowsAnnotation, $context.getSession()));
            }
        }
    }

    public /* synthetic */ FirNativeThrowsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    static {
        Object[] objectArray = new ClassId[]{ClassId.Companion.topLevel(StandardNames.FqNames.throwable), ClassId.Companion.topLevel(new FqName("kotlin.Exception")), ClassId.Companion.topLevel(new FqName("kotlin.RuntimeException")), ClassId.Companion.topLevel(new FqName("kotlin.IllegalStateException")), ClassId.Companion.topLevel(cancellationExceptionFqName)};
        cancellationExceptionAndSupersClassIds = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Companion;", "", "<init>", "()V", "throwsClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "cancellationExceptionFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "cancellationExceptionAndSupersClassIds", "", "checkers.native"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,202:1\n37#2:203\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass\n*L\n46#1:203\n*E\n"})
    public static final class ForExpectClass
    extends FirNativeThrowsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration firMemberDeclaration = declaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "<init>", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeThrowsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,202:1\n37#2:203\n*S KotlinDebug\n*F\n+ 1 FirNativeThrowsChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular\n*L\n39#1:203\n*E\n"})
    public static final class Regular
    extends FirNativeThrowsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            FirMemberDeclaration firMemberDeclaration = declaration2 instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration2 : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            super.check(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001b\u0010\n\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "", "classes", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "<init>", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "checkers.native"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ClassId> classes;

        public ThrowsFilter(@Nullable Set<ClassId> classes) {
            this.classes = classes;
        }

        @Nullable
        public final Set<ClassId> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ClassId> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<ClassId> classes) {
            return new ThrowsFilter(classes);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

