/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.JvmStandardClassIds;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "<init>", "()V", "javaToKotlinNameMap", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJavaAnnotationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n26#2:62\n1#3:63\n*S KotlinDebug\n*F\n+ 1 FirJavaAnnotationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJavaAnnotationsChecker\n*L\n43#1:62\n*E\n"})
public final class FirJavaAnnotationsChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirJavaAnnotationsChecker INSTANCE = new FirJavaAnnotationsChecker();
    @NotNull
    private static final Map<ClassId, ClassId> javaToKotlinNameMap;

    private FirJavaAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnnotation expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirArgumentList argumentList;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Object object2 = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (!Intrinsics.areEqual((Object)(object2 != null && (object2 = ((FirDeclaration)object2).getSource()) != null ? ((KtSourceElement)object2).getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(expression2.getAnnotationTypeRef(), context2.getSession());
        FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol callableSymbol = firClassSymbol;
        if (!(callableSymbol.getOrigin() instanceof FirDeclarationOrigin.Java)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = expression2.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return;
        }
        Object lookupTag = object;
        ClassId classId = javaToKotlinNameMap.get(((ConeClassLikeLookupTag)lookupTag).getClassId());
        if (classId != null) {
            ClassId betterName = classId;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getDEPRECATED_JAVA_ANNOTATION(), (Object)betterName.asSingleFqName(), (DiagnosticContext)context2, null, 16, null);
        }
        if (expression2 instanceof FirAnnotationCall && (argumentList = ((FirAnnotationCall)expression2).getArgumentList()) instanceof FirResolvedArgumentList) {
            Object object3 = ((FirResolvedArgumentList)argumentList).getOriginalArgumentList();
            if (object3 == null || (object3 = ((FirArgumentList)object3).getArguments()) == null) {
                return;
            }
            Object arguments2 = object3;
            Iterator iterator2 = arguments2.iterator();
            while (iterator2.hasNext()) {
                FirExpression key = (FirExpression)iterator2.next();
                if (key instanceof FirWrappedArgumentExpression) continue;
                FirValueParameter firValueParameter = ((FirResolvedArgumentList)argumentList).getMapping().get(key);
                Name it = firValueParameter != null ? firValueParameter.getName() : null;
                boolean bl = false;
                boolean bl2 = it != null && !Intrinsics.areEqual((Object)it, (Object)StandardClassIds.Annotations.ParameterNames.INSTANCE.getValue());
                if (!bl2) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)key.getSource(), FirJvmErrors.INSTANCE.getPOSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getTarget(), (Object)StandardClassIds.Annotations.INSTANCE.getTarget()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getRetention(), (Object)StandardClassIds.Annotations.INSTANCE.getRetention()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDeprecated(), (Object)StandardClassIds.Annotations.INSTANCE.getDeprecated()), TuplesKt.to((Object)JvmStandardClassIds.Annotations.Java.INSTANCE.getDocumented(), (Object)StandardClassIds.Annotations.INSTANCE.getMustBeDocumented())};
        javaToKotlinNameMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

