/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantCallOfConversionMethod;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isRedundant", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "qualifiedClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "targetClassMap", "Ljava/util/HashMap;", "", "checkers"})
public final class RedundantCallOfConversionMethod
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final RedundantCallOfConversionMethod INSTANCE = new RedundantCallOfConversionMethod();
    @NotNull
    private static final HashMap<String, ClassId> targetClassMap;

    private RedundantCallOfConversionMethod() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirFunctionCall)) {
            return;
        }
        String string2 = ((FirFunctionCall)expression2).getCalleeReference().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String functionName = string2;
        ClassId classId = targetClassMap.get(functionName);
        if (classId == null) {
            return;
        }
        ClassId qualifiedType = classId;
        FirExpression firExpression = ((FirFunctionCall)expression2).getExplicitReceiver();
        boolean bl = firExpression != null ? this.isRedundant(firExpression, qualifiedType, context2.getSession()) : false;
        if (bl) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirFunctionCall)expression2).getSource(), FirErrors.INSTANCE.getREDUNDANT_CALL_OF_CONVERSION_METHOD(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean isRedundant(FirExpression $this$isRedundant, ClassId qualifiedClassId, FirSession session) {
        Object object;
        if ($this$isRedundant instanceof FirLiteralExpression) {
            object = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant));
        } else if (FirTypeUtilsKt.getResolvedType($this$isRedundant) instanceof ConeFlexibleType) {
            object = null;
        } else {
            PsiElement psiElement = UtilsKt.getPsi($this$isRedundant);
            object = !((psiElement != null ? psiElement.getParent() : null) instanceof KtSafeQualifiedExpression) && (UtilsKt.getPsi($this$isRedundant) instanceof KtSafeQualifiedExpression || ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant))) ? null : (ConeTypeUtilsKt.isMarkedNullable(FirTypeUtilsKt.getResolvedType($this$isRedundant)) ? null : FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getResolvedType($this$isRedundant), session));
        }
        ClassId thisType = object;
        return Intrinsics.areEqual((Object)thisType, (Object)qualifiedClassId);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toString", (Object)StandardClassIds.INSTANCE.getString()), TuplesKt.to((Object)"toDouble", (Object)StandardClassIds.INSTANCE.getDouble()), TuplesKt.to((Object)"toFloat", (Object)StandardClassIds.INSTANCE.getFloat()), TuplesKt.to((Object)"toLong", (Object)StandardClassIds.INSTANCE.getLong()), TuplesKt.to((Object)"toInt", (Object)StandardClassIds.INSTANCE.getInt()), TuplesKt.to((Object)"toChar", (Object)StandardClassIds.INSTANCE.getChar()), TuplesKt.to((Object)"toShort", (Object)StandardClassIds.INSTANCE.getShort()), TuplesKt.to((Object)"toByte", (Object)StandardClassIds.INSTANCE.getByte()), TuplesKt.to((Object)"toULong", (Object)StandardClassIds.INSTANCE.getULong()), TuplesKt.to((Object)"toUInt", (Object)StandardClassIds.INSTANCE.getUInt()), TuplesKt.to((Object)"toUShort", (Object)StandardClassIds.INSTANCE.getUShort()), TuplesKt.to((Object)"toUByte", (Object)StandardClassIds.INSTANCE.getUByte())};
        targetClassMap = MapsKt.hashMapOf((Pair[])pairArray);
    }
}

