/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElementKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,56:1\n35#2:57\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker\n*L\n48#1:57\n*E\n"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        KtSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = expression2.getSource();
        KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
        if (sourceKind instanceof KtFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof KtFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(expression2, context2)) {
            return;
        }
        Object object = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        if (object == null || (object = FirReferenceUtilsKt.toResolvedBaseSymbol$default((FirReference)object, false, 1, null)) == null) {
            return;
        }
        Object resolvedSymbol = object;
        FirOptInUsageBaseChecker $this$check_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment) {
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, true, null), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, CollectionsKt.emptyList()));
            FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, experimentalities, ((FirVariableAssignment)expression2).getLValue(), context2, reporter, null, 16, null);
        } else if (expression2 instanceof FirQualifiedAccessExpression) {
            Object object2 = ((FirQualifiedAccessExpression)expression2).getDispatchReceiver();
            ConeKotlinType dispatchReceiverType = object2 != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object2, context2.getSession()) : null;
            Set experimentalities = SetsKt.plus($this$check_u24lambda_u240.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, dispatchReceiverType), (Iterable)$this$check_u24lambda_u240.loadExperimentalitiesFromTypeArguments(context2, ((FirQualifiedAccessExpression)expression2).getTypeArguments()));
            KtSourceElement ktSourceElement2 = ((FirQualifiedAccessExpression)expression2).getSource();
            KtSourceElement source = ktSourceElement2 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(ktSourceElement2, context2) : null;
            $this$check_u24lambda_u240.reportNotAcceptedExperimentalities(experimentalities, expression2, context2, reporter, source);
        } else if (expression2 instanceof FirDelegatedConstructorCall && resolvedSymbol instanceof FirConstructorSymbol) {
            FirCallableSymbol $this$isFromEnumClass$iv = (FirCallableSymbol)resolvedSymbol;
            boolean $i$f$isFromEnumClass = false;
            if ($this$isFromEnumClass$iv.getRawStatus().isFromEnumClass()) {
                Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$check_u24lambda_u240.loadExperimentalities((FirBasedSymbol<?>)resolvedSymbol, context2, false, null);
                FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$check_u24lambda_u240, experimentalities, ((FirDelegatedConstructorCall)expression2).getCalleeReference(), context2, reporter, null, 16, null);
            }
        }
    }
}

