/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.diagnostics;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiInvalidElementAccessException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class PsiDiagnosticUtils {
    public static String atLocation(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiDiagnosticUtils.$$$reportNull$$$0(0);
        }
        if (element2.isValid()) {
            return PsiDiagnosticUtils.atLocation(element2.getContainingFile(), element2.getTextRange());
        }
        PsiFile file2 = null;
        int offset = -1;
        try {
            file2 = element2.getContainingFile();
            offset = element2.getTextOffset();
        }
        catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
            // empty catch block
        }
        return "at offset: " + (offset != -1 ? Integer.valueOf(offset) : "<unknown>") + " file: " + (file2 != null ? file2 : "<unknown>");
    }

    public static String atLocation(KtExpression expression2) {
        return PsiDiagnosticUtils.atLocation(expression2.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        if (node == null) {
            PsiDiagnosticUtils.$$$reportNull$$$0(1);
        }
        int startOffset = node.getStartOffset();
        PsiElement element2 = PsiUtilsKt.closestPsiElement(node);
        if (element2 != null) {
            return PsiDiagnosticUtils.atLocation(element2);
        }
        return "at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (file2 == null) {
            PsiDiagnosticUtils.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            PsiDiagnosticUtils.$$$reportNull$$$0(3);
        }
        Document document = file2.getViewProvider().getDocument();
        return PsiDiagnosticUtils.atLocation(file2, textRange, document);
    }

    @NotNull
    public static String atLocation(PsiFile file2, TextRange textRange, Document document) {
        int offset = textRange.getStartOffset();
        VirtualFile virtualFile = file2.getVirtualFile();
        String pathSuffix = " in " + (virtualFile == null ? file2.getName() : virtualFile.getPath());
        String string2 = PsiDiagnosticUtils.offsetToLineAndColumn(document, offset) + pathSuffix;
        if (string2 == null) {
            PsiDiagnosticUtils.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(@Nullable Document document, int offset) {
        if (document == null || document.getTextLength() == 0) {
            return new LineAndColumn(-1, offset, null);
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset - lineStartOffset;
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        return new LineAndColumn(lineNumber + 1, column + 1, lineContent.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/diagnostics/PsiDiagnosticUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "atLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "atLocation";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class LineAndColumnRange {
        public static final LineAndColumnRange NONE = new LineAndColumnRange(LineAndColumn.NONE, LineAndColumn.NONE);
        private final LineAndColumn start;
        private final LineAndColumn end;

        public LineAndColumnRange(LineAndColumn start, LineAndColumn end) {
            this.start = start;
            this.end = end;
        }

        public LineAndColumn getStart() {
            return this.start;
        }

        public LineAndColumn getEnd() {
            return this.end;
        }

        public String toString() {
            if (this.start.line == this.end.line) {
                return "(" + this.start.line + "," + this.start.column + "-" + this.end.column + ")";
            }
            return this.start + " - " + this.end;
        }
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1, null);
        private final int line;
        private final int column;
        private final String lineContent;

        public LineAndColumn(int line, int column, @Nullable String lineContent) {
            this.line = line;
            this.column = column;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        @Nullable
        public String getLineContent() {
            return this.lineContent;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

