/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import ksp.org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.AccessorIdSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.CommonIdSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.CompositeSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.FileLocalIdSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.FileSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import ksp.org.jetbrains.kotlin.backend.common.serialization.proto.LocalSignature;
import ksp.org.jetbrains.kotlin.ir.util.IdSignature;
import ksp.org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "", "libraryFile", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileSignature", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "irInterner", "Lksp/org/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;)V", "loadSignatureProto", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "index", "", "signatureCache", "Ljava/util/HashMap;", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature;", "deserializeIdSignature", "deserializePublicIdSignature", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "proto", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/CommonIdSignature;", "deserializeAccessorIdSignature", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/AccessorIdSignature;", "deserializeFileLocalIdSignature", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/FileLocalIdSignature;", "deserializeScopeLocalIdSignature", "deserializeCompositeIdSignature", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/CompositeSignature;", "deserializeLocalIdSignature", "Lksp/org/jetbrains/kotlin/ir/util/IdSignature$LocalSignature;", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/LocalSignature;", "deserializeFileIdSignature", "Lksp/org/jetbrains/kotlin/backend/common/serialization/proto/FileSignature;", "deserializeSignatureData", "signatureToIndexMapping", "", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n381#2,7:116\n1#3:123\n1261#4,4:124\n*S KotlinDebug\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n*L\n32#1:116,7\n113#1:124,4\n*E\n"})
public final class IdSignatureDeserializer {
    @NotNull
    private final IrLibraryFile libraryFile;
    @Nullable
    private final IdSignature.FileSignature fileSignature;
    @NotNull
    private final IrInterningService irInterner;
    @NotNull
    private final HashMap<Integer, ksp.org.jetbrains.kotlin.ir.util.IdSignature> signatureCache;

    public IdSignatureDeserializer(@NotNull IrLibraryFile libraryFile, @Nullable IdSignature.FileSignature fileSignature, @NotNull IrInterningService irInterner) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)irInterner, (String)"irInterner");
        this.libraryFile = libraryFile;
        this.fileSignature = fileSignature;
        this.irInterner = irInterner;
        this.signatureCache = new HashMap();
    }

    private final IdSignature loadSignatureProto(int index) {
        return this.libraryFile.signature(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ksp.org.jetbrains.kotlin.ir.util.IdSignature deserializeIdSignature(int index) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.signatureCache;
        Integer key$iv = index;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature sigData = this.loadSignatureProto(index);
            ksp.org.jetbrains.kotlin.ir.util.IdSignature answer$iv = this.deserializeSignatureData(sigData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (ksp.org.jetbrains.kotlin.ir.util.IdSignature)object;
    }

    private final IdSignature.CommonSignature deserializePublicIdSignature(CommonIdSignature proto) {
        String string2;
        Long memberId;
        List<Integer> list = proto.getPackageFqNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackageFqNameList(...)");
        String pkg = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list));
        List<Integer> list2 = proto.getDeclarationFqNameList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeclarationFqNameList(...)");
        String cls = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list2));
        Long l = memberId = proto.hasMemberUniqId() ? Long.valueOf(proto.getMemberUniqId()) : null;
        if (proto.hasDebugInfo()) {
            String string3 = this.libraryFile.debugInfo(proto.getDebugInfo());
            if (string3 != null) {
                String string4 = string3;
                IrInterningService irInterningService = this.irInterner;
                String p0 = string4;
                boolean bl = false;
                string2 = irInterningService.string(p0);
            } else {
                string2 = null;
            }
        } else {
            string2 = null;
        }
        String description = string2;
        return new IdSignature.CommonSignature(pkg, cls, memberId, proto.getFlags(), description);
    }

    private final IdSignature.AccessorSignature deserializeAccessorIdSignature(AccessorIdSignature proto) {
        String string2;
        ksp.org.jetbrains.kotlin.ir.util.IdSignature propertySignature = this.deserializeIdSignature(proto.getPropertySignature());
        if (!(propertySignature instanceof IdSignature.CommonSignature)) {
            boolean $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = false;
            String $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = "For public accessor corresponding property supposed to be public as well";
            throw new IllegalArgumentException($i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22.toString());
        }
        String name2 = this.libraryFile.string(proto.getName());
        long hash = proto.getAccessorHashId();
        long mask = proto.getFlags();
        if (proto.hasDebugInfo()) {
            String string3 = this.libraryFile.debugInfo(proto.getDebugInfo());
            if (string3 != null) {
                String string4 = string3;
                IrInterningService irInterningService = this.irInterner;
                String p0 = string4;
                boolean bl = false;
                string2 = irInterningService.string(p0);
            } else {
                string2 = null;
            }
        } else {
            string2 = null;
        }
        String description = string2;
        String declarationFqName = this.irInterner.string(((IdSignature.CommonSignature)propertySignature).getDeclarationFqName() + '.' + name2);
        IdSignature.CommonSignature accessorSignature = new IdSignature.CommonSignature(((IdSignature.CommonSignature)propertySignature).getPackageFqName(), declarationFqName, hash, mask, description);
        return new IdSignature.AccessorSignature(propertySignature, accessorSignature);
    }

    private final ksp.org.jetbrains.kotlin.ir.util.IdSignature deserializeFileLocalIdSignature(FileLocalIdSignature proto) {
        return new IdSignature.FileLocalSignature(this.deserializeIdSignature(proto.getContainer()), proto.getLocalId(), null, 4, null);
    }

    private final ksp.org.jetbrains.kotlin.ir.util.IdSignature deserializeScopeLocalIdSignature(int proto) {
        return new IdSignature.ScopeLocalDeclaration(proto, null, 2, null);
    }

    private final IdSignature.CompositeSignature deserializeCompositeIdSignature(CompositeSignature proto) {
        ksp.org.jetbrains.kotlin.ir.util.IdSignature containerSig = this.deserializeIdSignature(proto.getContainerSig());
        ksp.org.jetbrains.kotlin.ir.util.IdSignature innerSig = this.deserializeIdSignature(proto.getInnerSig());
        return new IdSignature.CompositeSignature(containerSig, innerSig);
    }

    private final IdSignature.LocalSignature deserializeLocalIdSignature(LocalSignature proto) {
        List<Integer> list = proto.getLocalFqNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLocalFqNameList(...)");
        String localFqn = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list));
        Long localHash = proto.hasLocalHash() ? Long.valueOf(proto.getLocalHash()) : null;
        String description = proto.hasDebugInfo() ? this.libraryFile.debugInfo(proto.getDebugInfo()) : null;
        return new IdSignature.LocalSignature(localFqn, localHash, description);
    }

    private final IdSignature.FileSignature deserializeFileIdSignature(FileSignature proto) {
        IdSignature.FileSignature fileSignature = this.fileSignature;
        if (fileSignature == null) {
            throw new IllegalStateException("Provide file symbol".toString());
        }
        return fileSignature;
    }

    private final ksp.org.jetbrains.kotlin.ir.util.IdSignature deserializeSignatureData(IdSignature proto) {
        ksp.org.jetbrains.kotlin.ir.util.IdSignature idSignature;
        IdSignature.IdSigCase idSigCase = proto.getIdSigCase();
        switch (idSigCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[idSigCase.ordinal()]) {
            case 1: {
                CommonIdSignature commonIdSignature = proto.getPublicSig();
                Intrinsics.checkNotNullExpressionValue((Object)commonIdSignature, (String)"getPublicSig(...)");
                idSignature = this.deserializePublicIdSignature(commonIdSignature);
                break;
            }
            case 2: {
                AccessorIdSignature accessorIdSignature = proto.getAccessorSig();
                Intrinsics.checkNotNullExpressionValue((Object)accessorIdSignature, (String)"getAccessorSig(...)");
                idSignature = this.deserializeAccessorIdSignature(accessorIdSignature);
                break;
            }
            case 3: {
                FileLocalIdSignature fileLocalIdSignature = proto.getPrivateSig();
                Intrinsics.checkNotNullExpressionValue((Object)fileLocalIdSignature, (String)"getPrivateSig(...)");
                idSignature = this.deserializeFileLocalIdSignature(fileLocalIdSignature);
                break;
            }
            case 4: {
                idSignature = this.deserializeScopeLocalIdSignature(proto.getScopedLocalSig());
                break;
            }
            case 5: {
                CompositeSignature compositeSignature = proto.getCompositeSig();
                Intrinsics.checkNotNullExpressionValue((Object)compositeSignature, (String)"getCompositeSig(...)");
                idSignature = this.deserializeCompositeIdSignature(compositeSignature);
                break;
            }
            case 6: {
                LocalSignature localSignature = proto.getLocalSig();
                Intrinsics.checkNotNullExpressionValue((Object)localSignature, (String)"getLocalSig(...)");
                idSignature = this.deserializeLocalIdSignature(localSignature);
                break;
            }
            case 7: {
                FileSignature fileSignature = proto.getFileSig();
                Intrinsics.checkNotNullExpressionValue((Object)fileSignature, (String)"getFileSig(...)");
                idSignature = this.deserializeFileIdSignature(fileSignature);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected IdSignature kind: " + proto.getIdSigCase()).toString());
            }
        }
        return idSignature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ksp.org.jetbrains.kotlin.ir.util.IdSignature, Integer> signatureToIndexMapping() {
        void var2_2;
        void $this$associateTo$iv;
        if (this.signatureCache.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set<Map.Entry<Integer, ksp.org.jetbrains.kotlin.ir.util.IdSignature>> set = this.signatureCache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable = set;
        Map destination$iv = CollectionsKt.newHashMapWithExpectedSize(this.signatureCache.size());
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return var2_2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdSignature.IdSigCase.values().length];
            try {
                nArray[IdSignature.IdSigCase.PUBLIC_SIG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.ACCESSOR_SIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.PRIVATE_SIG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.SCOPED_LOCAL_SIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.COMPOSITE_SIG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.LOCAL_SIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.FILE_SIG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

