/*
 * Decompiled with CFR 0.152.
 */
package ksp.gnu.trove;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import ksp.gnu.trove.THash;

abstract class TIterator {
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    public TIterator(THash hash) {
        this._hash = hash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
    }

    public boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    public void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        this._hash.stopCompactingOnRemove();
        try {
            this._hash.removeAt(this._index);
        }
        finally {
            this._hash.startCompactingOnRemove(false);
        }
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected abstract int nextIndex();
}

