/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ksp.com.google.common.annotations.VisibleForTesting;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiCompiledElement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiEllipsisType;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiExpressionList;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiImportList;
import ksp.com.intellij.psi.PsiImportStatementBase;
import ksp.com.intellij.psi.PsiImportStaticStatement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiJavaFile;
import ksp.com.intellij.psi.PsiJavaParserFacade;
import ksp.com.intellij.psi.PsiJavaReference;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMember;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiMethodReferenceExpression;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.PsiNamedElement;
import ksp.com.intellij.psi.PsiPackage;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.ResolveResult;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import ksp.com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import ksp.com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import ksp.com.intellij.psi.impl.CheckUtil;
import ksp.com.intellij.psi.impl.PsiClassImplUtil;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import ksp.com.intellij.psi.impl.source.SourceJavaCodeReference;
import ksp.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import ksp.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import ksp.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import ksp.com.intellij.psi.impl.source.resolve.ResolveCache;
import ksp.com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositeElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.Factory;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaSourceUtil;
import ksp.com.intellij.psi.impl.source.tree.LeafElement;
import ksp.com.intellij.psi.impl.source.tree.SharedImplUtil;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import ksp.com.intellij.psi.infos.CandidateInfo;
import ksp.com.intellij.psi.scope.DelegatingScopeProcessor;
import ksp.com.intellij.psi.scope.JavaScopeProcessorEvent;
import ksp.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.processor.MethodResolverProcessor;
import ksp.com.intellij.psi.scope.util.PsiScopesUtil;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.CharTable;
import ksp.com.intellij.util.Function;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.NullableFunction;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiReferenceExpressionImpl
extends ExpressionPsiElement
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance(PsiReferenceExpressionImpl.class);
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private static final Function<PsiReferenceExpressionImpl, PsiType> TYPE_EVALUATOR = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        String qualifiedName2;
        if (qualifierClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((qualifiedName2 = qualifierClass.getQualifiedName()) == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile2 = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile2 instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile2).getImportList();
            assert (importList != null) : containingFile2;
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManager manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getElementFactory(manager.getProject()).createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            LeafElement dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, manager);
            this.addInternal(dot, dot, SourceTreeToPsiMap.psiElementToTree(this.getParameterList()), Boolean.TRUE);
            this.addBefore(classRef, SourceTreeToPsiMap.treeElementToPsi(dot));
        }
        return this;
    }

    public static void bindToElementViaStaticImport(@NotNull PsiClass qualifierClass, @NotNull String staticName, @NotNull PsiImportList importList) throws IncorrectOperationException {
        if (qualifierClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(1);
        }
        if (staticName == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(2);
        }
        if (importList == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(3);
        }
        String qualifiedName2 = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName2);
        JavaFileCodeStyleFacade javaCodeStyleSettingsFacade = JavaFileCodeStyleFacade.forContext(importList.getContainingFile());
        if (!javaCodeStyleSettingsFacade.isToImportOnDemand(qualifiedName2) && refs.size() + 1 < javaCodeStyleSettingsFacade.getNamesCountToUseImportOnDemand() || JavaCodeStyleManager.getInstance(qualifierClass.getProject()).hasConflictingOnDemandImport((PsiJavaFile)importList.getContainingFile(), qualifierClass, staticName)) {
            importList.add(JavaPsiFacade.getElementFactory(qualifierClass.getProject()).createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add(JavaPsiFacade.getElementFactory(qualifierClass.getProject()).createImportStaticStatement(qualifierClass, "*"));
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className) {
        if (importList == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(4);
        }
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual(psiClass.getQualifiedName(), className)) continue;
            array.add(staticStatement.getImportReference());
        }
        ArrayList<PsiJavaCodeReferenceElement> arrayList = array;
        if (arrayList == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else {
            if (oldQualifier == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
                TreeElement dot = (TreeElement)this.findChildByRole(55);
                if (dot == null) {
                    dot = Factory.createSingleLeafElement(JavaTokenType.DOT, ".", 0, 1, treeCharTab, this.getManager());
                    dot = this.addInternal(dot, dot, this.getFirstChildNode(), Boolean.TRUE);
                }
                this.addBefore(newQualifier, dot.getPsi());
            }
            this.getQualifierExpression().replace(newQualifier);
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public String getReferenceName() {
        PsiElement element2 = this.getReferenceNameElement();
        return element2 != null ? element2.getText() : null;
    }

    @Override
    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
        super.clearCaches();
    }

    private JavaResolveResult @NotNull [] resolve(IElementType parentType, @NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(6);
        }
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            PsiElement classNameElement;
            JavaResolveResult[] variable = null;
            JavaResolveResult[] result2 = this.resolveToVariable(containingFile2);
            if (result2.length == 1 && result2[0].isAccessible()) {
                if (result2 == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(7);
                }
                return result2;
            }
            if (result2.length > 0) {
                variable = result2;
            }
            if (!((classNameElement = this.getReferenceNameElement()) instanceof PsiIdentifier)) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiReferenceExpressionImpl.$$$reportNull$$$0(8);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result2 = this.resolveToClass(classNameElement, containingFile2);
            if (result2.length == 1 && !result2[0].isAccessible()) {
                JavaResolveResult[] packageResult = this.resolveToPackage(containingFile2);
                if (packageResult.length != 0) {
                    result2 = packageResult;
                }
            } else if (result2.length == 0) {
                result2 = this.resolveToPackage(containingFile2);
            }
            if (result2.length == 0 && variable == null) {
                result2 = PsiJavaCodeReferenceElementImpl.tryClassResult(this.getCachedNormalizedText(), this);
            }
            JavaResolveResult[] javaResolveResultArray = result2.length == 0 && variable != null ? variable : result2;
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(9);
            }
            return javaResolveResultArray;
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            return this.resolveToMethod(containingFile2);
        }
        if (parentType == JavaElementType.METHOD_REF_EXPRESSION) {
            if (((PsiMethodReferenceExpression)this.getParent()).isConstructor()) {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (classNameElement == null) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        PsiReferenceExpressionImpl.$$$reportNull$$$0(10);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                return this.resolveToClass(classNameElement, containingFile2);
            }
            return this.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile2);
        }
        return this.resolveToVariable(containingFile2);
    }

    private JavaResolveResult @NotNull [] resolveToMethod(@NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(11);
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor = new MethodResolverProcessor(methodCall, containingFile2);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(12);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(13);
        }
        return javaResolveResultArray;
    }

    private JavaResolveResult @NotNull [] resolveToPackage(@NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(14);
        }
        String packageName2 = this.getCachedNormalizedText();
        Project project = containingFile2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiPackage aPackage = psiFacade.findPackage(packageName2);
        if (aPackage == null) {
            JavaResolveResult[] javaResolveResultArray = psiFacade.isPartOfPackagePrefix(packageName2) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
            if (javaResolveResultArray == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(15);
            }
            return javaResolveResultArray;
        }
        PsiExpression qualifier2 = this.getQualifierExpression();
        if (qualifier2 instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifier2).resolve() instanceof PsiPackage)) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(16);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        JavaResolveResult[] javaResolveResultArray = new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY, this, false)};
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(17);
        }
        return javaResolveResultArray;
    }

    private JavaResolveResult @NotNull [] resolveToClass(@NotNull PsiElement classNameElement, @NotNull PsiFile containingFile2) {
        if (classNameElement == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(18);
        }
        if (containingFile2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(19);
        }
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, this, containingFile2);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(20);
        }
        return javaResolveResultArray;
    }

    private JavaResolveResult @NotNull [] resolveToVariable(@NotNull PsiFile containingFile2) {
        if (containingFile2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(21);
        }
        VariableResolverProcessor processor = new VariableResolverProcessor(this, containingFile2);
        PsiScopesUtil.resolveAndWalk(processor, this, null);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(22);
        }
        return javaResolveResultArray;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray = PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
        if (javaResolveResultArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(23);
        }
        return javaResolveResultArray;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String fqn;
        PsiElement element2 = this.resolve();
        if (element2 instanceof PsiClass && (fqn = ((PsiClass)element2).getQualifiedName()) != null) {
            String string2 = fqn;
            if (string2 == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(24);
            }
            return string2;
        }
        return this.getCachedNormalizedText();
    }

    @Override
    public PsiType getType() {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)parent2).getType();
        }
        return JavaResolveCache.getInstance(this.getProject()).getType(this, TYPE_EVALUATOR);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element2) {
        PsiElement parent2;
        boolean parentIsMethodCall;
        if (element2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(25);
        }
        IElementType i = this.getLastChildNode().getElementType();
        boolean resolvingToMethod = element2 instanceof PsiMethod;
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element2 instanceof PsiPackage)) {
                if (!(element2 instanceof PsiNamedElement)) {
                    return false;
                }
                String name2 = ((PsiNamedElement)element2).getName();
                if (name2 == null) {
                    return false;
                }
                if (!name2.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!resolvingToMethod) {
                return false;
            }
            if (!((PsiMethod)element2).isConstructor()) {
                return false;
            }
        }
        if ((parentIsMethodCall = (parent2 = this.getParent()) instanceof PsiMethodCallExpression) != resolvingToMethod) {
            return false;
        }
        return element2.getManager().areElementsEquivalent(element2, this.advancedResolve(true).getElement());
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(26);
        }
        DelegatingScopeProcessor filterProcessor = new DelegatingScopeProcessor(processor){
            private PsiElement myResolveContext;
            private final Set<String> myVarNames;
            {
                this.myVarNames = new HashSet<String>();
            }

            @Override
            public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !this.shouldProcess(element2) || super.execute(element2, state);
            }

            private boolean shouldProcess(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (element2 instanceof PsiVariable) {
                    return this.ensureNonShadowedVariable((PsiVariable)element2);
                }
                if (element2 instanceof PsiClass) {
                    return !PsiReferenceExpressionImpl.seemsScrambled((PsiClass)element2);
                }
                if (element2 instanceof PsiPackage) {
                    return PsiReferenceExpressionImpl.this.isQualified();
                }
                if (element2 instanceof PsiMethod) {
                    return this.shouldProcessMethod((PsiMethod)element2);
                }
                return false;
            }

            private boolean ensureNonShadowedVariable(@NotNull PsiVariable element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (PsiUtil.isJvmLocalVariable(element2) && this.myVarNames.contains(element2.getName())) {
                    return false;
                }
                this.myVarNames.add(element2.getName());
                return true;
            }

            private boolean shouldProcessMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(4);
                }
                PsiReferenceExpressionImpl ref = PsiReferenceExpressionImpl.this;
                return !method.isConstructor() && PsiReferenceExpressionImpl.hasValidQualifier(method, ref, this.myResolveContext);
            }

            @Override
            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
                    this.myResolveContext = (PsiElement)associated;
                }
                super.handleEvent(event, associated);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldProcess";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "ensureNonShadowedVariable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldProcessMethod";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiScopesUtil.resolveAndWalk(filterProcessor, this, null, true);
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        JavaResolveResult javaResolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(27);
        }
        return javaResolveResult;
    }

    private static boolean hasValidQualifier(@NotNull PsiMethod method, @NotNull PsiReferenceExpression ref, PsiElement scope) {
        PsiClass containingClass;
        if (method == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(28);
        }
        if (ref == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(29);
        }
        if ((containingClass = method.getContainingClass()) != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!PsiUtil.getLanguageLevel(ref).isAtLeast(LanguageLevel.JDK_1_8)) {
                return false;
            }
            PsiExpression qualifierExpression = ref.getQualifierExpression();
            if (qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, ref, true))) {
                return true;
            }
            if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (containingClass.getManager().areElementsEquivalent(resolve2, containingClass)) {
                    return true;
                }
                if (resolve2 instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                        PsiClass aClass = type2.resolve();
                        if (aClass == null) continue;
                        classes.add(aClass);
                    }
                    if (classes.size() == 1 && classes.contains(containingClass)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean seemsScrambled(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement && PsiReferenceExpressionImpl.seemsScrambledByStructure(aClass);
    }

    @VisibleForTesting
    public static boolean seemsScrambledByStructure(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(30);
        }
        if ((containingClass = aClass.getContainingClass()) != null && !PsiReferenceExpressionImpl.seemsScrambledByStructure(containingClass)) {
            return false;
        }
        if (PsiReferenceExpressionImpl.seemsScrambled(aClass.getName())) {
            List<PsiMethod> methods = ContainerUtil.filter(aClass.getMethods(), method -> !method.hasModifierProperty("private"));
            return !methods.isEmpty() && ContainerUtil.and(methods, method -> PsiReferenceExpressionImpl.seemsScrambled(method.getName()));
        }
        return false;
    }

    private static boolean seemsScrambled(String name2) {
        return name2 != null && !name2.isEmpty() && name2.length() <= 2;
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return PsiTreeUtil.getChildOfType(this, PsiReferenceParameterList.class);
    }

    @Override
    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList2 = this.getParameterList();
        PsiType[] psiTypeArray = parameterList2 != null ? parameterList2.getTypeArguments() : PsiType.EMPTY_ARRAY;
        if (psiTypeArray == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(31);
        }
        return psiTypeArray;
    }

    @Override
    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    @Override
    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(32);
        }
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element2 = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element2, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
        PsiReferenceExpression expression2 = (PsiReferenceExpression)factory2.createExpressionFromText("X." + newElementName, this);
        PsiReferenceExpression result2 = (PsiReferenceExpression)this.replace(expression2);
        ((PsiReferenceExpression)result2.getQualifierExpression()).bindToElement(psiClass);
        PsiReferenceExpression psiReferenceExpression = result2;
        if (psiReferenceExpression == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(33);
        }
        return psiReferenceExpression;
    }

    @NotNull
    private PsiElement renameDirectly(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier;
        if (newElementName == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(34);
        }
        if ((oldIdentifier = this.findChildByRoleAsPsiElement(53)) == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || newElementName.equals(oldRefName)) {
            PsiReferenceExpressionImpl psiReferenceExpressionImpl = this;
            if (psiReferenceExpressionImpl == null) {
                PsiReferenceExpressionImpl.$$$reportNull$$$0(35);
            }
            return psiReferenceExpressionImpl;
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory(this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace(identifier);
        PsiReferenceExpressionImpl psiReferenceExpressionImpl = this;
        if (psiReferenceExpressionImpl == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(36);
        }
        return psiReferenceExpressionImpl;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(37);
        }
        CheckUtil.checkWritable(this);
        if (this.isReferenceTo(element2)) {
            return this;
        }
        PsiManager manager = this.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        PsiJavaParserFacade parserFacade = facade.getParserFacade();
        if (element2 instanceof PsiClass) {
            boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance(this.getProject()).useFQClassNames() && PsiReferenceExpressionImpl.isFullyQualified(this);
            String qName = ((PsiClass)element2).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element2).getName();
            } else {
                if (JavaPsiFacade.getInstance(manager.getProject()).findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                    return this;
                }
                if (facade.getResolveHelper().resolveReferencedClass(qName, this) == null && facade.getResolveHelper().resolveReferencedClass(StringUtil.getPackageName(qName), this) != null) {
                    qName = ((PsiClass)element2).getName();
                    assert (qName != null) : element2;
                }
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(manager.getProject());
            if (!preserveQualification) {
                ref = (PsiExpression)codeStyleManager.shortenClassReferences(ref, 8192);
            }
            return ref;
        }
        if (element2 instanceof PsiPackage) {
            String qName = ((PsiPackage)element2).getQualifiedName();
            if (qName.isEmpty()) {
                throw new IncorrectOperationException();
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        if ((element2 instanceof PsiField || element2 instanceof PsiMethod) && ((PsiMember)element2).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element2;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            PsiExpression ref = parserFacade.createExpressionFromText(qName, this);
            this.getTreeParent().replaceChildInternal(this, (TreeElement)ref.getNode());
            return ref;
        }
        throw new IncorrectOperationException(element2.toString());
    }

    private static boolean isFullyQualified(@NotNull CompositeElement classRef) {
        if (classRef == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(38);
        }
        ASTNode qualifier2;
        while ((qualifier2 = classRef.findChildByRole(54)) != null) {
            if (qualifier2.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
                return false;
            }
            PsiElement refElement = ((PsiReference)((Object)qualifier2)).resolve();
            if (refElement instanceof PsiPackage) {
                return true;
            }
            classRef = (CompositeElement)qualifier2;
        }
        return false;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(39);
        }
        if (this.getChildRole(child) == 54) {
            ASTNode start;
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            TreeElement first = this.getFirstChildNode();
            if (this.getChildRole(first) == 246 && first.getFirstChildNode() == null && PsiImplUtil.isWhitespaceOrComment(start = first.getTreeNext())) {
                ASTNode next = PsiImplUtil.skipWhitespaceAndComments(start);
                assert (next != null) : this;
                CodeEditUtil.removeChildren(this, start, next.getTreePrev());
            }
        } else if (child.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
            this.replaceChildInternal(child, PsiReferenceExpressionImpl.createEmptyRefParameterList(this.getProject()));
        } else {
            super.deleteChildInternal(child);
        }
    }

    @NotNull
    public static TreeElement createEmptyRefParameterList(@NotNull Project project) {
        if (project == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(40);
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
        TreeElement treeElement = (TreeElement)Objects.requireNonNull(factory2.createReferenceFromText("foo", null).getParameterList()).getNode();
        if (treeElement == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(41);
        }
        return treeElement;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild == null || this.getChildRole(lastChild) == role ? lastChild : this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                return firstChild != null && this.getChildRole(firstChild) == 54 ? firstChild : null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(42);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    @Override
    public PsiReference getReference() {
        return this.getReferenceNameElement() != null ? this : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(43);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiReferenceExpressionImpl psiReferenceExpressionImpl = this;
        if (psiReferenceExpressionImpl == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(44);
        }
        return psiReferenceExpressionImpl;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
        if (textRange == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(45);
        }
        return textRange;
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    @NotNull
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName(this.getCachedNormalizedText(), false);
        }
        String string2 = cachedQName;
        if (string2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(46);
        }
        return string2;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(47);
        }
        JavaSourceUtil.fullyQualifyReference(this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole(this.getFirstChildNode()) == 54;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string2 = this.getCanonicalText();
        if (string2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(48);
        }
        return string2;
    }

    @NotNull
    private String getCachedNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText(this);
        }
        String string2 = whiteSpaceAndComments;
        if (string2 == null) {
            PsiReferenceExpressionImpl.$$$reportNull$$$0(49);
        }
        return string2;
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameElement";
                break;
            }
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportsFromClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToMethod";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToPackage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToVariable";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "advancedResolve";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "renameDirectly";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyRefParameterList";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameText";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedNormalizedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElementViaStaticImport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportsFromClass";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveToMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveToPackage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveToClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveToVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processVariants";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasValidQualifier";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "seemsScrambledByStructure";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "renameDirectly";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFullyQualified";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyRefParameterList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "fullyQualify";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeEvaluator
    implements NullableFunction<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        public PsiType fun(@NotNull PsiReferenceExpressionImpl expr) {
            PsiType ret;
            PsiElement resolve2;
            PsiFile file2;
            Project project;
            ResolveResult[] results;
            if (expr == null) {
                TypeEvaluator.$$$reportNull$$$0(0);
            }
            JavaResolveResult result2 = (results = ResolveCache.getInstance(project = (file2 = expr.getContainingFile()).getProject()).resolveWithCaching(expr, OurGenericsResolver.INSTANCE, true, false, file2)).length == 1 ? (JavaResolveResult)results[0] : null;
            PsiElement psiElement = resolve2 = result2 == null ? null : result2.getElement();
            if (resolve2 == null) {
                PsiType type2;
                ASTNode qualifier2;
                ASTNode refName = expr.findChildByRole(53);
                if (refName != null && "length".equals(refName.getText()) && (qualifier2 = expr.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier2.getElementType()) && (type2 = ((PsiExpression)SourceTreeToPsiMap.treeToPsiNotNull(qualifier2)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            if (!(resolve2 instanceof PsiVariable)) {
                return null;
            }
            PsiType type3 = ((PsiVariable)resolve2).getType();
            PsiType psiType = ret = type3 instanceof PsiEllipsisType ? ((PsiEllipsisType)type3).toArrayType() : type3;
            if (!ret.isValid()) {
                PsiUtil.ensureValidType(ret, "invalid type of " + resolve2 + " of class " + resolve2.getClass() + ", valid=" + resolve2.isValid());
            }
            PsiClass owner = null;
            if (resolve2 instanceof PsiField && !((PsiField)resolve2).hasModifierProperty("static")) {
                owner = ((PsiField)resolve2).getContainingClass();
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file2);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                if (owner == null || !PsiUtil.isRawSubstitutor(owner, substitutor2)) {
                    PsiType substitutedType = substitutor2.substitute(ret);
                    PsiUtil.ensureValidType(substitutedType);
                    PsiType normalized = PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, expr);
                    PsiUtil.ensureValidType(normalized);
                    return PsiClassImplUtil.correctType(normalized, expr.getResolveScope());
                }
            }
            return PsiClassImplUtil.correctType(TypeConversionUtil.erasure(ret), expr.getResolveScope());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$TypeEvaluator", "fun"));
        }
    }

    public static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        public static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        @Override
        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile2, boolean incompleteCode) {
            PsiReferenceExpressionImpl expression2;
            CompositeElement treeParent;
            if (ref == null) {
                OurGenericsResolver.$$$reportNull$$$0(0);
            }
            if (containingFile2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(1);
            }
            IElementType parentType = (treeParent = (expression2 = (PsiReferenceExpressionImpl)ref).getTreeParent()) == null ? null : treeParent.getElementType();
            List<ResolveResult[]> qualifiers = OurGenericsResolver.resolveAllQualifiers(expression2, containingFile2);
            ResolveResult[] result2 = expression2.resolve(parentType, containingFile2);
            if (result2.length == 0 && incompleteCode && parentType != JavaElementType.REFERENCE_EXPRESSION) {
                result2 = expression2.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile2);
            }
            JavaResolveUtil.substituteResults(expression2, (JavaResolveResult[])result2);
            ObjectUtils.reachabilityFence(qualifiers);
            if (result2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(2);
            }
            return result2;
        }

        @NotNull
        private static List<ResolveResult[]> resolveAllQualifiers(@NotNull PsiReferenceExpressionImpl expression2, final @NotNull PsiFile containingFile2) {
            PsiElement qualifier2;
            if (expression2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(3);
            }
            if (containingFile2 == null) {
                OurGenericsResolver.$$$reportNull$$$0(4);
            }
            if ((qualifier2 = expression2.getQualifier()) == null) {
                List<ResolveResult[]> list = Collections.emptyList();
                if (list == null) {
                    OurGenericsResolver.$$$reportNull$$$0(5);
                }
                return list;
            }
            final SmartList<ResolveResult[]> qualifiers = new SmartList<ResolveResult[]>();
            final ResolveCache resolveCache = ResolveCache.getInstance(containingFile2.getProject());
            final boolean physical = containingFile2.isPhysical();
            qualifier2.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    if (!(expression2 instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    ResolveResult[] cachedResults = resolveCache.getCachedResults(expression2, physical, false, true);
                    if (cachedResults != null) {
                        return;
                    }
                    this.visitElement(expression2);
                }

                @Override
                protected void elementFinished(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(element2 instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)element2;
                    qualifiers.add(resolveCache.resolveWithCaching(expression2, INSTANCE, true, false, containingFile2));
                }

                @Override
                public void visitExpressionList(PsiExpressionList list) {
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                @Override
                public void visitClass(PsiClass aClass) {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver$1", "elementFinished"));
                }
            });
            SmartList<ResolveResult[]> smartList = qualifiers;
            if (smartList == null) {
                OurGenericsResolver.$$$reportNull$$$0(6);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiReferenceExpressionImpl$OurGenericsResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveAllQualifiers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveAllQualifiers";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

