/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.pom.tree.events.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.pom.PomModelAspect;
import ksp.com.intellij.pom.event.PomChangeSet;
import ksp.com.intellij.pom.tree.events.TreeChange;
import ksp.com.intellij.pom.tree.events.TreeChangeEvent;
import ksp.com.intellij.pom.tree.events.impl.TreeChangeImpl;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.containers.JBIterable;
import ksp.com.intellij.util.containers.MultiMap;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TreeChangeEventImpl
implements TreeChangeEvent {
    private final Map<ASTNode, TreeChangeImpl> myChangedElements;
    private final MultiMap<ASTNode, TreeChangeImpl> myChangesByAllParents;
    private final PomModelAspect myAspect;
    private final FileASTNode myFileElement;

    public TreeChangeEventImpl(@NotNull PomModelAspect aspect, @NotNull FileASTNode treeElement) {
        if (aspect == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(0);
        }
        if (treeElement == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(1);
        }
        this.myChangedElements = new LinkedHashMap<ASTNode, TreeChangeImpl>();
        this.myChangesByAllParents = MultiMap.createSet();
        this.myAspect = aspect;
        this.myFileElement = treeElement;
    }

    @Override
    @NotNull
    public FileASTNode getRootElement() {
        FileASTNode fileASTNode = this.myFileElement;
        if (fileASTNode == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(2);
        }
        return fileASTNode;
    }

    @Override
    public ASTNode @NotNull [] getChangedElements() {
        ASTNode[] aSTNodeArray = this.myChangedElements.keySet().toArray(ASTNode.EMPTY_ARRAY);
        if (aSTNodeArray == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(3);
        }
        return aSTNodeArray;
    }

    @Override
    public TreeChange getChangesByElement(@NotNull ASTNode element2) {
        if (element2 == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(4);
        }
        return this.myChangedElements.get(element2);
    }

    public void addElementaryChange(@NotNull ASTNode parent2) {
        TreeChangeImpl existing;
        if (parent2 == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(5);
        }
        if ((existing = this.myChangedElements.get(parent2)) != null) {
            existing.clearCache();
        } else if (!this.integrateIntoExistingChanges(parent2)) {
            this.mergeChange(new TreeChangeImpl(parent2));
        }
    }

    private boolean integrateIntoExistingChanges(ASTNode nextParent) {
        for (ASTNode eachParent : JBIterable.generate(nextParent, ASTNode::getTreeParent)) {
            ASTNode superParent = eachParent.getTreeParent();
            TreeChangeImpl superChange = this.myChangedElements.get(superParent);
            if (superChange == null) continue;
            superChange.markChildChanged(eachParent, 0);
            return true;
        }
        return false;
    }

    private void mergeChange(TreeChangeImpl nextChange) {
        ASTNode newParent = nextChange.getChangedParent();
        for (TreeChangeImpl descendant : new ArrayList<TreeChangeImpl>(this.myChangesByAllParents.get(newParent))) {
            ASTNode ancestorChild = TreeChangeEventImpl.findAncestorChild(newParent, descendant);
            if (ancestorChild != null) {
                nextChange.markChildChanged(ancestorChild, descendant.getLengthDelta());
            }
            this.unregisterChange(descendant);
        }
        this.registerChange(nextChange);
    }

    private void registerChange(TreeChangeImpl nextChange) {
        this.myChangedElements.put(nextChange.getChangedParent(), nextChange);
        for (ASTNode eachParent : nextChange.getSuperParents()) {
            this.myChangesByAllParents.putValue(eachParent, nextChange);
        }
    }

    private void unregisterChange(TreeChangeImpl change) {
        this.myChangedElements.remove(change.getChangedParent());
        for (ASTNode superParent : change.getSuperParents()) {
            this.myChangesByAllParents.remove(superParent, change);
        }
    }

    @Nullable
    private static ASTNode findAncestorChild(@NotNull ASTNode ancestor, @NotNull TreeChangeImpl change) {
        List<ASTNode> superParents;
        int index;
        if (ancestor == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(6);
        }
        if (change == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(7);
        }
        return (index = (superParents = change.getSuperParents()).indexOf(ancestor)) < 0 ? null : (index == 0 ? change.getChangedParent() : superParents.get(index - 1));
    }

    @Override
    @NotNull
    public PomModelAspect getAspect() {
        PomModelAspect pomModelAspect = this.myAspect;
        if (pomModelAspect == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(8);
        }
        return pomModelAspect;
    }

    @Override
    public void merge(@NotNull PomChangeSet next) {
        if (next == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(9);
        }
        for (TreeChangeImpl change : ((TreeChangeEventImpl)next).myChangedElements.values()) {
            TreeChangeImpl existing = this.myChangedElements.get(change.getChangedParent());
            if (existing != null) {
                existing.appendChanges(change);
                continue;
            }
            if (this.integrateIntoExistingChanges(change.getChangedParent())) continue;
            this.mergeChange(change);
        }
    }

    public void fireEvents() {
        List<TreeChangeImpl> changes = this.getSortedChanges();
        for (TreeChangeImpl change : changes) {
            change.fireEvents((PsiFile)this.myFileElement.getPsi());
        }
    }

    @NotNull
    public List<TreeChangeImpl> getSortedChanges() {
        List<TreeChangeImpl> list = ContainerUtil.sorted(this.myChangedElements.values());
        if (list == null) {
            TreeChangeEventImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public void beforeNestedTransaction() {
        for (TreeChangeImpl change : this.myChangedElements.values()) {
            change.getAffectedChildren();
        }
    }

    public String toString() {
        return new ArrayList<TreeChangeImpl>(this.myChangedElements.values()).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/pom/tree/events/impl/TreeChangeEventImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangesByElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addElementaryChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

