/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.Computable;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.RecursionGuard;
import ksp.com.intellij.openapi.util.StackOverflowPreventedException;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public final class RecursionManager {
    private static final Logger LOG = Logger.getInstance(RecursionManager.class);
    private static final ThreadLocal<CalculationStack> ourStack = ThreadLocal.withInitial(() -> new CalculationStack());
    private static final AtomicBoolean ourAssertOnPrevention = new AtomicBoolean();
    private static final AtomicBoolean ourAssertOnMissedCache = new AtomicBoolean();
    @NonNls
    private static final String[] toleratedFrames = new String[]{"ksp.com.intellij.psi.impl.source.xml.XmlAttributeImpl.getDescriptor(", "ksp.org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy.getAncestorsCaching(", "ksp.com.intellij.lang.aspectj.psi.impl.PsiInterTypeReferenceImpl.", "ksp.com.intellij.psi.impl.search.JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(", "ksp.com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker.doRunTask(", "ksp.com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser.chooseOverload(", "ksp.com.intellij.lang.javascript.psi.resolve.JSEvaluationCache.getElementType(", "ksp.com.intellij.lang.ecmascript6.psi.impl.ES6ImportSpecifierImpl.multiResolve(", "ksp.com.intellij.lang.javascript.psi.types.JSTypeBaseImpl.substitute(", "ksp.com.intellij.psi.ThreadLocalTypes.performWithTypes(", "ksp.com.intellij.xml.impl.schema.XmlNSDescriptorImpl.getRedefinedElementDescriptor(", "ksp.com.intellij.psi.impl.source.xml.XmlTagImpl.getDescriptor(", "ksp.com.intellij.psi.impl.source.xml.XmlTagDelegate.getNSDescriptor(", "ksp.com.intellij.xml.impl.schema.XmlNSDescriptorImpl.findTypeDescriptor(", "ksp.com.intellij.psi.impl.source.xml.XmlEntityRefImpl.doResolveEntity(", "ksp.com.intellij.xml.impl.dtd.XmlNSDescriptorImpl.getElementDescriptor(", "com.jetbrains.python.psi.PyKnownDecoratorUtil.resolveDecorator(", "com.jetbrains.python.psi.impl.references.PyReferenceImpl.multiResolve("};

    @Nullable
    public static <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, Computable<T> computation) {
        if (key == null) {
            RecursionManager.$$$reportNull$$$0(0);
        }
        return RecursionManager.createGuard(computation.getClass().getName()).doPreventingRecursion(key, memoize, computation);
    }

    @NotNull
    public static <Key> RecursionGuard<Key> createGuard(final @NonNls String id) {
        return new RecursionGuard<Key>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public <T, E extends Throwable> T computePreventingRecursion(@NotNull Key key, boolean memoize, @NotNull ThrowableComputable<T, E> computation) throws E {
                MemoizedValue memoized;
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (computation == null) {
                    1.$$$reportNull$$$0(1);
                }
                MyKey realKey = new MyKey(id, key, true);
                CalculationStack stack = (CalculationStack)ourStack.get();
                if (stack.checkReentrancy(realKey)) {
                    if (ourAssertOnPrevention.get()) {
                        throw new StackOverflowPreventedException("Endless recursion prevention occurred on " + key);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(new StackOverflowPreventedException("Endless recursion prevention occurred on " + key));
                    }
                    return null;
                }
                if (memoize && (memoized = (MemoizedValue)stack.intermediateCache.get(realKey)) != null) {
                    for (MyKey noCacheUntil : memoized.dependencies) {
                        stack.prohibitResultCaching(noCacheUntil);
                    }
                    return (T)memoized.value;
                }
                realKey = new MyKey(id, key, false);
                int sizeBefore = stack.progressMap.size();
                StackFrame frame = stack.beforeComputation(realKey);
                int sizeAfter = stack.progressMap.size();
                try {
                    T result2 = computation.compute();
                    if (memoize && frame.preventionsInside != null) {
                        stack.memoize(realKey, result2, frame.preventionsInside);
                    }
                    T t = result2;
                    return t;
                }
                finally {
                    try {
                        stack.afterComputation(realKey, sizeBefore, sizeAfter);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Throwable in afterComputation", e);
                    }
                    stack.checkDepth("4");
                }
            }

            @Override
            @NotNull
            public List<Key> currentStack() {
                ArrayList<Object> result2 = new ArrayList<Object>();
                for (MyKey pair : ((CalculationStack)ourStack.get()).progressMap.keySet()) {
                    if (!pair.guardId.equals(id)) continue;
                    result2.add(pair.userObject);
                }
                List list = Collections.unmodifiableList(result2);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public void prohibitResultCaching(@NotNull Object since) {
                if (since == null) {
                    1.$$$reportNull$$$0(3);
                }
                MyKey realKey = new MyKey(id, since, false);
                CalculationStack stack = (CalculationStack)ourStack.get();
                stack.prohibitResultCaching(realKey);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "computation";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ksp/com/intellij/openapi/util/RecursionManager$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "since";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ksp/com/intellij/openapi/util/RecursionManager$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "currentStack";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "computePreventingRecursion";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "prohibitResultCaching";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @ApiStatus.Internal
    public static void dropCurrentMemoizationCache() {
        ourStack.get().intermediateCache.clear();
    }

    @NotNull
    public static RecursionGuard.StackStamp markStack() {
        final int stamp = ourStack.get().reentrancyCount;
        return new RecursionGuard.StackStamp(){

            @Override
            public boolean mayCacheNow() {
                boolean result2;
                CalculationStack stack = (CalculationStack)ourStack.get();
                boolean bl = result2 = stamp == stack.reentrancyCount;
                if (!result2 && ourAssertOnMissedCache.get() && !stack.isCurrentNonCachingStillTolerated()) {
                    throw new CachingPreventedException(stack.preventions);
                }
                return result2;
            }
        };
    }

    @TestOnly
    public static void assertOnRecursionPrevention(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecursionManager.$$$reportNull$$$0(1);
        }
        RecursionManager.setFlag(parentDisposable, true, ourAssertOnPrevention);
    }

    private static void setFlag(@NotNull Disposable parentDisposable, final boolean toAssert, final AtomicBoolean flag) {
        boolean prev;
        if (parentDisposable == null) {
            RecursionManager.$$$reportNull$$$0(2);
        }
        if (toAssert == (prev = flag.get())) {
            return;
        }
        flag.set(toAssert);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                if (flag.get() != toAssert) {
                    throw new IllegalStateException("Non-nested assertion flag modifications");
                }
                flag.set(prev);
            }
        });
    }

    @TestOnly
    public static void disableAssertOnRecursionPrevention(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecursionManager.$$$reportNull$$$0(3);
        }
        RecursionManager.setFlag(parentDisposable, false, ourAssertOnPrevention);
    }

    @TestOnly
    public static void disableMissedCacheAssertions(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecursionManager.$$$reportNull$$$0(4);
        }
        RecursionManager.setFlag(parentDisposable, false, ourAssertOnMissedCache);
    }

    @TestOnly
    public static void assertOnMissedCache(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecursionManager.$$$reportNull$$$0(5);
        }
        RecursionManager.setFlag(parentDisposable, true, ourAssertOnMissedCache);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/util/RecursionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPreventingRecursion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnRecursionPrevention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlag";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disableAssertOnRecursionPrevention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "disableMissedCacheAssertions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOnMissedCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CachingPreventedException
    extends RuntimeException {
        CachingPreventedException(Map<MyKey, Throwable> preventions) {
            super("Caching disabled due to recursion prevention, please get rid of cyclic dependencies. Preventions: " + new ArrayList<MyKey>(preventions.keySet()), ContainerUtil.getFirstItem(preventions.values()));
        }
    }

    private static class StackFrame {
        int reentrancyStamp;
        @Nullable
        Set<MyKey> preventionsInside;

        private StackFrame() {
        }

        void addPrevention(int stamp, MyKey prevented) {
            this.reentrancyStamp = stamp;
            if (this.preventionsInside == null) {
                this.preventionsInside = new HashSet<MyKey>();
            }
            this.preventionsInside.add(prevented);
        }
    }

    private static class MemoizedValue {
        final Object value;
        final MyKey[] dependencies;

        MemoizedValue(Object value2, MyKey[] dependencies) {
            this.value = value2;
            this.dependencies = dependencies;
        }
    }

    private static final class CalculationStack {
        private int reentrancyCount;
        private int depth;
        private int firstLoopStart = Integer.MAX_VALUE;
        private final LinkedHashMap<MyKey, StackFrame> progressMap = new LinkedHashMap();
        private final Map<MyKey, Throwable> preventions = new IdentityHashMap<MyKey, Throwable>();
        private final Map<MyKey, MemoizedValue> intermediateCache = ContainerUtil.createSoftKeySoftValueMap();
        private int enters;
        private int exits;

        private CalculationStack() {
        }

        boolean checkReentrancy(MyKey realKey) {
            if (this.progressMap.containsKey(realKey)) {
                this.prohibitResultCaching(realKey);
                return true;
            }
            return false;
        }

        StackFrame beforeComputation(MyKey realKey) {
            ++this.enters;
            if (this.progressMap.isEmpty()) assert (this.reentrancyCount == 0) : "Non-zero stamp with empty stack: " + this.reentrancyCount;
            this.checkDepth("1");
            int sizeBefore = this.progressMap.size();
            StackFrame frame = new StackFrame();
            frame.reentrancyStamp = this.reentrancyCount;
            this.progressMap.put(realKey, frame);
            ++this.depth;
            this.checkDepth("2");
            int sizeAfter = this.progressMap.size();
            if (sizeAfter != sizeBefore + 1) {
                LOG.error("Key doesn't lead to the map size increase: " + sizeBefore + " " + sizeAfter + " " + realKey.userObject);
            }
            return frame;
        }

        void memoize(MyKey key, @Nullable Object result2, @NotNull Set<MyKey> preventionsInside) {
            if (preventionsInside == null) {
                CalculationStack.$$$reportNull$$$0(0);
            }
            this.intermediateCache.put(key, new MemoizedValue(result2, preventionsInside.toArray(new MyKey[0])));
        }

        void afterComputation(MyKey realKey, int sizeBefore, int sizeAfter) {
            ++this.exits;
            if (sizeAfter != this.progressMap.size()) {
                LOG.error("Map size changed: " + this.progressMap.size() + " " + sizeAfter + " " + realKey.userObject);
            }
            if (this.depth != this.progressMap.size()) {
                LOG.error("Inconsistent depth after computation; depth=" + this.depth + "; map=" + this.progressMap);
            }
            StackFrame value2 = (StackFrame)this.progressMap.remove(realKey);
            --this.depth;
            if (!this.preventions.isEmpty()) {
                this.preventions.remove(realKey);
            }
            if (this.depth <= this.firstLoopStart) {
                this.firstLoopStart = Integer.MAX_VALUE;
                this.intermediateCache.clear();
            }
            if (sizeBefore != this.progressMap.size()) {
                LOG.error("Map size doesn't decrease: " + this.progressMap.size() + " " + sizeBefore + " " + realKey.userObject);
            }
            this.reentrancyCount = value2.reentrancyStamp;
        }

        private void prohibitResultCaching(MyKey realKey) {
            ++this.reentrancyCount;
            ArrayList<Map.Entry<MyKey, StackFrame>> stack = new ArrayList<Map.Entry<MyKey, StackFrame>>(this.progressMap.entrySet());
            int loopStart = ContainerUtil.indexOf(stack, entry -> ((MyKey)entry.getKey()).equals(realKey));
            if (loopStart >= 0) {
                MyKey loopStartKey = (MyKey)((Map.Entry)stack.get(loopStart)).getKey();
                if (!this.preventions.containsKey(loopStartKey)) {
                    this.preventions.put(loopStartKey, ourAssertOnMissedCache.get() ? new StackOverflowPreventedException(null) : null);
                }
                for (int i = loopStart + 1; i < stack.size(); ++i) {
                    ((StackFrame)((Map.Entry)stack.get(i)).getValue()).addPrevention(this.reentrancyCount, loopStartKey);
                }
                if (LOG.isDebugEnabled() && loopStart < stack.size() - 1) {
                    LOG.debug("Recursion prevented for " + realKey + ", caching disabled for " + ContainerUtil.map(stack.subList(loopStart, stack.size()), Map.Entry::getKey));
                }
                if (this.firstLoopStart > loopStart) {
                    this.firstLoopStart = loopStart;
                    this.intermediateCache.clear();
                }
            }
        }

        private void checkDepth(String s) {
            int oldDepth = this.depth;
            if (oldDepth != this.progressMap.size()) {
                this.depth = this.progressMap.size();
                throw new AssertionError((Object)("_Inconsistent depth " + s + "; depth=" + oldDepth + "; enters=" + this.enters + "; exits=" + this.exits + "; map=" + this.progressMap));
            }
        }

        boolean isCurrentNonCachingStillTolerated() {
            return CalculationStack.isCurrentNonCachingStillTolerated(new Throwable()) || ContainerUtil.exists(this.preventions.values(), CalculationStack::isCurrentNonCachingStillTolerated);
        }

        private static boolean isCurrentNonCachingStillTolerated(Throwable t) {
            String trace = ExceptionUtil.getThrowableText(t);
            return ContainerUtil.exists(toleratedFrames, trace::contains);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preventionsInside", "ksp/com/intellij/openapi/util/RecursionManager$CalculationStack", "memoize"));
        }
    }

    private static class MyKey {
        final String guardId;
        final Object userObject;
        private final int myHashCode;
        private final boolean myCallEquals;

        MyKey(String guardId, @NotNull Object userObject, boolean mayCallEquals) {
            if (userObject == null) {
                MyKey.$$$reportNull$$$0(0);
            }
            this.guardId = guardId;
            this.userObject = userObject;
            LOG.assertTrue(!userObject.getClass().isArray(), "Arrays use the default hashCode/equals implementation");
            this.myHashCode = guardId.hashCode() * 31 + userObject.hashCode();
            this.myCallEquals = mayCallEquals;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyKey) || !this.guardId.equals(((MyKey)obj).guardId)) {
                return false;
            }
            if (this.userObject == ((MyKey)obj).userObject) {
                return true;
            }
            if (this.myCallEquals || ((MyKey)obj).myCallEquals) {
                return this.userObject.equals(((MyKey)obj).userObject);
            }
            return false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public String toString() {
            return this.guardId + "->" + this.userObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "ksp/com/intellij/openapi/util/RecursionManager$MyKey", "<init>"));
        }
    }
}

