/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.editor.impl;

import ksp.com.intellij.openapi.editor.RangeMarker;
import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.ex.DocumentEx;
import ksp.com.intellij.openapi.editor.ex.EditReadOnlyListener;
import ksp.com.intellij.openapi.editor.ex.LineIterator;
import ksp.com.intellij.openapi.editor.ex.RangeMarkerEx;
import ksp.com.intellij.openapi.editor.impl.LineSet;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.Processor;
import ksp.com.intellij.util.text.ImmutableCharSequence;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile SoftReference<LineSet> myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text, @Nullable LineSet lineSet, long stamp, @Nullable String string2) {
        void textString;
        if (text == null) {
            FrozenDocument.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myLineSet = lineSet == null ? null : new SoftReference<LineSet>(lineSet);
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference<void>(textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = SoftReference.dereference(this.myLineSet);
        if (lineSet == null) {
            lineSet = LineSet.createLineSet(this.myText);
            this.myLineSet = new SoftReference<LineSet>(lineSet);
        }
        LineSet lineSet2 = lineSet;
        if (lineSet2 == null) {
            FrozenDocument.$$$reportNull$$$0(1);
        }
        return lineSet2;
    }

    @NotNull
    public FrozenDocument applyEvent(@NotNull DocumentEvent event, int newStamp) {
        if (event == null) {
            FrozenDocument.$$$reportNull$$$0(2);
        }
        int offset = event.getOffset();
        int oldEnd = offset + event.getOldLength();
        ImmutableCharSequence newText = this.myText.replace(offset, oldEnd, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update(this.myText, offset, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.getLineSet().createIterator();
        if (lineIterator == null) {
            FrozenDocument.$$$reportNull$$$0(3);
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            FrozenDocument.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearLineModificationFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            FrozenDocument.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            FrozenDocument.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            FrozenDocument.$$$reportNull$$$0(7);
        }
        return true;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor) {
        if (processor == null) {
            FrozenDocument.$$$reportNull$$$0(8);
        }
        return true;
    }

    @Override
    @NotNull
    public String getText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string2 = s;
        if (string2 == null) {
            FrozenDocument.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            FrozenDocument.$$$reportNull$$$0(10);
        }
        String string2 = this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
        if (string2 == null) {
            FrozenDocument.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(12);
        }
        return immutableCharSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            FrozenDocument.$$$reportNull$$$0(13);
        }
        return immutableCharSequence;
    }

    @Override
    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    @Override
    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    @Override
    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    @Override
    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            FrozenDocument.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            FrozenDocument.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myStamp;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            FrozenDocument.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RangeMarker getRangeGuard(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            FrozenDocument.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            FrozenDocument.$$$reportNull$$$0(19);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            FrozenDocument.$$$reportNull$$$0(20);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/editor/impl/FrozenDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsSequence";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

