/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.mock;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ksp.com.intellij.diagnostic.ActivityCategory;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.components.ComponentManager;
import ksp.com.intellij.openapi.extensions.PluginDescriptor;
import ksp.com.intellij.openapi.extensions.PluginId;
import ksp.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import ksp.com.intellij.openapi.util.Condition;
import ksp.com.intellij.openapi.util.Conditions;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.UserDataHolderBase;
import ksp.com.intellij.util.ExceptionUtilRt;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.messages.ListenerDescriptor;
import ksp.com.intellij.util.messages.MessageBus;
import ksp.com.intellij.util.messages.MessageBusOwner;
import ksp.com.intellij.util.messages.impl.MessageBusFactoryImpl;
import ksp.com.intellij.util.pico.DefaultPicoContainer;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.picocontainer.MutablePicoContainer;
import ksp.org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus;
    private final DefaultPicoContainer myPicoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactoryImpl.createRootBus(this);
        this.myComponents = new HashMap();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.myPicoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent2){

            @Override
            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (componentKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + this);
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "ksp/com/intellij/mock/MockComponentManager$1", "getComponentInstance"));
            }
        };
        this.myPicoContainer.registerComponentInstance(this.getClass(), this);
        this.myExtensionArea = new ExtensionsAreaImpl(this);
        Disposer.register(parentDisposable, this);
    }

    @Override
    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        ExtensionsAreaImpl extensionsAreaImpl = this.myExtensionArea;
        if (extensionsAreaImpl == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    @Override
    public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        if (aClass == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        if (key == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        ExceptionUtilRt.rethrowUnchecked(error);
        return new RuntimeException(error);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message2, @NotNull PluginId pluginId) {
        if (message2 == null) {
            MockComponentManager.$$$reportNull$$$0(7);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(8);
        }
        return new RuntimeException(message2);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message2, @Nullable Throwable error, @NotNull PluginId pluginId, @Nullable Map<String, String> attachments) {
        if (message2 == null) {
            MockComponentManager.$$$reportNull$$$0(9);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(10);
        }
        return new RuntimeException(message2);
    }

    protected void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register(this, (Disposable)o);
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(11);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        this.myPicoContainer.unregisterComponent(serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        this.myPicoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation, @NotNull Disposable parentDisposable) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(18);
        }
        String key = serviceInterface.getName();
        this.registerService(serviceInterface, serviceImplementation);
        Disposer.register(parentDisposable, () -> this.myPicoContainer.unregisterComponent(key));
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance2) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(19);
        }
        if (instance2 == null) {
            MockComponentManager.$$$reportNull$$$0(20);
        }
        this.myComponents.put(interfaceClass, instance2);
        this.registerComponentInDisposer(instance2);
    }

    @Override
    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(21);
        }
        return (T)((o = this.myPicoContainer.getComponentInstance(interfaceClass)) != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T @NotNull [] getComponents(@NotNull Class<T> baseClass) {
        if (baseClass == null) {
            MockComponentManager.$$$reportNull$$$0(22);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            MockComponentManager.$$$reportNull$$$0(23);
        }
        T result2 = this.myPicoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result2);
        return result2;
    }

    @Override
    @NotNull
    public final MutablePicoContainer getPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myPicoContainer;
        if (defaultPicoContainer == null) {
            MockComponentManager.$$$reportNull$$$0(24);
        }
        return defaultPicoContainer;
    }

    @Override
    public boolean isInjectionForExtensionSupported() {
        return false;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(25);
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myMessageBus);
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(26);
        }
        return condition;
    }

    @Override
    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor) {
        if (descriptor == null) {
            MockComponentManager.$$$reportNull$$$0(27);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Class<T> loadClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(28);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(29);
        }
        Class<?> clazz = Class.forName(className);
        if (clazz == null) {
            MockComponentManager.$$$reportNull$$$0(30);
        }
        return clazz;
    }

    @Override
    @NotNull
    public ActivityCategory getActivityCategory(boolean isExtension) {
        ActivityCategory activityCategory = isExtension ? ActivityCategory.APP_EXTENSION : ActivityCategory.APP_SERVICE;
        if (activityCategory == null) {
            MockComponentManager.$$$reportNull$$$0(31);
        }
        return activityCategory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/mock/MockComponentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/mock/MockComponentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionArea";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClassWithConstructorInjection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

