/*
 * Decompiled with CFR 0.152.
 */
package ksp.javaslang.collection;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import ksp.javaslang.Tuple;
import ksp.javaslang.Tuple2;
import ksp.javaslang.Tuple3;
import ksp.javaslang.collection.AbstractIterator;
import ksp.javaslang.collection.Collections;
import ksp.javaslang.collection.HashSet;
import ksp.javaslang.collection.IteratorModule;
import ksp.javaslang.collection.LinearSeq;
import ksp.javaslang.collection.Map;
import ksp.javaslang.collection.Queue;
import ksp.javaslang.collection.Seq;
import ksp.javaslang.collection.Stream;
import ksp.javaslang.collection.Traversable;
import ksp.javaslang.collection.TreeSet;
import ksp.javaslang.control.Option;

public interface Iterator<T>
extends java.util.Iterator<T>,
Traversable<T> {
    @Deprecated
    public static final Iterator<Object> EMPTY = IteratorModule.EmptyIterator.INSTANCE;

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterable<? extends T> ... iterables) {
        Objects.requireNonNull(iterables, "iterables is null");
        if (iterables.length == 0) {
            return Iterator.empty();
        }
        return new IteratorModule.ConcatIterator(Stream.of(iterables).map(Iterator::ofAll).iterator());
    }

    public static <T> Iterator<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        Objects.requireNonNull(iterables, "iterables is null");
        if (!iterables.iterator().hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.ConcatIterator(Stream.ofAll(iterables).map(Iterator::ofAll).iterator());
    }

    public static <T> Iterator<T> empty() {
        return IteratorModule.EmptyIterator.INSTANCE;
    }

    public static <T> Iterator<T> narrow(Iterator<? extends T> iterator2) {
        return iterator2;
    }

    public static <T> Iterator<T> of(final T element2) {
        return new AbstractIterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T getNext() {
                this.hasNext = false;
                return element2;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> of(final T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements.length == 0) {
            return Iterator.empty();
        }
        return new AbstractIterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < elements.length;
            }

            @Override
            public T getNext() {
                return elements[this.index++];
            }
        };
    }

    public static <T> Iterator<T> ofAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Iterator) {
            return (Iterator)iterable;
        }
        return Iterator.ofAll(iterable.iterator());
    }

    public static <T> Iterator<T> ofAll(final java.util.Iterator<? extends T> iterator2) {
        Objects.requireNonNull(iterator2, "iterator is null");
        if (iterator2 instanceof Iterator) {
            return (Iterator)iterator2;
        }
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T getNext() {
                return iterator2.next();
            }
        };
    }

    public static Iterator<Boolean> ofAll(final boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Boolean>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Boolean getNext() {
                return array[this.i++];
            }
        };
    }

    public static Iterator<Byte> ofAll(final byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Byte>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Byte getNext() {
                return array[this.i++];
            }
        };
    }

    public static Iterator<Character> ofAll(final char[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Character>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Character getNext() {
                return Character.valueOf(array[this.i++]);
            }
        };
    }

    public static Iterator<Double> ofAll(final double[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Double>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Double getNext() {
                return array[this.i++];
            }
        };
    }

    public static Iterator<Float> ofAll(final float[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Float>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Float getNext() {
                return Float.valueOf(array[this.i++]);
            }
        };
    }

    public static Iterator<Integer> ofAll(final int[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Integer>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Integer getNext() {
                return array[this.i++];
            }
        };
    }

    public static Iterator<Long> ofAll(final long[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Long>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Long getNext() {
                return array[this.i++];
            }
        };
    }

    public static Iterator<Short> ofAll(final short[] array) {
        Objects.requireNonNull(array, "array is null");
        return new AbstractIterator<Short>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < array.length;
            }

            @Override
            public Short getNext() {
                return array[this.i++];
            }
        };
    }

    public static <T> Iterator<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f);
    }

    public static <T> Iterator<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s);
    }

    public static Iterator<Character> range(char from2, char toExclusive) {
        return Iterator.rangeBy(from2, toExclusive, 1);
    }

    public static Iterator<Character> rangeBy(char from2, char toExclusive, int step) {
        return Iterator.rangeBy((int)from2, (int)toExclusive, step).map((T i) -> Character.valueOf((char)i.shortValue()));
    }

    public static Iterator<Double> rangeBy(double from2, double toExclusive, double step) {
        BigDecimal fromDecimal = IteratorModule.BigDecimalHelper.asDecimal(from2);
        BigDecimal toDecimal = IteratorModule.BigDecimalHelper.asDecimal(toExclusive);
        BigDecimal stepDecimal = IteratorModule.BigDecimalHelper.asDecimal(step);
        return Iterator.rangeBy(fromDecimal, toDecimal, stepDecimal).map(BigDecimal::doubleValue);
    }

    public static Iterator<BigDecimal> rangeBy(final BigDecimal from2, final BigDecimal toExclusive, final BigDecimal step) {
        if (step.signum() == 0) {
            throw new IllegalArgumentException("step cannot be 0");
        }
        if (IteratorModule.BigDecimalHelper.areEqual(from2, toExclusive) || step.signum() == from2.subtract(toExclusive).signum()) {
            return Iterator.empty();
        }
        if (step.signum() > 0) {
            return new AbstractIterator<BigDecimal>(){
                BigDecimal i;
                {
                    this.i = from2;
                }

                @Override
                public boolean hasNext() {
                    return this.i.compareTo(toExclusive) < 0;
                }

                @Override
                public BigDecimal getNext() {
                    BigDecimal next2 = this.i;
                    this.i = next2.add(step);
                    return next2;
                }
            };
        }
        return new AbstractIterator<BigDecimal>(){
            BigDecimal i;
            {
                this.i = from2;
            }

            @Override
            public boolean hasNext() {
                return this.i.compareTo(toExclusive) > 0;
            }

            @Override
            public BigDecimal getNext() {
                BigDecimal next2 = this.i;
                this.i = next2.add(step);
                return next2;
            }
        };
    }

    public static Iterator<Integer> range(int from2, int toExclusive) {
        return Iterator.rangeBy(from2, toExclusive, 1);
    }

    public static Iterator<Integer> rangeBy(int from2, int toExclusive, int step) {
        int toInclusive = toExclusive - (step > 0 ? 1 : -1);
        return Iterator.rangeClosedBy(from2, toInclusive, step);
    }

    public static Iterator<Long> range(long from2, long toExclusive) {
        return Iterator.rangeBy(from2, toExclusive, 1L);
    }

    public static Iterator<Long> rangeBy(long from2, long toExclusive, long step) {
        long toInclusive = toExclusive - (long)(step > 0L ? 1 : -1);
        return Iterator.rangeClosedBy(from2, toInclusive, step);
    }

    public static Iterator<Character> rangeClosed(char from2, char toInclusive) {
        return Iterator.rangeClosedBy(from2, toInclusive, 1);
    }

    public static Iterator<Character> rangeClosedBy(char from2, char toInclusive, int step) {
        return Iterator.rangeClosedBy((int)from2, (int)toInclusive, step).map((T i) -> Character.valueOf((char)i.shortValue()));
    }

    public static Iterator<Double> rangeClosedBy(double from2, double toInclusive, double step) {
        if (from2 == toInclusive) {
            return Iterator.of(Double.valueOf(from2));
        }
        double toExclusive = step > 0.0 ? Math.nextUp(toInclusive) : Math.nextDown(toInclusive);
        return Iterator.rangeBy(from2, toExclusive, step);
    }

    public static Iterator<Integer> rangeClosed(int from2, int toInclusive) {
        return Iterator.rangeClosedBy(from2, toInclusive, 1);
    }

    public static Iterator<Integer> rangeClosedBy(final int from2, int toInclusive, final int step) {
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0");
        }
        if (from2 == toInclusive) {
            return Iterator.of(Integer.valueOf(from2));
        }
        if (Integer.signum(step) == Integer.signum(from2 - toInclusive)) {
            return Iterator.empty();
        }
        final int end = toInclusive - step;
        if (step > 0) {
            return new AbstractIterator<Integer>(){
                int i;
                {
                    this.i = from2 - step;
                }

                @Override
                public boolean hasNext() {
                    return this.i <= end;
                }

                @Override
                public Integer getNext() {
                    return this.i += step;
                }
            };
        }
        return new AbstractIterator<Integer>(){
            int i;
            {
                this.i = from2 - step;
            }

            @Override
            public boolean hasNext() {
                return this.i >= end;
            }

            @Override
            public Integer getNext() {
                return this.i += step;
            }
        };
    }

    public static Iterator<Long> rangeClosed(long from2, long toInclusive) {
        return Iterator.rangeClosedBy(from2, toInclusive, 1L);
    }

    public static Iterator<Long> rangeClosedBy(final long from2, long toInclusive, final long step) {
        if (step == 0L) {
            throw new IllegalArgumentException("step cannot be 0");
        }
        if (from2 == toInclusive) {
            return Iterator.of(Long.valueOf(from2));
        }
        if (Long.signum(step) == Long.signum(from2 - toInclusive)) {
            return Iterator.empty();
        }
        final long end = toInclusive - step;
        if (step > 0L) {
            return new AbstractIterator<Long>(){
                long i;
                {
                    this.i = from2 - step;
                }

                @Override
                public boolean hasNext() {
                    return this.i <= end;
                }

                @Override
                public Long getNext() {
                    return this.i += step;
                }
            };
        }
        return new AbstractIterator<Long>(){
            long i;
            {
                this.i = from2 - step;
            }

            @Override
            public boolean hasNext() {
                return this.i >= end;
            }

            @Override
            public Long getNext() {
                return this.i += step;
            }
        };
    }

    public static Iterator<Integer> from(final int value2) {
        return new AbstractIterator<Integer>(){
            private int next;
            {
                this.next = value2;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer getNext() {
                return this.next++;
            }
        };
    }

    public static Iterator<Integer> from(final int value2, final int step) {
        return new AbstractIterator<Integer>(){
            private int next;
            {
                this.next = value2;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer getNext() {
                int result2 = this.next;
                this.next += step;
                return result2;
            }
        };
    }

    public static Iterator<Long> from(final long value2) {
        return new AbstractIterator<Long>(){
            private long next;
            {
                this.next = value2;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Long getNext() {
                return this.next++;
            }
        };
    }

    public static Iterator<Long> from(final long value2, final long step) {
        return new AbstractIterator<Long>(){
            private long next;
            {
                this.next = value2;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Long getNext() {
                long result2 = this.next;
                this.next += step;
                return result2;
            }
        };
    }

    public static <T> Iterator<T> continually(final Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T getNext() {
                return supplier.get();
            }
        };
    }

    public static <T> Iterator<T> iterate(final T seed, final Function<? super T, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return new AbstractIterator<T>(){
            Function<? super T, ? extends T> nextFunc = s -> {
                this.nextFunc = f;
                return seed;
            };
            T current = null;

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T getNext() {
                this.current = this.nextFunc.apply(this.current);
                return this.current;
            }
        };
    }

    public static <T> Iterator<T> continually(final T t) {
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T getNext() {
                return t;
            }
        };
    }

    default public Iterator<T> concat(java.util.Iterator<? extends T> that) {
        Objects.requireNonNull(that, "that is null");
        if (!that.hasNext()) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.ofAll(that);
        }
        return Iterator.concat(this, Iterator.ofAll(that));
    }

    default public Iterator<T> intersperse(final T element2) {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            boolean insertElement = false;

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                if (this.insertElement) {
                    this.insertElement = false;
                    return element2;
                }
                this.insertElement = true;
                return that.next();
            }
        };
    }

    default public <U> U transform(Function<? super Iterator<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    default public <U> Iterator<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        if (this.isEmpty()) {
            return Iterator.empty();
        }
        final Iterator it1 = this;
        final java.util.Iterator<? extends U> it2 = that.iterator();
        return new AbstractIterator<Tuple2<T, U>>(){

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public Tuple2<T, U> getNext() {
                return Tuple.of(it1.next(), it2.next());
            }
        };
    }

    @Override
    default public <U> Iterator<Tuple2<T, U>> zipAll(Iterable<? extends U> that, final T thisElem, final U thatElem) {
        Objects.requireNonNull(that, "that is null");
        final java.util.Iterator<U> thatIt = that.iterator();
        if (this.isEmpty() && !thatIt.hasNext()) {
            return Iterator.empty();
        }
        final Iterator thisIt = this;
        return new AbstractIterator<Tuple2<T, U>>(){

            @Override
            public boolean hasNext() {
                return thisIt.hasNext() || thatIt.hasNext();
            }

            @Override
            public Tuple2<T, U> getNext() {
                Object v1 = thisIt.hasNext() ? thisIt.next() : thisElem;
                Object v2 = thatIt.hasNext() ? thatIt.next() : thatElem;
                return Tuple.of(v1, v2);
            }
        };
    }

    @Override
    default public Iterator<Tuple2<T, Long>> zipWithIndex() {
        if (this.isEmpty()) {
            return Iterator.empty();
        }
        final Iterator it1 = this;
        return new AbstractIterator<Tuple2<T, Long>>(){
            private long index = 0L;

            @Override
            public boolean hasNext() {
                return it1.hasNext();
            }

            @Override
            public Tuple2<T, Long> getNext() {
                return Tuple.of(it1.next(), this.index++);
            }
        };
    }

    @Override
    default public <T1, T2> Tuple2<Iterator<T1>, Iterator<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream source = Stream.ofAll(this.map(unzipper));
        return Tuple.of(source.map((T t) -> t._1).iterator(), source.map((T t) -> t._2).iterator());
    }

    @Override
    default public <T1, T2, T3> Tuple3<Iterator<T1>, Iterator<T2>, Iterator<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty(), Iterator.empty());
        }
        Stream source = Stream.ofAll(this.map(unzipper));
        return Tuple.of(source.map((T t) -> t._1).iterator(), source.map((T t) -> t._2).iterator(), source.map((T t) -> t._3).iterator());
    }

    @Override
    default public Iterator<T> distinct() {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator(this, HashSet.empty(), Function.identity());
    }

    @Override
    default public Iterator<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator(this, TreeSet.empty(comparator), Function.identity());
    }

    @Override
    default public <U> Iterator<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        return new IteratorModule.DistinctIterator<T, U>(this, HashSet.empty(), keyExtractor);
    }

    @Override
    default public Iterator<T> drop(final long n) {
        if (n <= 0L) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n;
            }

            @Override
            public boolean hasNext() {
                while (this.count > 0L && that.hasNext()) {
                    that.next();
                    --this.count;
                }
                return that.hasNext();
            }

            @Override
            public T getNext() {
                return that.next();
            }
        };
    }

    @Override
    default public Iterator<T> dropRight(final long n) {
        if (n <= 0L) {
            return this;
        }
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while ((long)this.queue.length() < n && that.hasNext()) {
                    this.queue = this.queue.append(that.next());
                }
                return (long)this.queue.length() == n && that.hasNext();
            }

            @Override
            public T getNext() {
                Tuple2 t = ((Queue)this.queue.append(that.next())).dequeue();
                this.queue = (Queue)t._2;
                return t._1;
            }
        };
    }

    @Override
    default public Iterator<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    default public Iterator<T> dropWhile(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private T next;
            private boolean cached = false;
            private boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.cached) {
                    return true;
                }
                if (this.first) {
                    this.first = false;
                    while (that.hasNext()) {
                        this.next = that.next();
                        if (predicate.test(this.next)) continue;
                        this.cached = true;
                        return true;
                    }
                    return false;
                }
                if (that.hasNext()) {
                    this.next = that.next();
                    this.cached = true;
                    return true;
                }
                return false;
            }

            @Override
            public T getNext() {
                this.cached = false;
                return this.next;
            }
        };
    }

    @Override
    default public Iterator<T> filter(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            Option<T> next = Option.none();

            @Override
            public boolean hasNext() {
                while (this.next.isEmpty() && that.hasNext()) {
                    Object candidate = that.next();
                    if (!predicate.test(candidate)) continue;
                    this.next = Option.some(candidate);
                }
                return this.next.isDefined();
            }

            @Override
            public T getNext() {
                Object result2 = this.next.get();
                this.next = Option.none();
                return result2;
            }
        };
    }

    @Override
    default public Option<T> findLast(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Object last = null;
        while (this.hasNext()) {
            Object elem = this.next();
            if (!predicate.test(elem)) continue;
            last = elem;
        }
        return Option.of(last);
    }

    @Override
    default public <U> Iterator<U> flatMap(final Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){
            final Iterator<? extends T> inputs;
            java.util.Iterator<? extends U> current;
            {
                this.inputs = that;
                this.current = java.util.Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = this.current.hasNext()) && this.inputs.hasNext()) {
                    this.current = ((Iterable)mapper.apply(this.inputs.next())).iterator();
                }
                return currentHasNext;
            }

            @Override
            public U getNext() {
                return this.current.next();
            }
        };
    }

    @Override
    default public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return Stream.ofAll(this).foldRight(zero, f);
    }

    @Override
    default public T get() {
        return this.head();
    }

    @Override
    default public <C> Map<C, Iterator<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, Iterator::ofAll);
    }

    @Override
    default public Iterator<Seq<T>> grouped(long size) {
        return new IteratorModule.GroupedIterator(this, (int)size, (int)size);
    }

    @Override
    default public boolean hasDefiniteSize() {
        return false;
    }

    @Override
    default public T head() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("head() on empty iterator");
        }
        return (T)this.next();
    }

    @Override
    default public Iterator<T> init() {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException();
        }
        return this.dropRight(1L);
    }

    @Override
    default public Option<Iterator<T>> initOption() {
        return this.hasNext() ? Option.some(this.init()) : Option.none();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    default public boolean isTraversableAgain() {
        return false;
    }

    @Override
    default public Iterator<T> iterator() {
        return this;
    }

    @Override
    default public int length() {
        return this.foldLeft(0, (n, ignored) -> n + 1);
    }

    @Override
    default public <U> Iterator<U> map(final Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public U getNext() {
                return mapper.apply(that.next());
            }
        };
    }

    @Override
    default public Tuple2<Iterator<T>, Iterator<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream that = Stream.ofAll(this);
        Traversable first = that.iterator().filter(predicate);
        Traversable second = that.iterator().filter(predicate.negate());
        return Tuple.of(first, second);
    }

    @Override
    default public Iterator<T> peek(final Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                Object next2 = that.next();
                action.accept(next2);
                return next2;
            }
        };
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceLeft on Nil");
        }
        Stream stream = Stream.ofAll(this);
        return stream.tail().foldLeft(stream.head(), op);
    }

    @Override
    default public T reduceRight(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceRight on Nil");
        }
        LinearSeq reversed = Stream.ofAll(this).reverse();
        return (T)reversed.tail().foldLeft(reversed.head(), (xs, x) -> op.apply(x, xs));
    }

    @Override
    default public Iterator<T> replace(final T currentElement, final T newElement) {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            boolean isFirst = true;

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                Object elem = that.next();
                if (this.isFirst && Objects.equals(currentElement, elem)) {
                    this.isFirst = false;
                    return newElement;
                }
                return elem;
            }
        };
    }

    @Override
    default public Iterator<T> replaceAll(final T currentElement, final T newElement) {
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){

            @Override
            public boolean hasNext() {
                return that.hasNext();
            }

            @Override
            public T getNext() {
                Object elem = that.next();
                if (Objects.equals(currentElement, elem)) {
                    return newElement;
                }
                return elem;
            }
        };
    }

    @Override
    default public Iterator<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.hasNext() ? this.filter(HashSet.ofAll(elements)::contains) : Iterator.empty();
    }

    @Override
    default public Traversable<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    default public <U> Iterator<U> scanLeft(final U zero, final BiFunction<? super U, ? super T, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        if (this.isEmpty()) {
            return Iterator.of(zero);
        }
        final Iterator that = this;
        return new AbstractIterator<U>(){
            boolean isFirst = true;
            U acc = zero;

            @Override
            public boolean hasNext() {
                return this.isFirst || that.hasNext();
            }

            @Override
            public U getNext() {
                if (this.isFirst) {
                    this.isFirst = false;
                    return this.acc;
                }
                this.acc = operation.apply(this.acc, that.next());
                return this.acc;
            }
        };
    }

    @Override
    default public <U> Iterator<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        if (this.isEmpty()) {
            return Iterator.of(zero);
        }
        return Collections.scanRight(this, zero, operation, Stream.empty(), Stream::prepend, Traversable::iterator);
    }

    @Override
    default public Iterator<Seq<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    default public Iterator<Seq<T>> sliding(long size, long step) {
        return new IteratorModule.GroupedIterator(this, (int)size, (int)step);
    }

    @Override
    default public Tuple2<Iterator<T>, Iterator<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Tuple.of(Iterator.empty(), Iterator.empty());
        }
        Stream that = Stream.ofAll(this);
        return Tuple.of(that.iterator().takeWhile(predicate), that.iterator().dropWhile(predicate));
    }

    @Override
    default public Spliterator<T> spliterator() {
        Stream stream = Stream.ofAll(this);
        return Spliterators.spliterator(stream.iterator(), (long)stream.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "Iterator";
    }

    @Override
    default public Iterator<T> tail() {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException();
        }
        this.next();
        return this;
    }

    @Override
    default public Option<Iterator<T>> tailOption() {
        if (this.hasNext()) {
            this.next();
            return Option.some(this);
        }
        return Option.none();
    }

    @Override
    default public Iterator<T> take(final long n) {
        if (n <= 0L || !this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            long count;
            {
                this.count = n;
            }

            @Override
            public boolean hasNext() {
                return this.count > 0L && that.hasNext();
            }

            @Override
            public T getNext() {
                --this.count;
                return that.next();
            }
        };
    }

    @Override
    default public Iterator<T> takeRight(final long n) {
        if (n <= 0L) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private Queue<T> queue = Queue.empty();

            @Override
            public boolean hasNext() {
                while (that.hasNext()) {
                    this.queue = this.queue.enqueue(that.next());
                    if ((long)this.queue.length() <= n) continue;
                    this.queue = (Queue)this.queue.dequeue()._2;
                }
                return this.queue.length() > 0;
            }

            @Override
            public T getNext() {
                Tuple2 t = this.queue.dequeue();
                this.queue = (Queue)t._2;
                return t._1;
            }
        };
    }

    @Override
    default public Iterator<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    default public Iterator<T> takeWhile(final Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (!this.hasNext()) {
            return Iterator.empty();
        }
        final Iterator that = this;
        return new AbstractIterator<T>(){
            private T next;
            private boolean cached = false;
            private boolean finished = false;

            @Override
            public boolean hasNext() {
                if (this.cached) {
                    return true;
                }
                if (this.finished) {
                    return false;
                }
                if (that.hasNext()) {
                    this.next = that.next();
                    if (predicate.test(this.next)) {
                        this.cached = true;
                        return true;
                    }
                }
                this.finished = true;
                return false;
            }

            @Override
            public T getNext() {
                this.cached = false;
                return this.next;
            }
        };
    }
}

