/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import ksp.com.intellij.core.JavaPsiBundle;
import ksp.com.intellij.psi.LambdaUtil;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiCodeBlock;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiLambdaExpression;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypes;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression2, PsiType t) {
        this.myExpression = expression2;
        this.myT = t;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(this.myT)));
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(this.myT)));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters2.length) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.parameter.types.in.lambda", parameters2.length, lambdaParameters.length));
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i = 0; i < lambdaParameters.length; ++i) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i].getType(), session.substituteWithInferenceVariables(substitutor2.substitute(parameters2[i].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter2 : parameters2) {
                    PsiType type3 = session.substituteWithInferenceVariables(substitutor2.substitute(parameter2.getType()));
                    if (session.isProperType(type3)) continue;
                    return false;
                }
            }
            PsiType returnType2 = interfaceMethod.getReturnType();
            if (returnType2 == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType2.equals(PsiTypes.voidType())) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.types.expected.void.lambda", new Object[0]));
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.expected.value.lambda", new Object[0]));
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session.getInferenceSubstitution());
                returnType2 = nestedSubstitutor.substitute(substitutor2.substitute(returnType2));
                boolean isProperType = InferenceSession.collectDependencies(returnType2, null, type2 -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type2);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type2) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (InferenceSession.ignoreLambdaConstraintTree(returnExpression)) continue;
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType2));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType2, returnExpression)) continue;
                        PsiType type4 = returnExpression.getType();
                        if (type4 != null) {
                            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.bad.lambda.return.type", session.getPresentableText(type4), session.getPresentableText(returnType2)));
                        } else {
                            session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type", returnExpression.getText(), session.getPresentableText(returnType2)));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

