/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeForwardDeclarationReifiedChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
public final class FirNativeForwardDeclarationReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirNativeForwardDeclarationReifiedChecker INSTANCE = new FirNativeForwardDeclarationReifiedChecker();

    private FirNativeForwardDeclarationReifiedChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments2 = expression2.getTypeArguments();
        Object object = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (object == null || (object = ((FirCallableSymbol)object).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters2 = object;
        int count = Math.min(typeArguments2.size(), typeParameters2.size());
        for (int index = 0; index < count; ++index) {
            ConeKotlinType typeArgument;
            FirTypeParameterSymbol typeParameter;
            FirTypeProjection typeArgumentProjection = typeArguments2.get(index);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            if (ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection)) == null || !(typeParameter = (FirTypeParameterSymbol)typeParameters2.get(index)).isReified()) continue;
            FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(typeArgument, context2.getSession());
            if ((firRegularClassSymbol != null ? FirNativeHelpersKt.forwardDeclarationKindOrNull(firRegularClassSymbol) : null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirNativeErrors.INSTANCE.getFORWARD_DECLARATION_AS_REIFIED_TYPE_ARGUMENT(), (Object)typeArgument, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

