/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.FileLoweringPass;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmIrInliner;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.MavenComparableVersion;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.IrProperty;
import ksp.org.jetbrains.kotlin.ir.declarations.IrScript;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import ksp.org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreak;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCatch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrClassReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrComposite;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConst;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrContinue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import ksp.org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetClass;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrLoop;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrThrow;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTry;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhen;
import ksp.org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@PhaseDescription(name="ApiVersionIsAtLeastEvaluationLowering", description="Evaluate inlined invocations of `apiVersionIsAtLeast`", prerequisite={JvmIrInliner.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001 B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\u00020\u001c*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lksp/org/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "apiVersion", "Lksp/org/jetbrains/kotlin/config/MavenComparableVersion;", "lower", "", "irFile", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrBlock;", "data", "visitFunction", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "isInInlineFunInKotlinRuntime", "", "currentFunction", "isApiVersionIsAtLeast", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "Data", "backend.jvm.lower"})
public final class ApiVersionIsAtLeastEvaluationLowering
implements FileLoweringPass,
IrElementTransformer<Data> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final MavenComparableVersion apiVersion;

    public ApiVersionIsAtLeastEvaluationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.apiVersion = this.context.getConfig().getLanguageVersionSettings().getApiVersion().getVersion();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getEnableIrInliner()) {
            irFile.accept(this, new Data(null, false));
        }
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, Data.copy$default(data, null, data.isInsideInlinedBlock() || expression2 instanceof IrInlinedFunctionBlock, 1, null));
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration2, Data.copy$default(data, declaration2, false, 2, null));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!data.isInsideInlinedBlock() || !this.isApiVersionIsAtLeast(expression2.getSymbol().getOwner()) || this.isInInlineFunInKotlinRuntime(data.getCurrentFunction())) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        Integer n = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 0);
        if (n == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int epic = n;
        Integer n2 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 1);
        if (n2 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int major = n2;
        Integer n3 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 2);
        if (n3 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int minor = n3;
        IrFunction currentFunction = data.getCurrentFunction();
        if (!(currentFunction != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, currentFunction.getSymbol(), 0, 0, 6, null);
        MavenComparableVersion versionArgument = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
        return this.apiVersion.compareTo(versionArgument) >= 0 ? (IrExpression)ExpressionHelpersKt.irTrue(builder2) : (IrExpression)ExpressionHelpersKt.irFalse(builder2);
    }

    private final boolean isInInlineFunInKotlinRuntime(IrFunction currentFunction) {
        return currentFunction != null && currentFunction.isInline() && IrUtilsKt.getPackageFragment(currentFunction).getPackageFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
    }

    private final boolean isApiVersionIsAtLeast(IrFunction $this$isApiVersionIsAtLeast) {
        return IrUtilsKt.isTopLevelInPackage($this$isApiVersionIsAtLeast, "apiVersionIsAtLeast", StandardNames.KOTLIN_INTERNAL_FQ_NAME) && $this$isApiVersionIsAtLeast.getValueParameters().size() == 3 && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(0).getType()) && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(1).getType()) && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(2).getType()) && $this$isApiVersionIsAtLeast.getDispatchReceiverParameter() == null && $this$isApiVersionIsAtLeast.getExtensionReceiverParameter() == null;
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element2, data);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "", "currentFunction", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "isInsideInlinedBlock", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Z)V", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm.lower"})
    public static final class Data {
        @Nullable
        private final IrFunction currentFunction;
        private final boolean isInsideInlinedBlock;

        public Data(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            this.currentFunction = currentFunction;
            this.isInsideInlinedBlock = isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction getCurrentFunction() {
            return this.currentFunction;
        }

        public final boolean isInsideInlinedBlock() {
            return this.isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction component1() {
            return this.currentFunction;
        }

        public final boolean component2() {
            return this.isInsideInlinedBlock;
        }

        @NotNull
        public final Data copy(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            return new Data(currentFunction, isInsideInlinedBlock);
        }

        public static /* synthetic */ Data copy$default(Data data, IrFunction irFunction, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                irFunction = data.currentFunction;
            }
            if ((n & 2) != 0) {
                bl = data.isInsideInlinedBlock;
            }
            return data.copy(irFunction, bl);
        }

        @NotNull
        public String toString() {
            return "Data(currentFunction=" + this.currentFunction + ", isInsideInlinedBlock=" + this.isInsideInlinedBlock + ')';
        }

        public int hashCode() {
            int result2 = this.currentFunction == null ? 0 : this.currentFunction.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInsideInlinedBlock);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.currentFunction, (Object)data.currentFunction)) {
                return false;
            }
            return this.isInsideInlinedBlock == data.isInsideInlinedBlock;
        }
    }
}

