/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import ksp.org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/DiagnosticsCollector;", "", "fileStructureCache", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;)V", "getDiagnosticsFor", "", "Lksp/org/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "element", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "filter", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "collectDiagnosticsForFile", "ktFile", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "low-level-api-fir"})
public final class DiagnosticsCollector {
    @NotNull
    private final FileStructureCache fileStructureCache;

    public DiagnosticsCollector(@NotNull FileStructureCache fileStructureCache) {
        Intrinsics.checkNotNullParameter((Object)fileStructureCache, (String)"fileStructureCache");
        this.fileStructureCache = fileStructureCache;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getDiagnosticsFor(@NotNull KtElement element2, @NotNull DiagnosticCheckerFilter filter) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        KtFile ktFile = element2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        FileStructureElement structureElement = fileStructure.getStructureElementFor(element2);
        FileStructureElementDiagnostics diagnostics = structureElement.getDiagnostics();
        return diagnostics.diagnosticsFor(filter, element2);
    }

    @NotNull
    public final List<KtPsiDiagnostic> collectDiagnosticsForFile(@NotNull KtFile ktFile, @NotNull DiagnosticCheckerFilter filter) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        FileStructure fileStructure = this.fileStructureCache.getFileStructure(ktFile);
        return fileStructure.getAllDiagnosticsForFile(filter);
    }
}

