/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtForExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JvmArrayVariableInLoopAssignmentChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isOuterForLoopRangeVariable", "", "variableDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "frontend.java"})
public final class JvmArrayVariableInLoopAssignmentChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final JvmArrayVariableInLoopAssignmentChecker INSTANCE = new JvmArrayVariableInLoopAssignmentChecker();

    private JvmArrayVariableInLoopAssignmentChecker() {
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType2, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType2, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (c.languageVersionSettings.supportsFeature(LanguageFeature.ProperForInArrayLoopRangeVariableAssignmentSemantic)) {
            return;
        }
        KtBinaryExpression ktBinaryExpression = expression2 instanceof KtBinaryExpression ? (KtBinaryExpression)expression2 : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhsExpression = ktSimpleNameExpression;
        KtElement ktElement = lhsExpression;
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        LocalVariableDescriptor localVariableDescriptor = callableDescriptor instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)callableDescriptor : null;
        if (localVariableDescriptor == null) {
            return;
        }
        LocalVariableDescriptor variableDescriptor = localVariableDescriptor;
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return;
        }
        if (variableDescriptor.isDelegated()) {
            return;
        }
        KotlinType kotlinType = variableDescriptor.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getReturnType(...)");
        KotlinType variableType = kotlinType;
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray(variableType)) {
            return;
        }
        if (!this.isOuterForLoopRangeVariable(expression2, variableDescriptor, c)) {
            return;
        }
        DataFlowValue.Kind dataFlowValueKind = c.dataFlowValueFactory.createDataFlowValue(lhsExpression, variableType, c).getKind();
        if (dataFlowValueKind != DataFlowValue.Kind.STABLE_VARIABLE) {
            return;
        }
        c.trace.report(ErrorsJvm.ASSIGNMENT_TO_ARRAY_LOOP_VARIABLE.on((KtExpression)((PsiElement)lhsExpression)));
    }

    private final boolean isOuterForLoopRangeVariable(KtExpression expression2, CallableDescriptor variableDescriptor, ResolutionContext<?> c) {
        for (PsiElement parent2 : PsiUtilsKt.getParents(expression2)) {
            ResolvedCall<? extends CallableDescriptor> rangeResolvedCall;
            KtSimpleNameExpression rangeExpression;
            KtExpression ktExpression;
            if (!(parent2 instanceof KtForExpression) || ((ktExpression = ((KtForExpression)parent2).getLoopRange()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null) == null) continue;
            rangeExpression = rangeExpression;
            KtElement ktElement = rangeExpression;
            BindingContext bindingContext = c.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || !Intrinsics.areEqual((Object)rangeResolvedCall.getResultingDescriptor(), (Object)variableDescriptor)) continue;
            return true;
        }
        return false;
    }
}

