/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.util.io.StringRef;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B/\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\b\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\f\u001a\u00028\u00002\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001bJ<\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H$J\u001e\u0010!\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0011\u001a\u00020\"H\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtConstructorElementType;", "T", "Lksp/org/jetbrains/kotlin/psi/KtConstructor;", "Lksp/org/jetbrains/kotlin/psi/stubs/elements/KtStubElementType;", "Lksp/org/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "debugName", "", "tClass", "Ljava/lang/Class;", "stubClass", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)V", "createStub", "psi", "parentStub", "Lksp/com/intellij/psi/stubs/StubElement;", "(Lorg/jetbrains/kotlin/psi/KtConstructor;Lcom/intellij/psi/stubs/StubElement;)Lorg/jetbrains/kotlin/psi/stubs/KotlinConstructorStub;", "deserialize", "dataStream", "Lksp/com/intellij/psi/stubs/StubInputStream;", "indexStub", "", "stub", "sink", "Lksp/com/intellij/psi/stubs/IndexSink;", "isDelegatedCallToThis", "", "constructor", "(Lorg/jetbrains/kotlin/psi/KtConstructor;)Z", "isExplicitDelegationCall", "newStub", "nameRef", "Lksp/com/intellij/util/io/StringRef;", "hasBody", "serialize", "Lksp/com/intellij/psi/stubs/StubOutputStream;"})
public abstract class KtConstructorElementType<T extends KtConstructor<T>>
extends KtStubElementType<KotlinConstructorStub<T>, T> {
    public KtConstructorElementType(@NonNls @NotNull String debugName, @NotNull Class<T> tClass, @NotNull Class<KotlinConstructorStub<?>> stubClass) {
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        Intrinsics.checkNotNullParameter(stubClass, (String)"stubClass");
        super(debugName, tClass, stubClass);
    }

    @NotNull
    protected abstract KotlinConstructorStub<T> newStub(@NotNull StubElement<?> var1, @Nullable StringRef var2, boolean var3, boolean var4, boolean var5);

    protected abstract boolean isDelegatedCallToThis(@NotNull T var1);

    protected abstract boolean isExplicitDelegationCall(@NotNull T var1);

    @Override
    @NotNull
    public KotlinConstructorStub<T> createStub(@NotNull T psi2, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter(psi2, (String)"psi");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        boolean hasBody = ((KtConstructor)psi2).hasBody();
        boolean isDelegatedCallToThis = this.isDelegatedCallToThis(psi2);
        boolean isExplicitDelegationCall = this.isExplicitDelegationCall(psi2);
        return this.newStub(parentStub, StringRef.fromString(((KtConstructor)psi2).getName()), hasBody, isDelegatedCallToThis, isExplicitDelegationCall);
    }

    @Override
    public void serialize(@NotNull KotlinConstructorStub<T> stub, @NotNull StubOutputStream dataStream) throws IOException {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.hasBody());
        dataStream.writeBoolean(stub.isDelegatedCallToThis());
        dataStream.writeBoolean(stub.isExplicitDelegationCall());
    }

    @Override
    @NotNull
    public KotlinConstructorStub<T> deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<?> parentStub) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        StringRef name2 = dataStream.readName();
        boolean hasBody = dataStream.readBoolean();
        boolean isDelegatedCallToThis = dataStream.readBoolean();
        boolean isExplicitDelegationCall = dataStream.readBoolean();
        return this.newStub(parentStub, name2, hasBody, isDelegatedCallToThis, isExplicitDelegationCall);
    }

    @Override
    public void indexStub(@NotNull KotlinConstructorStub<T> stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }
}

