/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.reference;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsConditional;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import ksp.org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import ksp.org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtReferenceExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;

public class VariableAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    private final ResolvedCall<? extends VariableDescriptor> resolvedCall;
    private final KtReferenceExpression referenceExpression;
    private final JsExpression receiver;

    public static VariableAccessTranslator newInstance(@NotNull TranslationContext context2, @NotNull KtReferenceExpression referenceExpression2, @Nullable JsExpression receiver) {
        ResolvedCall<? extends VariableDescriptor> resolvedCall2;
        if (context2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(0);
        }
        if (referenceExpression2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(1);
        }
        if ((resolvedCall2 = CallUtilKt.getVariableResolvedCallWithAssert(referenceExpression2, context2.bindingContext())) instanceof VariableAsFunctionResolvedCall) {
            resolvedCall2 = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
        }
        return new VariableAccessTranslator(context2, referenceExpression2, resolvedCall2, receiver);
    }

    private VariableAccessTranslator(@NotNull TranslationContext context2, @NotNull KtReferenceExpression referenceExpression2, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression receiver) {
        if (context2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(2);
        }
        if (referenceExpression2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(3);
        }
        if (resolvedCall2 == null) {
            VariableAccessTranslator.$$$reportNull$$$0(4);
        }
        super(context2);
        this.referenceExpression = referenceExpression2;
        this.receiver = receiver;
        this.resolvedCall = resolvedCall2;
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        LocalVariableDescriptor originalLocal;
        JsExpression e = CallTranslator.INSTANCE.translateGet(this.context(), this.resolvedCall, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor) {
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)original).getGetter();
            if (InlineUtil.isInline(getter2)) {
                if (e instanceof JsNameRef) {
                    InlineUtils.setInlineCallMetadata((JsNameRef)e, (KtElement)this.referenceExpression, (CallableDescriptor)getter2, this.context());
                } else {
                    InlineUtils.setInlineCallMetadata(e, (KtElement)this.referenceExpression, (CallableDescriptor)getter2, this.context());
                }
            }
        } else if (original instanceof LocalVariableDescriptor && (originalLocal = (LocalVariableDescriptor)original).isLateInit()) {
            JsExpression throwFunction = this.context().getReferenceToIntrinsic("throwUPAE");
            JsInvocation throwInvocation = new JsInvocation(throwFunction, new JsStringLiteral(originalLocal.getName().asString()));
            return new JsConditional(new JsBinaryOperation(JsBinaryOperator.EQ, e, new JsNullLiteral()), throwInvocation, e);
        }
        JsExpression jsExpression = e;
        if (jsExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression setTo) {
        PropertySetterDescriptor setter2;
        if (setTo == null) {
            VariableAccessTranslator.$$$reportNull$$$0(6);
        }
        JsExpression e = CallTranslator.INSTANCE.translateSet(this.context(), this.resolvedCall, setTo, this.receiver);
        CallableDescriptor original = this.resolvedCall.getResultingDescriptor().getOriginal();
        if (original instanceof PropertyDescriptor && InlineUtil.isInline(setter2 = ((PropertyDescriptor)original).getSetter())) {
            if (e instanceof JsBinaryOperation && ((JsBinaryOperation)e).getOperator().isAssignment()) {
                InlineUtils.setInlineCallMetadata((JsNameRef)((JsBinaryOperation)e).getArg1(), (KtElement)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            } else {
                InlineUtils.setInlineCallMetadata(e, (KtElement)this.referenceExpression, (CallableDescriptor)setter2, this.context());
            }
        }
        JsExpression jsExpression = e;
        if (jsExpression == null) {
            VariableAccessTranslator.$$$reportNull$$$0(7);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        JsExpression cachedReceiver = this.receiver != null ? this.context().cacheExpressionIfNeeded(this.receiver) : null;
        return new CachedVariableAccessTranslator(this.context(), this.referenceExpression, this.resolvedCall, cachedReceiver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedVariableAccessTranslator
    extends VariableAccessTranslator
    implements AccessTranslator {
        public CachedVariableAccessTranslator(@NotNull TranslationContext context2, @NotNull KtReferenceExpression referenceExpression2, @NotNull ResolvedCall<? extends VariableDescriptor> resolvedCall2, @Nullable JsExpression cachedReceiver) {
            if (context2 == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(0);
            }
            if (referenceExpression2 == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(1);
            }
            if (resolvedCall2 == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(2);
            }
            super(context2, referenceExpression2, resolvedCall2, cachedReceiver);
        }

        @Override
        @NotNull
        public AccessTranslator getCached() {
            CachedVariableAccessTranslator cachedVariableAccessTranslator = this;
            if (cachedVariableAccessTranslator == null) {
                CachedVariableAccessTranslator.$$$reportNull$$$0(3);
            }
            return cachedVariableAccessTranslator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedCall";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/org/jetbrains/kotlin/js/translate/reference/VariableAccessTranslator$CachedVariableAccessTranslator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCached";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

