/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.js.translate.general.Translation;
import ksp.org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\r\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/js/translate/callTranslator/RangeCheckTranslator;", "", "context", "Lksp/org/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translateAsIntRangeCheck", "Lksp/org/jetbrains/kotlin/js/backend/ast/JsExpression;", "lower", "upper", "kind", "Lksp/org/jetbrains/kotlin/js/backend/ast/metadata/RangeKind;", "subject", "translateAsLongRangeCheck", "translateAsRangeCheck", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receivers", "Lksp/org/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "js.translator"})
@SourceDebugExtension(value={"SMAP\nRangeCheckTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeCheckTranslator.kt\norg/jetbrains/kotlin/js/translate/callTranslator/RangeCheckTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class RangeCheckTranslator {
    @NotNull
    private final TranslationContext context;

    public RangeCheckTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Nullable
    public final JsExpression translateAsRangeCheck(@NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers receivers) {
        JsExpression jsExpression;
        List list2;
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)receivers, (String)"receivers");
        FunctionDescriptor calledFunction = resolvedCall2.getResultingDescriptor();
        if (!Intrinsics.areEqual((Object)calledFunction.getName().asString(), (Object)"contains") || !(calledFunction.getContainingDeclaration() instanceof ClassDescriptor)) {
            return null;
        }
        JsExpression jsExpression2 = receivers.getExtensionOrDispatchReceiver();
        JsExpression.JsExpressionHasArguments jsExpressionHasArguments = jsExpression2 instanceof JsExpression.JsExpressionHasArguments ? (JsExpression.JsExpressionHasArguments)jsExpression2 : null;
        if (jsExpressionHasArguments == null) {
            return null;
        }
        JsExpression.JsExpressionHasArguments invocation = jsExpressionHasArguments;
        Pair<RangeType, RangeKind> pair = MetadataProperties.getRange(invocation);
        if (pair == null) {
            return null;
        }
        Pair<RangeType, RangeKind> pair2 = pair;
        RangeType rangeType = (RangeType)((Object)pair2.component1());
        RangeKind rangeKind = (RangeKind)((Object)pair2.component2());
        if (rangeKind == RangeKind.UNTIL || rangeType == RangeType.INT) {
            if (invocation.getArguments().size() != 2) {
                return null;
            }
            list2 = invocation.getArguments();
        } else {
            if (!(invocation instanceof JsInvocation)) {
                return null;
            }
            Object[] objectArray = ((JsInvocation)invocation).getQualifier();
            JsNameRef jsNameRef = objectArray instanceof JsNameRef ? (JsNameRef)objectArray : null;
            if (jsNameRef == null) {
                return null;
            }
            JsNameRef qualifier2 = jsNameRef;
            JsExpression jsExpression3 = qualifier2.getQualifier();
            if (jsExpression3 == null) {
                return null;
            }
            JsExpression receiver = jsExpression3;
            if (((JsInvocation)invocation).getArguments().size() != 1) {
                return null;
            }
            objectArray = new JsExpression[2];
            objectArray[0] = receiver;
            List<JsExpression> list3 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getArguments(...)");
            objectArray[1] = CollectionsKt.single(list3);
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        List list4 = list2;
        Intrinsics.checkNotNull(list4);
        JsExpression lower2 = list4.get(0);
        JsExpression upper = list4.get(1);
        lower2 = this.context.cacheExpressionIfNeeded(lower2);
        upper = this.context.cacheExpressionIfNeeded(upper);
        Object object = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)resolvedCall2.getValueArguments().values());
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getArgumentExpression()) == null) {
            return null;
        }
        Object subjectPsi = object;
        JsExpression jsExpression4 = this.context.cacheExpressionIfNeeded(Translation.translateAsExpression((KtExpression)subjectPsi, this.context));
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"cacheExpressionIfNeeded(...)");
        JsExpression subject = jsExpression4;
        switch (WhenMappings.$EnumSwitchMapping$0[rangeType.ordinal()]) {
            case 1: {
                JsExpression jsExpression5 = lower2;
                Intrinsics.checkNotNull((Object)jsExpression5);
                JsExpression jsExpression6 = jsExpression5;
                jsExpression5 = upper;
                Intrinsics.checkNotNull((Object)jsExpression5);
                jsExpression = this.translateAsIntRangeCheck(jsExpression6, jsExpression5, rangeKind, subject);
                break;
            }
            case 2: {
                JsExpression jsExpression7 = lower2;
                Intrinsics.checkNotNull((Object)jsExpression7);
                JsExpression jsExpression8 = jsExpression7;
                jsExpression7 = upper;
                Intrinsics.checkNotNull((Object)jsExpression7);
                jsExpression = this.translateAsLongRangeCheck(jsExpression8, jsExpression7, rangeKind, subject);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    private final JsExpression translateAsIntRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsBinaryOperation jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2;
        JsBinaryOperation jsBinaryOperation3 = JsAstUtils.lessThanEq(lower2, subject);
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation3, (String)"lessThanEq(...)");
        JsBinaryOperation lowerCheck = jsBinaryOperation3;
        switch (WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                jsBinaryOperation2 = JsAstUtils.lessThanEq(subject, upper);
                break;
            }
            case 2: {
                jsBinaryOperation2 = JsAstUtils.lessThan(subject, upper);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsBinaryOperation jsBinaryOperation4 = jsBinaryOperation2;
        Intrinsics.checkNotNull((Object)jsBinaryOperation4);
        JsBinaryOperation upperCheck = jsBinaryOperation4;
        MetadataProperties.setSynthetic(lowerCheck, true);
        MetadataProperties.setSynthetic(upperCheck, true);
        JsBinaryOperation $this$translateAsIntRangeCheck_u24lambda_u240 = jsBinaryOperation = JsAstUtils.and(lowerCheck, upperCheck);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$translateAsIntRangeCheck_u24lambda_u240);
        MetadataProperties.setSynthetic($this$translateAsIntRangeCheck_u24lambda_u240, true);
        JsBinaryOperation jsBinaryOperation5 = jsBinaryOperation;
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation5, (String)"apply(...)");
        return jsBinaryOperation5;
    }

    private final JsExpression translateAsLongRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsInvocation jsInvocation;
        Object object = new JsExpression[]{subject};
        Object $this$translateAsLongRangeCheck_u24lambda_u241 = object = JsAstUtils.invokeMethod(lower2, "lessThanOrEqual", object);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$translateAsLongRangeCheck_u24lambda_u241);
        MetadataProperties.setSideEffects((HasMetadata)$this$translateAsLongRangeCheck_u24lambda_u241, SideEffectKind.PURE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        Object lowerCheck = object;
        switch (WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                JsExpression[] jsExpressionArray = new JsExpression[]{upper};
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThanOrEqual", jsExpressionArray);
                break;
            }
            case 2: {
                JsExpression[] jsExpressionArray = new JsExpression[]{upper};
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThan", jsExpressionArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = jsInvocation;
        Intrinsics.checkNotNull((Object)object);
        Object upperCheck = object;
        MetadataProperties.setSideEffects((HasMetadata)upperCheck, SideEffectKind.PURE);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and((JsExpression)lowerCheck, (JsExpression)upperCheck);
        Intrinsics.checkNotNullExpressionValue((Object)jsBinaryOperation, (String)"and(...)");
        return jsBinaryOperation;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RangeType.values().length];
            try {
                nArray[RangeType.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeType.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RangeKind.values().length];
            try {
                nArray[RangeKind.RANGE_TO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKind.UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

