/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.cfa.util;

import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import ksp.kotlinx.collections.immutable.PersistentMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyDeclarationCollector;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoCollector;
import ksp.org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import ksp.org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.util.MultimapKt;
import ksp.org.jetbrains.kotlin.fir.util.SetMultimap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRA\u0010\r\u001a(\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\b\u0012\u0004\u0012\u00020\u0012`\u00130\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "", "properties", "", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "conditionallyInitializedProperties", "receiver", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "graph", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;)V", "getConditionallyInitializedProperties", "()Ljava/util/Set;", "data", "", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lksp/kotlinx/collections/immutable/PersistentMap;", "Lksp/org/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "getData", "()Ljava/util/Map;", "data$delegate", "Lkotlin/Lazy;", "getGraph", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "getProperties", "getReceiver", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getValue", "Lksp/org/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "node", "checkers"})
public final class PropertyInitializationInfoData {
    @NotNull
    private final Set<FirPropertySymbol> properties;
    @NotNull
    private final Set<FirPropertySymbol> conditionallyInitializedProperties;
    @Nullable
    private final FirBasedSymbol<?> receiver;
    @NotNull
    private final ControlFlowGraph graph;
    @NotNull
    private final Lazy data$delegate;

    public PropertyInitializationInfoData(@NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirPropertySymbol> conditionallyInitializedProperties, @Nullable FirBasedSymbol<?> receiver, @NotNull ControlFlowGraph graph) {
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter(conditionallyInitializedProperties, (String)"conditionallyInitializedProperties");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.properties = properties2;
        this.conditionallyInitializedProperties = conditionallyInitializedProperties;
        this.receiver = receiver;
        this.graph = graph;
        this.data$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)new Function0<Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PropertyInitializationInfo>>>(this){
            final /* synthetic */ PropertyInitializationInfoData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> invoke() {
                SetMultimap<FirStatement, FirPropertySymbol> setMultimap = MultimapKt.setMultimapOf();
                PropertyInitializationInfoData propertyInitializationInfoData = this.this$0;
                SetMultimap<FirStatement, FirPropertySymbol> $this$invoke_u24lambda_u240 = setMultimap;
                boolean bl = false;
                FirDeclaration firDeclaration = propertyInitializationInfoData.getGraph().getDeclaration();
                if (firDeclaration != null) {
                    firDeclaration.accept(new PropertyDeclarationCollector($this$invoke_u24lambda_u240), null);
                }
                SetMultimap<FirStatement, FirPropertySymbol> declaredVariablesInLoop = setMultimap;
                return CfgTraverserKt.collectDataForNode(this.this$0.getGraph(), TraverseDirection.Forward, new PropertyInitializationInfoCollector(this.this$0.getProperties(), this.this$0.getReceiver(), declaredVariablesInLoop));
            }
        });
    }

    @NotNull
    public final Set<FirPropertySymbol> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Set<FirPropertySymbol> getConditionallyInitializedProperties() {
        return this.conditionallyInitializedProperties;
    }

    @Nullable
    public final FirBasedSymbol<?> getReceiver() {
        return this.receiver;
    }

    @NotNull
    public final ControlFlowGraph getGraph() {
        return this.graph;
    }

    private final Map<CFGNode<?>, PersistentMap<EdgeLabel, PropertyInitializationInfo>> getData() {
        Lazy lazy = this.data$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final PersistentMap<EdgeLabel, PropertyInitializationInfo> getValue(@NotNull CFGNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return (PersistentMap)MapsKt.getValue(this.getData(), node);
    }
}

