/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import ksp.org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import ksp.org.jetbrains.kotlin.contracts.model.ESExpression;
import ksp.org.jetbrains.kotlin.contracts.model.functors.IsFunctor;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESIs;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESNot;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESOr;
import ksp.org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import ksp.org.jetbrains.kotlin.contracts.model.structure.TypesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lksp/org/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "Lksp/org/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "Lksp/org/jetbrains/kotlin/contracts/model/ESExpression;", "", "dispatcher", "Lksp/org/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "visitBooleanConstantDescriptor", "booleanConstantDescriptor", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;", "data", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitBooleanVariableReference", "booleanVariableReference", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitIsInstancePredicate", "isInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitIsNullPredicate", "isNullPredicate", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalAnd", "logicalAnd", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalNot", "logicalNot", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "visitLogicalOr", "logicalOr", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "resolution"})
public final class ConditionInterpreter
implements ContractDescriptionVisitor<ESExpression, Unit> {
    @NotNull
    private final ContractInterpretationDispatcher dispatcher;

    public ConditionInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public ESExpression visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalOr, (String)"logicalOr");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ESExpression eSExpression = (ESExpression)logicalOr.getLeft().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalOr.getRight().accept(this, data2);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESOr(left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalAnd, (String)"logicalAnd");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ESExpression eSExpression = (ESExpression)logicalAnd.getLeft().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalAnd.getRight().accept(this, data2);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESAnd(left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ESExpression eSExpression = (ESExpression)logicalNot.getArg().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression arg = eSExpression;
        return new ESNot(arg);
    }

    @Override
    @Nullable
    public ESExpression visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isInstancePredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable esVariable = eSVariable;
        return new ESIs(esVariable, new IsFunctor(TypesKt.toESType(isInstancePredicate.getType()), isInstancePredicate.isNegated()));
    }

    @Override
    @Nullable
    public ESExpression visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isNullPredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable variable2 = eSVariable;
        return new ESEqual(variable2, ESConstants.INSTANCE.getNullValue(), isNullPredicate.isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitBooleanConstantDescriptor(@NotNull BooleanConstantReference booleanConstantDescriptor, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)booleanConstantDescriptor, (String)"booleanConstantDescriptor");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.dispatcher.interpretConstant$resolution(booleanConstantDescriptor);
    }

    @Override
    @Nullable
    public ESExpression visitBooleanVariableReference(@NotNull BooleanVariableReference booleanVariableReference, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter((Object)booleanVariableReference, (String)"booleanVariableReference");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return this.dispatcher.interpretVariable$resolution(booleanVariableReference);
    }
}

