/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrVararg;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImplKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetEnumValueImplKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrVarargImplKt;
import ksp.org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import ksp.org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0014\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\rH\u0002J\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering;", "Lksp/org/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "noNewJavaAnnotationTargets", "", "symbols", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmSymbols$JavaAnnotations;", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmSymbols;", "generateDocumentedAnnotation", "", "irClass", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "generateRepeatableAnnotation", "generateRetentionAnnotation", "generateTargetAnnotation", "loadAnnotationTargets", "", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "targetEntry", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "lower", "mapTarget", "Lksp/org/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "target", "applicableTargetSet", "getValueArgument", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAdditionalClassAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdditionalClassAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1#2:160\n1#2:196\n1619#3:158\n1863#3:159\n1864#3:161\n1620#3:162\n1053#3:163\n669#3,11:164\n808#3,11:175\n1611#3,9:186\n1863#3:195\n1864#3:197\n1620#3:198\n*S KotlinDebug\n*F\n+ 1 AdditionalClassAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AdditionalClassAnnotationLowering\n*L\n85#1:160\n151#1:196\n85#1:158\n85#1:159\n85#1:161\n85#1:162\n85#1:163\n123#1:164,11\n151#1:175,11\n151#1:186,9\n151#1:195\n151#1:197\n151#1:198\n*E\n"})
final class AdditionalClassAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final JvmSymbols.JavaAnnotations symbols;
    private final boolean noNewJavaAnnotationTargets;

    public AdditionalClassAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.symbols = this.context.getIr().getSymbols().getJavaAnnotations();
        this.noNewJavaAnnotationTargets = this.context.getConfig().getNoNewJavaAnnotationTargets() || !this.context.isCompilingAgainstJdk8OrLater();
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isAnnotationClass(irClass)) {
            return;
        }
        this.generateDocumentedAnnotation(irClass);
        this.generateRetentionAnnotation(irClass);
        this.generateTargetAnnotation(irClass);
        this.generateRepeatableAnnotation(irClass);
    }

    private final void generateDocumentedAnnotation(IrClass irClass) {
        block3: {
            block2: {
                if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irClass, StandardNames.FqNames.mustBeDocumented)) break block2;
                IrAnnotationContainer irAnnotationContainer = irClass;
                FqName fqName2 = JvmAnnotationNames.DOCUMENTED_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"DOCUMENTED_ANNOTATION");
                if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) break block3;
            }
            return;
        }
        irClass.setAnnotations(CollectionsKt.plus((Collection)irClass.getAnnotations(), (Object)IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getDocumentedConstructor().getReturnType(), this.symbols.getDocumentedConstructor().getSymbol(), 0, null, 32, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRetentionAnnotation(IrClass irClass) {
        void $this$generateRetentionAnnotation_u24lambda_u241;
        IrConstructorCallImpl irConstructorCallImpl;
        Object object;
        block5: {
            block4: {
                IrAnnotationContainer irAnnotationContainer = irClass;
                FqName fqName2 = JvmAnnotationNames.RETENTION_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"RETENTION_ANNOTATION");
                if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
                    return;
                }
                KotlinRetention kotlinRetentionPolicy = IrUtilsKt.getAnnotationRetention(irClass);
                object = kotlinRetentionPolicy;
                if (object == null) break block4;
                KotlinRetention it = object;
                boolean bl = false;
                IrEnumEntry irEnumEntry = this.symbols.getAnnotationRetentionMap().get((Object)it);
                object = irEnumEntry;
                if (irEnumEntry != null) break block5;
            }
            object = this.symbols.getRpRuntime();
        }
        KotlinRetention javaRetentionPolicy = object;
        IrConstructorCallImpl irConstructorCallImpl2 = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getRetentionConstructor().getReturnType(), this.symbols.getRetentionConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateRetentionAnnotation_u24lambda_u241.putValueArgument(0, IrGetEnumValueImplKt.IrGetEnumValueImpl(-1, -1, IrUtilsKt.getDefaultType(this.symbols.getRetentionPolicyEnum()), ((IrEnumEntry)((Object)javaRetentionPolicy)).getSymbol()));
        Unit unit2 = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)irConstructorCallImpl));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTargetAnnotation(IrClass irClass) {
        void $this$generateTargetAnnotation_u24lambda_u243;
        void $this$sortedBy$iv;
        Iterable $this$mapNotNullTo$iv;
        IrAnnotationContainer irAnnotationContainer = irClass;
        FqName fqName2 = JvmAnnotationNames.TARGET_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"TARGET_ANNOTATION");
        if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
            return;
        }
        Set<KotlinTarget> set = this.applicableTargetSet(irClass);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        Iterable iterable = targets;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinTarget p0 = (KotlinTarget)((Object)element$iv);
            boolean bl2 = false;
            if (this.mapTarget(p0) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List javaTargets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IrEnumEntry it = (IrEnumEntry)a;
                boolean bl = false;
                String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                it = (IrEnumEntry)b;
                Comparable comparable = (Comparable)((Object)ElementType.valueOf(string2));
                bl = false;
                String string3 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)ElementType.valueOf(string3))));
            }
        });
        Object object = new IrType[]{IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum())};
        IrVarargImpl vararg = IrVarargImplKt.IrVarargImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), (IrType[])object), IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum()));
        object = javaTargets.iterator();
        while (object.hasNext()) {
            IrEnumEntry target = (IrEnumEntry)object.next();
            vararg.getElements().add(IrGetEnumValueImplKt.IrGetEnumValueImpl(-1, -1, IrUtilsKt.getDefaultType(this.symbols.getElementTypeEnum()), target.getSymbol()));
        }
        Object target = object = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getTargetConstructor().getReturnType(), this.symbols.getTargetConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass2 = irClass;
        boolean bl = false;
        $this$generateTargetAnnotation_u24lambda_u243.putValueArgument(0, vararg);
        Unit unit2 = Unit.INSTANCE;
        irClass2.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
    }

    private final IrEnumEntry mapTarget(KotlinTarget target) {
        IrEnumEntry irEnumEntry;
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                IrEnumEntry irEnumEntry2;
                IrEnumEntry it = irEnumEntry2 = this.symbols.getTypeParameterTarget();
                boolean bl = false;
                if (!this.noNewJavaAnnotationTargets) {
                    irEnumEntry = irEnumEntry2;
                    break;
                }
                irEnumEntry = null;
                break;
            }
            case 2: {
                IrEnumEntry irEnumEntry3;
                IrEnumEntry it = irEnumEntry3 = this.symbols.getTypeUseTarget();
                boolean bl = false;
                if (!this.noNewJavaAnnotationTargets) {
                    irEnumEntry = irEnumEntry3;
                    break;
                }
                irEnumEntry = null;
                break;
            }
            default: {
                irEnumEntry = this.symbols.getJvmTargetMap().get((Object)target);
            }
        }
        return irEnumEntry;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRepeatableAnnotation(IrClass irClass) {
        void $this$generateRepeatableAnnotation_u24lambda_u247;
        Object v2;
        block7: {
            block9: {
                block8: {
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irClass, StandardNames.FqNames.repeatable)) break block8;
                    IrAnnotationContainer irAnnotationContainer = irClass;
                    FqName fqName2 = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"REPEATABLE_ANNOTATION");
                    if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) break block9;
                }
                return;
            }
            Iterable $this$singleOrNull$iv = irClass.getDeclarations();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrClass && Intrinsics.areEqual((Object)((IrClass)it).getName().asString(), (Object)"Container"))) continue;
                if (found$iv) {
                    v2 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        IrClass irClass2 = v2;
        if (irClass2 == null) {
            throw new IllegalStateException(("Repeatable annotation class should have a container generated: " + RenderIrElementKt.render$default(irClass, null, 1, null)).toString());
        }
        IrClass containerClass = irClass2;
        Object object = new IrType[]{IrUtilsKt.getDefaultType(containerClass)};
        IrClassReferenceImpl containerReference = IrClassReferenceImplKt.IrClassReferenceImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getKClassClass(), object), containerClass.getSymbol(), IrUtilsKt.getDefaultType(containerClass));
        Object $i$f$singleOrNull = object = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, this.symbols.getRepeatableConstructor().getReturnType(), this.symbols.getRepeatableConstructor().getSymbol(), 0, null, 32, null);
        Collection collection = irClass.getAnnotations();
        IrClass irClass3 = irClass;
        boolean bl = false;
        $this$generateRepeatableAnnotation_u24lambda_u247.putValueArgument(0, containerReference);
        Unit unit2 = Unit.INSTANCE;
        irClass3.setAnnotations(CollectionsKt.plus((Collection)collection, (Object)object));
    }

    private final IrExpression getValueArgument(IrConstructorCall $this$getValueArgument, Name name2) {
        Object v0;
        block2: {
            Iterable iterable = ((IrConstructor)$this$getValueArgument.getSymbol().getOwner()).getValueParameters();
            for (Object t : iterable) {
                IrValueParameter it = (IrValueParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IrValueParameter irValueParameter = v0;
        if (irValueParameter == null) {
            return null;
        }
        int index2 = irValueParameter.getIndex();
        return $this$getValueArgument.getValueArgument(index2);
    }

    private final Set<KotlinTarget> applicableTargetSet(IrClass $this$applicableTargetSet) {
        IrConstructorCall irConstructorCall2 = IrUtilsKt.getAnnotation($this$applicableTargetSet, StandardNames.FqNames.target);
        if (irConstructorCall2 == null) {
            return null;
        }
        IrConstructorCall targetEntry = irConstructorCall2;
        return this.loadAnnotationTargets(targetEntry);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KotlinTarget> loadAnnotationTargets(IrConstructorCall targetEntry) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Name name2 = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        IrExpression irExpression = this.getValueArgument(targetEntry, name2);
        IrVararg irVararg = irExpression instanceof IrVararg ? (IrVararg)irExpression : null;
        if (irVararg == null) {
            return null;
        }
        IrVararg valueArgument = irVararg;
        Iterable $this$filterIsInstance$iv = valueArgument.getElements();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrGetEnumValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrGetEnumValue it = (IrGetEnumValue)element$iv$iv;
            boolean bl2 = false;
            String string2 = ((IrEnumEntry)it.getSymbol().getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            if (KotlinTarget.Companion.valueOrNull(string2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinTarget.values().length];
            try {
                nArray[KotlinTarget.TYPE_PARAMETER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinTarget.TYPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

