/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.xml.util;

import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.org.jdom.Verifier;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.Nls;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class XmlStringUtil {
    private XmlStringUtil() {
    }

    @NotNull
    public static String wrapInCDATA(@NotNull String str) {
        if (str == null) {
            XmlStringUtil.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        String string2 = sb.toString();
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Contract(value="null->null; !null->!null", pure=true)
    public static String escapeString(@Nullable String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    @Contract(value="null,_->null; !null,_->!null", pure=true)
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    @Contract(value="null,_,_->null; !null,_,_->!null", pure=true)
    public static String escapeString(@Nullable String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            buffer = XmlStringUtil.appendEscapedSymbol(str, buffer, i, entity, ch);
        }
        return buffer == null ? str : buffer.toString();
    }

    @Nullable
    public static StringBuilder appendEscapedSymbol(@NotNull String str, StringBuilder buffer, int i, String entity, char ch) {
        if (str == null) {
            XmlStringUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            if (entity != null) {
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, i);
                buffer.append(entity);
            }
        } else if (entity == null) {
            buffer.append(ch);
        } else {
            buffer.append(entity);
        }
        return buffer;
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapInHtml(@NotNull CharSequence result2) {
        if (result2 == null) {
            XmlStringUtil.$$$reportNull$$$0(3);
        }
        String string2 = "<html>" + result2 + "</html>";
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public static String wrapInHtmlLines(CharSequence ... lines) {
        if (lines == null) {
            XmlStringUtil.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (int i = 0; i < lines.length; ++i) {
            CharSequence sequence2 = lines[i];
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append("<nobr>").append(sequence2).append("</nobr>");
        }
        String string2 = sb.append("</html>").toString();
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    public static String wrapInHtmlTag(@Nls @NotNull String text, @NonNls @NotNull String tagWord) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(7);
        }
        if (tagWord == null) {
            XmlStringUtil.$$$reportNull$$$0(8);
        }
        String string2 = String.format("<%s>%s</%s>", tagWord, text, tagWord);
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static String wrapInHtmlTagWithAttributes(@Nls @NotNull String text, @NonNls @NotNull String tagWord, @NonNls @NotNull String attributes2) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(10);
        }
        if (tagWord == null) {
            XmlStringUtil.$$$reportNull$$$0(11);
        }
        if (attributes2 == null) {
            XmlStringUtil.$$$reportNull$$$0(12);
        }
        String string2 = String.format("<%s %s>%s</%s>", tagWord, attributes2, text, tagWord);
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    public static String formatLink(@NonNls @NotNull String targetUrl, @Nls @NotNull String text) {
        if (targetUrl == null) {
            XmlStringUtil.$$$reportNull$$$0(14);
        }
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(15);
        }
        return XmlStringUtil.wrapInHtmlTagWithAttributes(text, "a", "href=\"" + targetUrl + "\"");
    }

    public static boolean isWrappedInHtml(@NotNull String tooltip) {
        if (tooltip == null) {
            XmlStringUtil.$$$reportNull$$$0(16);
        }
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String toolTip) {
        if (toolTip == null) {
            XmlStringUtil.$$$reportNull$$$0(17);
        }
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        String string2 = toolTip = StringUtil.trimEnd(toolTip, "</body>");
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertToHtmlContent(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(19);
        }
        String string2 = XmlStringUtil.isWrappedInHtml(text) ? XmlStringUtil.stripHtml(text) : XmlStringUtil.escapeString(text);
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @NotNull
    public static String escapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(21);
        }
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int c = text.codePointAt(i);
            if (Character.isSupplementaryCodePoint(c)) {
                ++i;
            }
            if (c != 35 && Verifier.isXMLCharacter(c)) continue;
            if (b == null) {
                b = new StringBuilder(text.length() + 5);
            }
            b.append(text, lastPos, i).append('#');
            if (c != 35) {
                b.append(Integer.toHexString(c));
            }
            b.append('#');
            lastPos = i + 1;
        }
        String string2 = b == null ? text : b.append(text, lastPos, text.length()).toString();
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    public static String unescapeIllegalXmlChars(@NotNull String text) {
        if (text == null) {
            XmlStringUtil.$$$reportNull$$$0(23);
        }
        StringBuilder b = null;
        int lastPos = 0;
        for (int i = 0; i < text.length(); ++i) {
            int charCode;
            int numberEnd;
            char c = text.charAt(i);
            if (c != '#' || (numberEnd = text.indexOf(35, i + 1)) <= 0) continue;
            try {
                charCode = numberEnd == i + 1 ? 35 : Integer.parseInt(text.substring(i + 1, numberEnd), 16);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (b == null) {
                b = new StringBuilder(text.length());
            }
            b.append(text, lastPos, i);
            b.append((char)charCode);
            i = numberEnd;
            lastPos = i + 1;
        }
        String string2 = b == null ? text : b.append(text, lastPos, text.length()).toString();
        if (string2 == null) {
            XmlStringUtil.$$$reportNull$$$0(24);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagWord";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolTip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/xml/util/XmlStringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInCDATA";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlLines";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlTag";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInHtmlTagWithAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToHtmlContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeIllegalXmlChars";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeIllegalXmlChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCDATA";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlTag";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapInHtmlTagWithAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatLink";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isWrappedInHtml";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToHtmlContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "escapeIllegalXmlChars";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unescapeIllegalXmlChars";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

