/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.ui;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicBoolean;
import ksp.com.intellij.ui.IconManager;
import ksp.org.jetbrains.annotations.Nullable;

final class IconManagerHelper {
    private static final AtomicBoolean isActivated = new AtomicBoolean();
    static volatile IconManager instance;

    IconManagerHelper() {
    }

    static void activate(@Nullable IconManager impl) throws Throwable {
        if (!isActivated.compareAndSet(false, true)) {
            return;
        }
        if (impl == null) {
            Class<?> implClass = IconManagerHelper.class.getClassLoader().loadClass("ksp.com.intellij.ui.CoreIconManager");
            instance = MethodHandles.lookup().findConstructor(implClass, MethodType.methodType(Void.TYPE)).invoke();
        } else {
            instance = impl;
        }
    }

    static void deactivate() {
        if (isActivated.compareAndSet(true, false)) {
            instance = null;
        }
    }
}

