/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import ksp.org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvable;
import ksp.org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import ksp.org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0001(\u0000\u00f2\u0001\u0004\n\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallChecker;", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isNamedSpread", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirSpreadArgumentExpression;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirNamedVarargChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNamedVarargChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n43#2:97\n57#2,4:100\n1863#3,2:98\n1863#3,2:104\n*S KotlinDebug\n*F\n+ 1 FirNamedVarargChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirNamedVarargChecker\n*L\n74#1:97\n76#1:100,4\n74#1:98,2\n80#1:104,2\n*E\n"})
public final class FirNamedVarargChecker
extends FirExpressionChecker<FirCall> {
    @NotNull
    public static final FirNamedVarargChecker INSTANCE = new FirNamedVarargChecker();

    private FirNamedVarargChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(expression2 instanceof FirFunctionCall || expression2 instanceof FirAnnotation || expression2 instanceof FirDelegatedConstructorCall || expression2 instanceof FirArrayLiteral)) {
            return;
        }
        boolean isAnnotation = expression2 instanceof FirAnnotation;
        KtDiagnosticFactory0 redundantSpreadWarningFactory = isAnnotation ? FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION() : FirErrors.INSTANCE.getREDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION();
        boolean allowAssignArray = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(isAnnotation ? LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations : LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions);
        if (expression2 instanceof FirArrayLiteral) {
            void $this$forEach$iv;
            Object $this$arguments$iv = expression2;
            boolean $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl = false;
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation, it, INSTANCE.isNamedSpread(it), FirTypeUtilsKt.getResolvedType((FirExpression)((Object)expression2)));
            }
        } else {
            FirCall $this$resolvedArgumentMapping$iv = expression2;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMap = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMap).entrySet()) {
                FirExpression argument2 = (FirExpression)entry.getKey();
                FirValueParameter parameter2 = (FirValueParameter)entry.getValue();
                if (!parameter2.isVararg()) continue;
                if (argument2 instanceof FirVarargArgumentsExpression) {
                    Iterable $this$forEach$iv = ((FirVarargArgumentsExpression)argument2).getArguments();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl = false;
                        FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation, it, true, FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef()));
                    }
                    continue;
                }
                FirNamedVarargChecker.check$checkArgument(expression2, reporter, redundantSpreadWarningFactory, context2, allowAssignArray, isAnnotation, argument2, false, FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef()));
            }
        }
    }

    private final boolean isNamedSpread(FirExpression expression2) {
        return expression2 instanceof FirSpreadArgumentExpression && ((FirSpreadArgumentExpression)expression2).isNamed();
    }

    private static final void check$checkArgument(FirCall $expression, DiagnosticReporter $reporter, KtDiagnosticFactory0 redundantSpreadWarningFactory, CheckerContext $context, boolean allowAssignArray, boolean isAnnotation, FirExpression argument2, boolean isVararg2, ConeKotlinType expectedArrayType) {
        if (!INSTANCE.isNamedSpread(argument2)) {
            return;
        }
        if (!((FirSpreadArgumentExpression)argument2).isFakeSpread() && ((FirSpreadArgumentExpression)argument2).isNamed()) {
            if (isVararg2) {
                FirResolvable firResolvable = $expression instanceof FirResolvable ? (FirResolvable)((Object)$expression) : null;
                if (!((firResolvable != null ? firResolvable.getCalleeReference() : null) instanceof FirErrorNamedReference)) {
                    KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument2).getExpression().getSource(), redundantSpreadWarningFactory, (DiagnosticContext)$context, null, 8, null);
                }
            }
            return;
        }
        ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(((FirSpreadArgumentExpression)argument2).getExpression());
        if (type2 instanceof ConeErrorType) {
            return;
        }
        if (((FirSpreadArgumentExpression)argument2).getExpression() instanceof FirArrayLiteral) {
            return;
        }
        if (allowAssignArray && ConeBuiltinTypeUtilsKt.isArrayType(type2)) {
            return;
        }
        if (isAnnotation) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument2).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION(), (DiagnosticContext)$context, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)((FirSpreadArgumentExpression)argument2).getExpression().getSource(), FirErrors.INSTANCE.getASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION(), (Object)expectedArrayType, (DiagnosticContext)$context, null, 16, null);
        }
    }
}

