/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnonymousFunctionParametersChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnonymousFunctionChecker;", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirAnonymousFunctionParametersChecker
extends FirDeclarationChecker<FirAnonymousFunction> {
    @NotNull
    public static final FirAnonymousFunctionParametersChecker INSTANCE = new FirAnonymousFunctionParametersChecker();

    private FirAnonymousFunctionParametersChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnonymousFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirValueParameter valueParameter2 : declaration2.getValueParameters()) {
            KtSourceElement source;
            if (valueParameter2.getSource() == null) continue;
            if (valueParameter2.getDefaultValue() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (!valueParameter2.isVararg()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUSELESS_VARARG_ON_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

