/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ksp.com.intellij.openapi.diagnostic.LoggerRt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ReflectionUtilRt {
    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(0);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        ReflectionUtilRt.collectFields(clazz, result2);
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtilRt.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void collectFields(Class<?> clazz, List<? super Field> result2) {
        result2.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtilRt.collectFields(superClass, result2);
        }
        for (Class<?> each : clazz.getInterfaces()) {
            ReflectionUtilRt.collectFields(each, result2);
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull String fieldName) {
        Field field2;
        if (objectClass == null) {
            ReflectionUtilRt.$$$reportNull$$$0(2);
        }
        if (fieldName == null) {
            ReflectionUtilRt.$$$reportNull$$$0(3);
        }
        if ((field2 = ReflectionUtilRt.findField(objectClass, fieldName, fieldType)) != null) {
            try {
                Object t = field2.get(object);
                return (T)t;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field findField(Class<?> clazz, String fieldName, @Nullable Class<?> fieldType) {
        Field result2;
        for (Field field2 : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field2.getName()) || fieldType != null && !fieldType.isAssignableFrom(field2.getType())) continue;
            field2.setAccessible(true);
            return field2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtilRt.findField(superClass, fieldName, fieldType)) != null) {
            return result2;
        }
        for (Class<?> each : clazz.getInterfaces()) {
            Field result3 = ReflectionUtilRt.findField(each, fieldName, fieldType);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LoggerRt.getInstance(ReflectionUtilRt.class).warn(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

