/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import ksp.org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CallToDeprecatedOverrideOfHidden;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ4\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isHiddenForThisCallSite", "", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckerSinkKt\n*L\n1#1,855:1\n21#2:856\n28#3,2:857\n22#3,9:859\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/CheckHiddenDeclaration\n*L\n756#1:856\n759#1:857,2\n759#1:859,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        DeprecationInfo deprecation;
        FirCallableSymbol symbol2;
        FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return Unit.INSTANCE;
        }
        FirCallableSymbol $this$isActual$iv = symbol2 = firCallableSymbol;
        boolean $i$f$isActual2 = false;
        if ($this$isActual$iv.getRawStatus().isActual()) {
            return Unit.INSTANCE;
        }
        DeprecationInfo deprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation(symbol2, context2.getSession(), callInfo.getCallSite());
        if ((deprecationInfo != null ? deprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN || this.isHiddenForThisCallSite(symbol2, callInfo, candidate2, context2.getSession(), sink)) {
            void $this$yieldDiagnostic$iv;
            CheckerSink $i$f$isActual2 = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol2, CallInfo callInfo, Candidate candidate2, FirSession session2, CheckerSink sink) {
        if (symbol2 instanceof FirSimpleSyntheticPropertySymbol && SyntheticsKt.getDeprecatedOverrideOfHidden((FirSimpleSyntheticPropertySymbol)symbol2)) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        if (((FirCallableDeclaration)symbol2.getFir()).getDispatchReceiverType() == null || !(symbol2 instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        boolean isSuperCall = ResolutionStagesKt.isSuperCall(callInfo.getCallSite(), session2);
        if (DeprecationUtilsKt.hiddenStatusOfCall(symbol2, isSuperCall, false) == CallToPotentiallyHiddenSymbolResult.Hidden) {
            return true;
        }
        FirScope firScope2 = candidate2.getOriginScope();
        FirTypeScope firTypeScope = firScope2 instanceof FirTypeScope ? (FirTypeScope)firScope2 : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope = firTypeScope;
        Ref.BooleanRef hidden = new Ref.BooleanRef();
        Ref.BooleanRef deprecated = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope, (FirNamedFunctionSymbol)symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(isSuperCall, hidden, deprecated){
            final /* synthetic */ boolean $isSuperCall;
            final /* synthetic */ Ref.BooleanRef $hidden;
            final /* synthetic */ Ref.BooleanRef $deprecated;
            {
                this.$isSuperCall = $isSuperCall;
                this.$hidden = $hidden;
                this.$deprecated = $deprecated;
                super(1);
            }

            public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                ProcessorAction processorAction;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CallToPotentiallyHiddenSymbolResult result2 = DeprecationUtilsKt.hiddenStatusOfCall(it, this.$isSuperCall, true);
                if (result2 != CallToPotentiallyHiddenSymbolResult.Visible) {
                    if (result2 == CallToPotentiallyHiddenSymbolResult.Hidden) {
                        this.$hidden.element = true;
                    } else if (result2 == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
                        this.$deprecated.element = true;
                    }
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
                return processorAction;
            }
        }));
        if (deprecated.element) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        return hidden.element;
    }
}

