/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ksp.com.intellij.codeWithMe.ClientId;
import ksp.com.intellij.core.CoreBundle;
import ksp.com.intellij.injected.editor.DocumentWindow;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.FileASTNode;
import ksp.com.intellij.lang.injection.InjectedLanguageManager;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.AppUIExecutor;
import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.application.ReadAction;
import ksp.com.intellij.openapi.application.TransactionGuard;
import ksp.com.intellij.openapi.application.TransactionGuardImpl;
import ksp.com.intellij.openapi.application.WriteAction;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.diagnostic.Attachment;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.editor.DocumentRunnable;
import ksp.com.intellij.openapi.editor.event.DocumentEvent;
import ksp.com.intellij.openapi.editor.event.DocumentListener;
import ksp.com.intellij.openapi.editor.ex.DocumentEx;
import ksp.com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import ksp.com.intellij.openapi.editor.impl.DocumentImpl;
import ksp.com.intellij.openapi.editor.impl.FrozenDocument;
import ksp.com.intellij.openapi.fileEditor.FileDocumentManager;
import ksp.com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import ksp.com.intellij.openapi.progress.EmptyProgressIndicator;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProgressIndicator;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.roots.FileIndexFacade;
import ksp.com.intellij.openapi.util.Computable;
import ksp.com.intellij.openapi.util.Disposer;
import ksp.com.intellij.openapi.util.EmptyRunnable;
import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.Ref;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.AbstractFileViewProvider;
import ksp.com.intellij.psi.ExternalChangeAction;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiDocumentListener;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiInvalidElementAccessException;
import ksp.com.intellij.psi.PsiLanguageInjectionHost;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import ksp.com.intellij.psi.SmartPointerManager;
import ksp.com.intellij.psi.impl.BlockSupportImpl;
import ksp.com.intellij.psi.impl.BooleanRunnable;
import ksp.com.intellij.psi.impl.DebugUtil;
import ksp.com.intellij.psi.impl.DiffLog;
import ksp.com.intellij.psi.impl.DocumentCommitProcessor;
import ksp.com.intellij.psi.impl.PsiManagerEx;
import ksp.com.intellij.psi.impl.PsiToDocumentSynchronizer;
import ksp.com.intellij.psi.impl.file.impl.FileManager;
import ksp.com.intellij.psi.impl.file.impl.FileManagerImpl;
import ksp.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import ksp.com.intellij.psi.impl.source.PsiFileImpl;
import ksp.com.intellij.psi.impl.source.tree.FileElement;
import ksp.com.intellij.psi.text.BlockSupport;
import ksp.com.intellij.psi.util.PsiUtilCore;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.ConcurrencyUtil;
import ksp.com.intellij.util.FileContentUtilCore;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.concurrency.Semaphore;
import ksp.com.intellij.util.containers.CollectionFactory;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.ui.EdtInvocationManager;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener,
Disposable {
    static final Logger LOG = Logger.getInstance(PsiDocumentManagerBase.class);
    private static final Key<Document> HARD_REF_TO_DOCUMENT = Key.create("HARD_REFERENCE_TO_DOCUMENT");
    private final Map<Document, List<Runnable>> myActionsAfterCommit;
    protected final Project myProject;
    private final PsiManager myPsiManager;
    private final DocumentCommitProcessor myDocumentCommitProcessor;
    final Set<Document> myUncommittedDocuments;
    private final Map<Document, UncommittedInfo> myUncommittedInfos;
    private final Key<UncommittedInfo> FREE_THREADED_UNCOMMITTED_INFO;
    boolean myStopTrackingDocuments;
    private boolean myPerformBackgroundCommit;
    private final ThreadLocal<Integer> myIsCommitInProgress;
    private static final ThreadLocal<Boolean> ourIsFullReparseInProgress = new ThreadLocal();
    private final PsiToDocumentSynchronizer mySynchronizer;
    private final List<PsiDocumentManager.Listener> myListeners;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY = ObjectUtils.sentinel("PERFORM_ALWAYS");

    protected PsiDocumentManagerBase(@NotNull Project project) {
        if (project == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(0);
        }
        this.myActionsAfterCommit = CollectionFactory.createConcurrentWeakMap();
        this.myUncommittedDocuments = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());
        this.myUncommittedInfos = new ConcurrentHashMap<Document, UncommittedInfo>();
        this.FREE_THREADED_UNCOMMITTED_INFO = Key.create("FREE_THREADED_UNCOMMITTED_INFO");
        this.myPerformBackgroundCommit = true;
        this.myIsCommitInProgress = new ThreadLocal();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project;
        this.myPsiManager = PsiManager.getInstance(project);
        this.myDocumentCommitProcessor = ApplicationManager.getApplication().getService(DocumentCommitProcessor.class);
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, project.getMessageBus());
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(1);
        }
        if (document2 instanceof DocumentWindow && !((DocumentWindow)document2).isValid()) {
            return null;
        }
        PsiFile psiFile = this.getCachedPsiFile(document2);
        if (psiFile != null) {
            return PsiDocumentManagerBase.ensureValidFile(psiFile, "Cached PSI");
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document2, psiFile);
        return psiFile;
    }

    @NotNull
    private static PsiFile ensureValidFile(@NotNull PsiFile psiFile, @NotNull @NonNls String debugInfo2) {
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(2);
        }
        if (debugInfo2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(3);
        }
        if (!psiFile.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)psiFile, debugInfo2);
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(4);
        }
        return psiFile2;
    }

    public void associatePsi(@NotNull Document document2, @NotNull PsiFile file2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (file2.getProject() != this.myProject) {
            throw new IllegalArgumentException("Method associatePsi() called with file from the wrong project. Expected: " + this.myProject + " but got: " + file2.getProject());
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (cachedDocument != null && cachedDocument != document2) {
            throw new IllegalStateException("Can't replace existing document");
        }
        FileDocumentManagerBase.registerDocument(document2, vFile);
    }

    @Override
    public final PsiFile getCachedPsiFile(@NotNull Document document2) {
        VirtualFile virtualFile2;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(7);
        }
        return (virtualFile2 = FileDocumentManager.getInstance().getFile(document2)) == null || !virtualFile2.isValid() ? null : this.getCachedPsiFile(virtualFile2);
    }

    @Nullable
    FileViewProvider getCachedViewProvider(@NotNull Document document2) {
        VirtualFile virtualFile2;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(8);
        }
        if ((virtualFile2 = PsiDocumentManagerBase.getVirtualFile(document2)) == null) {
            return null;
        }
        return this.getFileManager().findCachedViewProvider(virtualFile2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Document document2) {
        VirtualFile virtualFile2;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(document2)) == null || !virtualFile2.isValid()) {
            return null;
        }
        return virtualFile2;
    }

    @Nullable
    PsiFile getCachedPsiFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(10);
        }
        return this.getFileManager().getCachedPsiFile(virtualFile2);
    }

    @Nullable
    private PsiFile getPsiFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(11);
        }
        return this.getFileManager().findFile(virtualFile2);
    }

    @NotNull
    private FileManager getFileManager() {
        FileManager fileManager = ((PsiManagerEx)this.myPsiManager).getFileManager();
        if (fileManager == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(12);
        }
        return fileManager;
    }

    @Override
    public Document getDocument(@NotNull PsiFile file2) {
        Document document2;
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(13);
        }
        if ((document2 = this.getCachedDocument(file2)) != null) {
            if (!file2.getViewProvider().isPhysical()) {
                PsiUtilCore.ensureValid(file2);
                this.associatePsi(document2, file2);
            }
            return document2;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (!viewProvider.isEventSystemEnabled()) {
            return null;
        }
        document2 = FileDocumentManager.getInstance().getDocument(viewProvider.getVirtualFile());
        if (document2 != null) {
            if (document2.getTextLength() != file2.getTextLength()) {
                String message2 = "Document/PSI mismatch: " + file2 + " of " + file2.getClass() + "; viewProvider=" + viewProvider + "; uncommitted=" + Arrays.toString(this.getUncommittedDocuments());
                throw new RuntimeExceptionWithAttachments(message2, new Attachment("document.txt", document2.getText()), new Attachment("psi.txt", file2.getText()));
            }
            if (!viewProvider.isPhysical()) {
                PsiUtilCore.ensureValid(file2);
                this.associatePsi(document2, file2);
                file2.putUserData(HARD_REF_TO_DOCUMENT, document2);
            }
        }
        return document2;
    }

    @Override
    public Document getCachedDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(14);
        }
        if (!file2.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    @Override
    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsWriteThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document2 : documents = this.getUncommittedDocuments()) {
            if (this.isCommitted(document2)) {
                if (!this.isEventSystemEnabled(document2)) continue;
                LOG.error("Committed document in uncommitted set: " + document2);
                continue;
            }
            if (this.doCommit(document2)) continue;
            LOG.error("Couldn't commit " + document2);
        }
        LOG.assertTrue(!this.hasEventSystemEnabledUncommittedDocuments(), this.myUncommittedDocuments);
    }

    @Override
    public boolean commitAllDocumentsUnderProgress() {
        Application application = ApplicationManager.getApplication();
        if (application.isWriteThread()) {
            if (application.isWriteAccessAllowed()) {
                this.commitAllDocuments();
                if (!application.isUnitTestMode()) {
                    LOG.error("Do not call commitAllDocumentsUnderProgress inside write-action");
                }
                return true;
            }
            if (application.isUnitTestMode()) {
                WriteAction.run(() -> this.commitAllDocuments());
                return true;
            }
        }
        int semaphoreTimeoutInMs = 50;
        Runnable commitAllDocumentsRunnable = () -> {
            final Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread().later().submit(() -> PsiDocumentManager.getInstance(this.myProject).performWhenAllCommitted(new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }

                public String toString() {
                    return "commitAllDocumentsUnderProgress()";
                }
            }));
            while (!semaphore.waitFor(50L)) {
                ProgressManager.checkCanceled();
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(commitAllDocumentsRunnable, CoreBundle.message("progress.title.processing.documents", new Object[0]), true, this.myProject);
    }

    @Override
    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document2;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(15);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(16);
        }
        if (this.isCommitted(document2 = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            action.run();
        } else {
            this.addRunOnCommit(document2, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        if (key == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(17);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            if (!this.isCommitInProgress()) assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            action.run();
            return true;
        }
        this.checkWeAreOutsideAfterCommitHandler();
        this.actionsWhenAllDocumentsAreCommitted.put(key, ClientId.decorateRunnable(action));
        return false;
    }

    @ApiStatus.Internal
    public void addRunOnCommit(@NotNull Document document2, @NotNull Runnable action) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(19);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(20);
        }
        List actions = this.myActionsAfterCommit.computeIfAbsent(document2, __ -> ContainerUtil.createConcurrentList());
        actions.add(ClientId.decorateRunnable(action));
    }

    @NotNull
    private @NotNull Runnable @NotNull [] getAndClearActionsAfterCommit(@NotNull Document document2) {
        List<Runnable> list2;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(21);
        }
        Runnable[] runnableArray = (list2 = this.myActionsAfterCommit.remove(document2)) == null ? ArrayUtil.EMPTY_RUNNABLE_ARRAY : list2.toArray(ArrayUtil.EMPTY_RUNNABLE_ARRAY);
        if (runnableArray == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(22);
        }
        return runnableArray;
    }

    @Override
    public void commitDocument(@NotNull Document doc) {
        Document document2;
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(23);
        }
        if (this.isEventSystemEnabled(document2 = PsiDocumentManagerBase.getTopLevelDocument(doc))) {
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        }
        if (!this.isCommitted(document2)) {
            this.doCommit(document2);
        }
    }

    boolean isEventSystemEnabled(@NotNull Document document2) {
        FileViewProvider viewProvider;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(24);
        }
        return (viewProvider = this.getCachedViewProvider(document2)) != null && viewProvider.isEventSystemEnabled();
    }

    boolean finishCommit(final @NotNull Document document2, final @NotNull List<? extends BooleanRunnable> finishProcessors, final @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @NotNull Object reason) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(25);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(26);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(27);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(28);
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        if (this.isEventSystemEnabled(document2)) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        final boolean[] ok = new boolean[]{true};
        if (synchronously) {
            ok[0] = this.finishCommitInWriteAction(document2, finishProcessors, reparseInjectedProcessors, true);
        } else {
            ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(document2, this.myProject){

                @Override
                public void run() {
                    ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document2, finishProcessors, reparseInjectedProcessors, false);
                }
            });
        }
        if (ok[0]) {
            this.runAfterCommitActions(document2);
            if (DebugUtil.DO_EXPENSIVE_CHECKS && !ApplicationManagerEx.isInStressTest()) {
                this.checkAllElementsValid(document2, reason);
            }
        }
        return ok[0];
    }

    protected boolean finishCommitInWriteAction(@NotNull Document document2, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(29);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(30);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(31);
        }
        if (this.isEventSystemEnabled(document2)) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        assert (!(document2 instanceof DocumentWindow));
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile2 != null) {
            this.getSmartPointerManager().fastenBelts(virtualFile2);
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(document2);
        AtomicBoolean success = new AtomicBoolean(true);
        this.executeInsideCommit(() -> {
            try {
                success.set(ProgressManager.getInstance().computeInNonCancelableSection(() -> {
                    if (viewProvider == null) {
                        this.handleCommitWithoutPsi(document2);
                        return true;
                    }
                    return this.commitToExistingPsi(document2, finishProcessors, reparseInjectedProcessors, synchronously, virtualFile2);
                }));
            }
            catch (Throwable e) {
                try {
                    this.forceReload(virtualFile2, viewProvider);
                }
                finally {
                    LOG.error("Exception while committing " + viewProvider + ", eventSystemEnabled=" + this.isEventSystemEnabled(document2), e);
                }
            }
            finally {
                if (success.get()) {
                    this.myUncommittedDocuments.remove(document2);
                }
            }
        });
        return success.get();
    }

    private boolean commitToExistingPsi(@NotNull Document document2, @NotNull List<? extends BooleanRunnable> finishProcessors, @NotNull List<? extends BooleanRunnable> reparseInjectedProcessors, boolean synchronously, @Nullable VirtualFile virtualFile2) {
        FileViewProvider viewProvider;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(32);
        }
        if (finishProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(33);
        }
        if (reparseInjectedProcessors == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(34);
        }
        for (BooleanRunnable booleanRunnable : finishProcessors) {
            boolean bl = booleanRunnable.run();
            if (synchronously) assert (bl) : booleanRunnable + " in " + finishProcessors;
            if (bl) continue;
            return false;
        }
        this.clearUncommittedInfo(document2);
        if (virtualFile2 != null) {
            this.getSmartPointerManager().updatePointerTargetsAfterReparse(virtualFile2);
        }
        if ((viewProvider = this.getCachedViewProvider(document2)) != null) {
            viewProvider.contentsSynchronized();
        }
        for (BooleanRunnable booleanRunnable : reparseInjectedProcessors) {
            if (booleanRunnable.run()) continue;
            return false;
        }
        return true;
    }

    void forceReload(VirtualFile virtualFile2, @Nullable FileViewProvider viewProvider) {
        if (viewProvider != null) {
            DebugUtil.performPsiModification("psi.forceReload", () -> ((AbstractFileViewProvider)viewProvider).markInvalidated());
        }
        if (virtualFile2 != null) {
            ((FileManagerImpl)this.getFileManager()).forceReload(virtualFile2);
        }
    }

    private void checkAllElementsValid(@NotNull Document document2, final @NotNull Object reason) {
        PsiFile psiFile;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(35);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(36);
        }
        if ((psiFile = this.getCachedPsiFile(document2)) != null) {
            psiFile.accept(new PsiRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!element2.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element2 + "; Reason: '" + reason + "'"));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "ksp/com/intellij/psi/impl/PsiDocumentManagerBase$3", "visitElement"));
                }
            });
        }
    }

    private boolean doCommit(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(37);
        }
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        if (this.getSynchronizer().isDocumentAffectedByTransactions(document2)) {
            return false;
        }
        PsiFile psiFile = this.getPsiFile(document2);
        if (psiFile == null) {
            this.myUncommittedDocuments.remove(document2);
            this.runAfterCommitActions(document2);
            return true;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.doCommit(document2, psiFile));
        } else {
            this.doCommit(document2, psiFile);
        }
        return true;
    }

    private void doCommit(@NotNull Document document2, @NotNull PsiFile psiFile) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(38);
        }
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(39);
        }
        assert (!this.isCommitInProgress()) : "Do not call commitDocument() from inside PSI change listener";
        this.executeInsideCommit(() -> this.myDocumentCommitProcessor.commitSynchronously(document2, this.myProject, psiFile));
        assert (!this.isInUncommittedSet(document2)) : "Document :" + document2;
        this.runAfterCommitActions(document2);
    }

    public boolean isCommitInProgress() {
        return this.myIsCommitInProgress.get() != null || PsiDocumentManagerBase.isFullReparseInProgress();
    }

    private void executeInsideCommit(@NotNull Runnable runnable) {
        Integer counter;
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(40);
        }
        this.myIsCommitInProgress.set((counter = this.myIsCommitInProgress.get()) == null ? 1 : counter + 1);
        try {
            runnable.run();
        }
        finally {
            this.myIsCommitInProgress.set(counter);
        }
    }

    @ApiStatus.Internal
    public static boolean isFullReparseInProgress() {
        return ourIsFullReparseInProgress.get() == Boolean.TRUE;
    }

    @Override
    public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(41);
        }
        Ref<Object> ref = Ref.create(null);
        this.commitAndRunReadAction(() -> ref.set(computation.compute()));
        return ref.get();
    }

    @Override
    public void reparseFiles(@NotNull Collection<? extends VirtualFile> files2, boolean includeOpenFiles) {
        if (files2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(42);
        }
        FileContentUtilCore.reparseFiles(files2);
    }

    @Override
    public void commitAndRunReadAction(@NotNull Runnable runnable) {
        boolean executed;
        Application application;
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(43);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            this.commitAllDocuments();
            runnable.run();
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock. " + Thread.currentThread());
        }
        while (!(executed = ReadAction.compute(() -> {
            if (!this.hasEventSystemEnabledUncommittedDocuments()) {
                runnable.run();
                return true;
            }
            return false;
        }).booleanValue())) {
            ModalityState modality = ModalityState.defaultModalityState();
            Semaphore semaphore = new Semaphore(1);
            AppUIExecutor.onWriteThread(ModalityState.any()).submit(() -> {
                if (this.myProject.isDisposed()) {
                    semaphore.up();
                    return;
                }
                this.performWhenAllCommitted(modality, () -> semaphore.up());
            });
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    @Override
    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(44);
        }
        return this.performWhenAllCommitted(ModalityState.defaultModalityState(), action);
    }

    private boolean performWhenAllCommitted(@NotNull ModalityState modality, @NotNull Runnable action) {
        if (modality == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(45);
        }
        if (action == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(46);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkWeAreOutsideAfterCommitHandler();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (!this.hasEventSystemEnabledUncommittedDocuments()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(ClientId.decorateRunnable(action));
        if (modality != ModalityState.NON_MODAL && TransactionGuard.getInstance().isWriteSafeModality(modality)) {
            for (Document document2 : this.myUncommittedDocuments) {
                this.retainProviderAndCommitAsync(document2, "re-added because performWhenAllCommitted(" + modality + ") was called", modality);
            }
        }
        return false;
    }

    @Override
    public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(47);
        }
        this.performLaterWhenAllCommitted(ModalityState.defaultModalityState(), runnable);
    }

    @Override
    public void performLaterWhenAllCommitted(final @NotNull ModalityState modalityState, final @NotNull Runnable runnable) {
        if (modalityState == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(48);
        }
        if (runnable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(49);
        }
        Runnable whenAllCommitted = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (PsiDocumentManagerBase.this.hasEventSystemEnabledUncommittedDocuments()) {
                        PsiDocumentManagerBase.this.performLaterWhenAllCommitted(runnable);
                    } else {
                        runnable.run();
                    }
                }, modalityState, PsiDocumentManagerBase.this.myProject.getDisposed());
            }

            public String toString() {
                return "performLaterWhenAllCommitted()";
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread() && this.isInsideCommitHandler()) {
            whenAllCommitted.run();
        } else {
            EdtInvocationManager.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    this.performWhenAllCommitted(whenAllCommitted);
                }
            });
        }
    }

    private void runAfterCommitActions(@NotNull Document document2) {
        Runnable[] list2;
        Application app;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(50);
        }
        if (!(app = ApplicationManager.getApplication()).isDispatchThread() && this.isEventSystemEnabled(document2)) {
            app.invokeLater(() -> {
                if (!this.myProject.isDisposed() && this.isCommitted(document2)) {
                    this.runAfterCommitActions(document2);
                }
            });
            return;
        }
        for (Runnable runnable : list2 = this.getAndClearActionsAfterCommit(document2)) {
            runnable.run();
        }
        if (app.isDispatchThread()) {
            this.runActionsWhenAllCommitted();
        } else {
            app.invokeLater(() -> this.runActionsWhenAllCommitted(), this.myProject.getDisposed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActionsWhenAllCommitted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.mayRunActionsWhenAllCommitted()) {
            return;
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>(this.actionsWhenAllDocumentsAreCommitted.values());
        this.beforeCommitHandler();
        ArrayList<Pair<Runnable, Throwable>> exceptions = new ArrayList<Pair<Runnable, Throwable>>();
        try {
            for (Runnable runnable : actions) {
                try {
                    runnable.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    exceptions.add(Pair.create(runnable, e));
                }
            }
        }
        finally {
            this.actionsWhenAllDocumentsAreCommitted.clear();
        }
        for (Pair pair : exceptions) {
            Runnable action = (Runnable)pair.getFirst();
            Throwable e = (Throwable)pair.getSecond();
            LOG.error("During running " + action, e);
        }
    }

    private boolean mayRunActionsWhenAllCommitted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return !this.isCommitInProgress() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty() && !this.hasEventSystemEnabledUncommittedDocuments();
    }

    @Override
    public boolean hasEventSystemEnabledUncommittedDocuments() {
        return ContainerUtil.exists(this.myUncommittedDocuments, this::isEventSystemEnabled);
    }

    private void beforeCommitHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, EmptyRunnable.getInstance());
    }

    private void checkWeAreOutsideAfterCommitHandler() {
        if (this.isInsideCommitHandler()) {
            throw new IncorrectOperationException("You must not call performWhenAllCommitted()/cancelAndRunWhenCommitted() from within after-commit handler");
        }
    }

    private boolean isInsideCommitHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY) == EmptyRunnable.getInstance();
    }

    @Override
    public void addListener(@NotNull PsiDocumentManager.Listener listener2) {
        if (listener2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(51);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(52);
        }
        return false;
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(53);
        }
    }

    void fireDocumentCreated(@NotNull Document document2, PsiFile file2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(54);
        }
        this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC).documentCreated(document2, file2, this.myProject);
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.documentCreated(document2, file2);
        }
    }

    private void fireFileCreated(@NotNull Document document2, @NotNull PsiFile file2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(55);
        }
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(56);
        }
        this.myProject.getMessageBus().syncPublisher(PsiDocumentListener.TOPIC).fileCreated(file2, document2);
        for (PsiDocumentManager.Listener listener2 : this.myListeners) {
            listener2.fileCreated(file2, document2);
        }
    }

    @Override
    @NotNull
    public CharSequence getLastCommittedText(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(57);
        }
        CharSequence charSequence = this.getLastCommittedDocument(document2).getImmutableCharSequence();
        if (charSequence == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(58);
        }
        return charSequence;
    }

    @Override
    public long getLastCommittedStamp(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(59);
        }
        return this.getLastCommittedDocument(PsiDocumentManagerBase.getTopLevelDocument(document2)).getModificationStamp();
    }

    @Override
    @Nullable
    public Document getLastCommittedDocument(@NotNull PsiFile file2) {
        Document document2;
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(60);
        }
        return (document2 = this.getDocument(file2)) == null ? null : this.getLastCommittedDocument(document2);
    }

    @NotNull
    public DocumentEx getLastCommittedDocument(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(61);
        }
        if (document2 instanceof FrozenDocument) {
            DocumentEx documentEx = (DocumentEx)document2;
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(62);
            }
            return documentEx;
        }
        if (document2 instanceof DocumentWindow) {
            DocumentWindow answer;
            DocumentWindow window = (DocumentWindow)document2;
            Document delegate2 = window.getDelegate();
            if (delegate2 instanceof FrozenDocument) {
                DocumentEx documentEx = (DocumentEx)((Object)window);
                if (documentEx == null) {
                    PsiDocumentManagerBase.$$$reportNull$$$0(63);
                }
                return documentEx;
            }
            if (!window.isValid()) {
                throw new AssertionError((Object)("host committed: " + this.isCommitted(delegate2) + ", window=" + window));
            }
            UncommittedInfo info = this.getUncommittedInfo(delegate2);
            DocumentWindow documentWindow = answer = info == null ? null : (DocumentWindow)info.myFrozenWindows.get(document2);
            if (answer == null) {
                answer = this.freezeWindow(window);
            }
            if (info != null) {
                answer = ConcurrencyUtil.cacheOrGet(info.myFrozenWindows, window, answer);
            }
            DocumentEx documentEx = (DocumentEx)((Object)answer);
            if (documentEx == null) {
                PsiDocumentManagerBase.$$$reportNull$$$0(64);
            }
            return documentEx;
        }
        assert (document2 instanceof DocumentImpl);
        UncommittedInfo info = this.getUncommittedInfo(document2);
        FrozenDocument frozenDocument = info != null ? info.myFrozen : ((DocumentImpl)document2).freeze();
        if (frozenDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(65);
        }
        return frozenDocument;
    }

    @Nullable
    private UncommittedInfo getUncommittedInfo(@NotNull Document document2) {
        UncommittedInfo info;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(66);
        }
        return (info = this.myUncommittedInfos.get(document2)) != null ? info : document2.getUserData(this.FREE_THREADED_UNCOMMITTED_INFO);
    }

    private void associateUncommittedInfo(Document document2, UncommittedInfo info) {
        if (this.isEventSystemEnabled(document2)) {
            this.myUncommittedInfos.put(document2, info);
        } else {
            document2.putUserData(this.FREE_THREADED_UNCOMMITTED_INFO, info);
        }
    }

    @NotNull
    protected DocumentWindow freezeWindow(@NotNull DocumentWindow document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(67);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public List<DocumentEvent> getEventsSinceCommit(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(68);
        }
        assert (document2 instanceof DocumentImpl) : document2;
        UncommittedInfo info = this.getUncommittedInfo(document2);
        if (info != null) {
            return new ArrayList<DocumentEvent>(info.myEvents);
        }
        List<DocumentEvent> list2 = Collections.emptyList();
        if (list2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(69);
        }
        return list2;
    }

    @Override
    @NotNull
    public @NotNull Document @NotNull [] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document[] documents = this.myUncommittedDocuments.toArray(Document.EMPTY_ARRAY);
        Document[] documentArray = ArrayUtil.stripTrailingNulls(documents);
        if (documentArray == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(70);
        }
        return documentArray;
    }

    boolean isInUncommittedSet(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(71);
        }
        return this.myUncommittedDocuments.contains(PsiDocumentManagerBase.getTopLevelDocument(document2));
    }

    @Override
    public boolean isUncommited(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(72);
        }
        return !this.isCommitted(document2);
    }

    @Override
    public boolean isCommitted(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(73);
        }
        document2 = PsiDocumentManagerBase.getTopLevelDocument(document2);
        if (this.getSynchronizer().isInSynchronization(document2)) {
            return true;
        }
        return (!(document2 instanceof DocumentEx) || !((DocumentEx)document2).isInEventsHandling()) && !this.isInUncommittedSet(document2);
    }

    @NotNull
    private static Document getTopLevelDocument(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(74);
        }
        Document document3 = document2 instanceof DocumentWindow ? ((DocumentWindow)document2).getDelegate() : document2;
        if (document3 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(75);
        }
        return document3;
    }

    @Override
    public boolean hasUncommitedDocuments() {
        return !this.isCommitInProgress() && !this.myUncommittedDocuments.isEmpty();
    }

    @Override
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        FileViewProvider viewProvider;
        boolean inMyProject;
        boolean isRelevant;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(76);
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document2 = event.getDocument();
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        boolean bl = isRelevant = virtualFile2 != null && this.isRelevant(virtualFile2);
        if (document2 instanceof DocumentImpl && this.getUncommittedInfo(document2) == null) {
            this.associateUncommittedInfo(document2, new UncommittedInfo((DocumentImpl)document2));
        }
        boolean bl2 = inMyProject = (viewProvider = this.getCachedViewProvider(document2)) != null && viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            return;
        }
        List<PsiFile> files2 = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file2 : files2) {
            if (file2 == null) {
                throw new AssertionError((Object)("View provider " + viewProvider + " (" + viewProvider.getClass() + ") returned null in its files array: " + files2 + " for file " + viewProvider.getVirtualFile()));
            }
            if (!PsiToDocumentSynchronizer.isInsideAtomicChange(file2)) continue;
            psiCause = file2;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(77);
        }
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent event) {
        boolean forceCommit;
        boolean inMyProject;
        if (event == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(78);
        }
        if (this.myStopTrackingDocuments || this.myProject.isDisposed()) {
            return;
        }
        Document document2 = event.getDocument();
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        boolean isRelevant = virtualFile2 != null && this.isRelevant(virtualFile2);
        FileViewProvider viewProvider = this.getCachedViewProvider(document2);
        if (viewProvider == null) {
            this.handleCommitWithoutPsi(document2);
            return;
        }
        boolean bl = inMyProject = viewProvider.getManager() == this.myPsiManager;
        if (!isRelevant || !inMyProject) {
            this.clearUncommittedInfo(document2);
            return;
        }
        List<PsiFile> files2 = viewProvider.getAllFiles();
        if (files2.isEmpty()) {
            this.handleCommitWithoutPsi(document2);
            return;
        }
        boolean commitNecessary = !ContainerUtil.exists(files2, file2 -> PsiToDocumentSynchronizer.isInsideAtomicChange(file2) || !(file2 instanceof PsiFileImpl));
        Application application = ApplicationManager.getApplication();
        boolean bl2 = forceCommit = application.hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty("idea.force.commit.on.external.change", false) || application.isHeadlessEnvironment() && !application.isUnitTestMode());
        if (event.isWholeTextReplaced() && document2.getTextLength() > 100000) {
            document2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document2 instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document2);
            if (forceCommit) {
                this.commitDocument(document2);
            } else if (!document2.isInBulkUpdate() && this.myPerformBackgroundCommit) {
                this.retainProviderAndCommitAsync(document2, event, ModalityState.defaultModalityState());
            }
        } else {
            this.clearUncommittedInfo(document2);
        }
    }

    @Override
    public void bulkUpdateStarting(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(79);
        }
        document2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
    }

    @Override
    public void bulkUpdateFinished(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(80);
        }
        this.retainProviderAndCommitAsync(document2, "Bulk update finished", ModalityState.defaultModalityState());
    }

    private void retainProviderAndCommitAsync(@NotNull Document document2, @NotNull Object reason, @NotNull ModalityState modality) {
        FileViewProvider viewProvider;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(81);
        }
        if (reason == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(82);
        }
        if (modality == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(83);
        }
        if ((viewProvider = this.getCachedViewProvider(document2)) != null && viewProvider.isEventSystemEnabled()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, this, document2, reason, modality, viewProvider);
        }
    }

    void handleCommitWithoutPsi(@NotNull Document document2) {
        UncommittedInfo prevInfo;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(84);
        }
        if ((prevInfo = this.clearUncommittedInfo(document2)) == null) {
            return;
        }
        this.myUncommittedDocuments.remove(document2);
        if (!this.myProject.isInitialized() || this.myProject.isDisposed() || this.myProject.isDefault()) {
            return;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile2 != null) {
            FileManager fileManager = this.getFileManager();
            FileViewProvider viewProvider = fileManager.findCachedViewProvider(virtualFile2);
            if (viewProvider != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ((AbstractFileViewProvider)viewProvider).onContentReload());
            } else if (FileIndexFacade.getInstance(this.myProject).isInContent(virtualFile2)) {
                ApplicationManager.getApplication().runWriteAction(() -> ((FileManagerImpl)fileManager).firePropertyChangedForUnloadedPsi());
            }
        }
        this.runAfterCommitActions(document2);
    }

    @Nullable
    private UncommittedInfo clearUncommittedInfo(@NotNull Document document2) {
        UncommittedInfo info;
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(85);
        }
        if ((info = this.getUncommittedInfo(document2)) != null) {
            this.myUncommittedInfos.remove(document2);
            document2.putUserData(this.FREE_THREADED_UNCOMMITTED_INFO, null);
            this.getSmartPointerManager().updatePointers(document2, info.myFrozen, info.myEvents);
        }
        return info;
    }

    private SmartPointerManagerImpl getSmartPointerManager() {
        return (SmartPointerManagerImpl)SmartPointerManager.getInstance(this.myProject);
    }

    private boolean isRelevant(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(86);
        }
        return !this.myProject.isDisposed() && !virtualFile2.getFileType().isBinary();
    }

    public static boolean checkConsistency(@NotNull PsiFile psiFile, @NotNull Document document2) {
        int i;
        if (psiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(87);
        }
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(88);
        }
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document2.getCharsSequence();
        int documentLength = document2.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        @NonNls String error = "File '" + psiFile.getName() + "' text mismatch after reparse. File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document2 instanceof DocumentWindow) {
            error = error + "doc: '" + document2.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context2 = InjectedLanguageManager.getInstance(psiFile.getProject()).getInjectionHost(psiFile);
            if (context2 != null) {
                error = error + "context: " + context2 + "; text: '" + context2.getText() + "'\n";
                error = error + "context file: " + context2.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document2).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    @TestOnly
    public void clearUncommittedDocuments() {
        this.myUncommittedInfos.clear();
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    @TestOnly
    public void disableBackgroundCommit(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(89);
        }
        assert (this.myPerformBackgroundCommit);
        this.myPerformBackgroundCommit = false;
        Disposer.register(parentDisposable, () -> {
            this.myPerformBackgroundCommit = true;
        });
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public PsiToDocumentSynchronizer getSynchronizer() {
        PsiToDocumentSynchronizer psiToDocumentSynchronizer = this.mySynchronizer;
        if (psiToDocumentSynchronizer == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(90);
        }
        return psiToDocumentSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFileFromText(@NotNull PsiFileImpl file2) {
        if (file2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(91);
        }
        if (this.isCommitInProgress()) {
            throw new IllegalStateException("Re-entrant commit is not allowed");
        }
        FileElement node = file2.calcTreeElement();
        CharSequence text = node.getChars();
        ourIsFullReparseInProgress.set(Boolean.TRUE);
        try {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize(ProgressIndicatorProvider.getGlobalProgressIndicator());
            DiffLog log2 = BlockSupportImpl.makeFullParse((PsiFileImpl)file2, (FileASTNode)node, (CharSequence)text, (ProgressIndicator)indicator, (CharSequence)text).log;
            log2.doActualPsiChange(file2);
            file2.getViewProvider().contentsSynchronized();
        }
        finally {
            ourIsFullReparseInProgress.remove();
        }
    }

    @NotNull
    List<BooleanRunnable> reparseChangedInjectedFragments(@NotNull Document hostDocument, @NotNull PsiFile hostPsiFile, @NotNull TextRange range, @NotNull ProgressIndicator indicator, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        if (hostDocument == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(92);
        }
        if (hostPsiFile == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(93);
        }
        if (range == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(94);
        }
        if (indicator == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(95);
        }
        if (oldRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(96);
        }
        if (newRoot == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(97);
        }
        List<BooleanRunnable> list2 = Collections.emptyList();
        if (list2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(98);
        }
        return list2;
    }

    @TestOnly
    public boolean isDefaultProject() {
        return this.myProject.isDefault();
    }

    public String someDocumentDebugInfo(@NotNull Document document2) {
        if (document2 == null) {
            PsiDocumentManagerBase.$$$reportNull$$$0(99);
        }
        FileViewProvider viewProvider = this.getCachedViewProvider(document2);
        return "cachedProvider: " + viewProvider + "; isEventSystemEnabled: " + this.isEventSystemEnabled(document2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 22: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 75: 
            case 90: 
            case 98: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 22: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 75: 
            case 90: 
            case 98: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 19: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 50: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 79: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 88: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 39: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugInfo";
                break;
            }
            case 4: 
            case 12: 
            case 22: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 75: 
            case 90: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 56: 
            case 60: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 15: 
            case 23: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 27: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 28: 
            case 36: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 40: 
            case 43: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 45: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/PsiDocumentManagerBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValidFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndClearActionsAfterCommit";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedText";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommittedDocument";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSinceCommit";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncommittedDocuments";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelDocument";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynchronizer";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseChangedInjectedFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidFile";
                break;
            }
            case 4: 
            case 12: 
            case 22: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 75: 
            case 90: 
            case 98: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "associatePsi";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCachedViewProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performForCommittedDocument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRunWhenAllCommitted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addRunOnCommit";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAndClearActionsAfterCommit";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEventSystemEnabled";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "finishCommit";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "finishCommitInWriteAction";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "commitToExistingPsi";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkAllElementsValid";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "executeInsideCommit";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "commitAndRunReadAction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "reparseFiles";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "performWhenAllCommitted";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "performLaterWhenAllCommitted";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runAfterCommitActions";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentBlockedByPsi";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedOperationsAndUnblockDocument";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireDocumentCreated";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fireFileCreated";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedText";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedStamp";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommittedDocument";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getUncommittedInfo";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "freezeWindow";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getEventsSinceCommit";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isInUncommittedSet";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isUncommited";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isCommitted";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelDocument";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChangeOnUnlockedDocument";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "bulkUpdateStarting";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "bulkUpdateFinished";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "retainProviderAndCommitAsync";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedInfo";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isRelevant";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "checkConsistency";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "disableBackgroundCommit";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "reparseFileFromText";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "reparseChangedInjectedFragments";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "someDocumentDebugInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 12: 
            case 22: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 69: 
            case 70: 
            case 75: 
            case 90: 
            case 98: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UncommittedInfo {
        private final FrozenDocument myFrozen;
        private final List<DocumentEvent> myEvents;
        private final ConcurrentMap<DocumentWindow, DocumentWindow> myFrozenWindows;

        private UncommittedInfo(@NotNull DocumentImpl original) {
            if (original == null) {
                UncommittedInfo.$$$reportNull$$$0(0);
            }
            this.myEvents = new ArrayList<DocumentEvent>();
            this.myFrozenWindows = new ConcurrentHashMap<DocumentWindow, DocumentWindow>();
            this.myFrozen = original.freeze();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "ksp/com/intellij/psi/impl/PsiDocumentManagerBase$UncommittedInfo", "<init>"));
        }
    }

    @ApiStatus.Internal
    public class PriorityEventCollector
    implements PrioritizedDocumentListener {
        @Override
        public int getPriority() {
            return 40;
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent event) {
            UncommittedInfo info;
            if (event == null) {
                PriorityEventCollector.$$$reportNull$$$0(0);
            }
            if ((info = PsiDocumentManagerBase.this.getUncommittedInfo(event.getDocument())) != null) {
                info.myEvents.add(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ksp/com/intellij/psi/impl/PsiDocumentManagerBase$PriorityEventCollector", "documentChanged"));
        }
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable : this) {
                runnable.run();
            }
        }
    }
}

