/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import ksp.com.intellij.openapi.vfs.impl.PrimeFinder;

final class AddonlyKeylessHash<K, V> {
    private int size;
    private Object[] entries;
    private final KeyValueMapper<K, V> keyValueMapper;

    AddonlyKeylessHash(KeyValueMapper<K, V> _keyValueMapper) {
        this(4, _keyValueMapper);
    }

    AddonlyKeylessHash(int expectedSize, KeyValueMapper<K, V> _keyValueMapper) {
        int i = PrimeFinder.nextPrime(5 * expectedSize / 4 + 1);
        this.entries = new Object[i];
        this.keyValueMapper = _keyValueMapper;
    }

    public int size() {
        return this.size;
    }

    public void add(V item) {
        V v;
        if (this.size >= 4 * this.entries.length / 5) {
            this.rehash();
        }
        if ((v = this.doPut(this.entries, item)) == null) {
            ++this.size;
        }
    }

    private V doPut(Object[] a, V o) {
        K key = this.keyValueMapper.key(o);
        int index2 = this.hashIndex(a, key);
        Object obj = a[index2];
        a[index2] = o;
        return (V)obj;
    }

    private int hashIndex(Object[] a, K key) {
        int hash = this.keyValueMapper.hash(key) & Integer.MAX_VALUE;
        int index2 = hash % a.length;
        Object candidate2 = a[index2];
        if (candidate2 == null || this.keyValueMapper.valueHasKey(candidate2, key)) {
            return index2;
        }
        int probe = 1 + hash % (a.length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += a.length;
        } while ((candidate2 = a[index2]) != null && !this.keyValueMapper.valueHasKey(candidate2, key));
        return index2;
    }

    private void rehash() {
        Object[] b = new Object[PrimeFinder.nextPrime(this.entries.length * 2)];
        int i = this.entries.length;
        while (--i >= 0) {
            Object ns = this.entries[i];
            if (ns == null) continue;
            this.doPut(b, ns);
        }
        this.entries = b;
    }

    public V get(K key) {
        return (V)this.entries[this.hashIndex(this.entries, key)];
    }

    public static abstract class KeyValueMapper<K, V> {
        public abstract int hash(K var1);

        public abstract K key(V var1);

        public boolean valueHasKey(V value2, K key) {
            return key == this.key(value2);
        }

        protected boolean isIdentity() {
            return true;
        }
    }
}

