/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import ksp.org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.NameForAmbiguousParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001:\u0001HB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0011H\u0002J\u0010\u00106\u001a\u0002042\u0006\u00107\u001a\u000200H\u0002J\b\u00108\u001a\u000204H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u001e2\u0006\u00107\u001a\u00020:H\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\u001e2\u0006\u0010<\u001a\u00020\u001dH\u0002J\u0006\u0010=\u001a\u000204J\u0014\u0010>\u001a\u0002042\f\u0010?\u001a\b\u0012\u0004\u0012\u0002000%J\u000e\u0010@\u001a\u0002042\u0006\u0010A\u001a\u000200J\u0010\u0010B\u001a\u0002042\u0006\u00107\u001a\u00020:H\u0002J\u0018\u0010C\u001a\u0002042\u0006\u00107\u001a\u0002002\u0006\u0010D\u001a\u00020\u000bH\u0002J\u0014\u0010E\u001a\u0002042\f\u0010F\u001a\b\u0012\u0004\u0012\u0002000%J\u0018\u0010G\u001a\u0002042\u0006\u00107\u001a\u0002002\u0006\u0010D\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0014R-\u0010'\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0(j\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)`*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\u00020\u000b*\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006I"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor;", "", "useSiteSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "function", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "bodyResolveComponents", "Lksp/org/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "originScope", "Lksp/org/jetbrains/kotlin/fir/scopes/FirScope;", "isIndexedSetOperator", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Z)V", "currentPositionedParameterIndex", "", "<set-?>", "", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "forbiddenNamedArgumentsTarget", "Lksp/org/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "nameToParameter", "", "Lksp/org/jetbrains/kotlin/name/Name;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirValueParameter;", "namedDynamicArgumentsNames", "", "getNamedDynamicArgumentsNames", "()Ljava/util/Set;", "namedDynamicArgumentsNamesImpl", "parameters", "", "getParameters", "result", "Ljava/util/LinkedHashMap;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "state", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "varargArguments", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "isSpread", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "addDiagnostic", "", "diagnostic", "addVarargArgument", "argument", "completeVarargPositionArguments", "findParameterByName", "Lksp/org/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "getParameterByName", "name", "processDefaultsAndRunChecks", "processExcessLambdaArguments", "excessLambdaArguments", "processExternalArgument", "externalArgument", "processNamedArgument", "processNonLambdaArgument", "isLastArgument", "processNonLambdaArguments", "arguments", "processPositionArgument", "State", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,424:1\n1#2:425\n1853#3,2:426\n1192#3,2:439\n1220#3,4:441\n350#3,7:445\n81#4,7:428\n76#4,2:435\n57#4:437\n78#4:438\n*S KotlinDebug\n*F\n+ 1 FirArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor\n*L\n280#1:426,2\n333#1:439,2\n333#1:441,4\n394#1:445,7\n287#1:428,7\n287#1:435,2\n287#1:437\n287#1:438\n*E\n"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    private final boolean isIndexedSetOperator;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<FirExpression> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private Set<Name> namedDynamicArgumentsNamesImpl;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction function2, @NotNull BodyResolveComponents bodyResolveComponents2, @Nullable FirScope originScope, boolean isIndexedSetOperator) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)bodyResolveComponents2, (String)"bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents2;
        this.originScope = originScope;
        this.isIndexedSetOperator = isIndexedSetOperator;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ForbiddenNamedArgumentsTarget>(this){
            final /* synthetic */ FirCallArgumentsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ForbiddenNamedArgumentsTarget invoke() {
                FirScope firScope2;
                return ResolveUtilsKt.getAsForbiddenNamedArgumentsTarget(FirCallArgumentsProcessor.access$getFunction$p(this.this$0), FirCallArgumentsProcessor.access$getUseSiteSession$p(this.this$0), (firScope2 = FirCallArgumentsProcessor.access$getOriginScope$p(this.this$0)) instanceof FirTypeScope ? (FirTypeScope)firScope2 : null);
            }
        }));
    }

    private final Set<Name> getNamedDynamicArgumentsNames() {
        Set set = this.namedDynamicArgumentsNamesImpl;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            this.namedDynamicArgumentsNamesImpl = it;
            set = set2;
        }
        return set;
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        return (ForbiddenNamedArgumentsTarget)((Object)lazy.getValue());
    }

    public final void processNonLambdaArguments(@NotNull List<? extends FirExpression> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterator iterator2 = ((Iterable)arguments2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int argumentIndex = n++;
            FirExpression argument2 = (FirExpression)iterator2.next();
            if (argument2 instanceof FirVarargArgumentsExpression) {
                List<FirExpression> varargArguments = ((FirVarargArgumentsExpression)argument2).getArguments();
                Iterator iterator3 = ((Iterable)varargArguments).iterator();
                int n2 = 0;
                while (iterator3.hasNext()) {
                    int varargArgumentIndex = n2++;
                    FirExpression varargArgument = (FirExpression)iterator3.next();
                    this.processNonLambdaArgument(varargArgument, argumentIndex == CollectionsKt.getLastIndex(arguments2) && varargArgumentIndex == CollectionsKt.getLastIndex(varargArguments));
                }
                continue;
            }
            this.processNonLambdaArgument(argument2, argumentIndex == CollectionsKt.getLastIndex(arguments2));
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final void processNonLambdaArgument(FirExpression argument2, boolean isLastArgument) {
        if (!(argument2 instanceof FirNamedArgumentExpression)) {
            if (this.state == State.VARARG_POSITION && this.isIndexedSetOperator && isLastArgument) {
                this.completeVarargPositionArguments();
            }
            this.processPositionArgument(argument2, isLastArgument);
        } else if (Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            this.processPositionArgument(((FirNamedArgumentExpression)argument2).getExpression(), isLastArgument);
            if (!this.getNamedDynamicArgumentsNames().add(((FirNamedArgumentExpression)argument2).getName())) {
                this.addDiagnostic(new ArgumentPassedTwice((FirNamedArgumentExpression)argument2));
            }
        } else {
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((FirNamedArgumentExpression)argument2);
        }
    }

    private final void processPositionArgument(FirExpression argument2, boolean isLastArgument) {
        int n;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument2));
            return;
        }
        if (this.isIndexedSetOperator) {
            int lastParameterIndex = CollectionsKt.getLastIndex(this.getParameters());
            n = isLastArgument ? lastParameterIndex : (this.currentPositionedParameterIndex >= lastParameterIndex ? -1 : this.currentPositionedParameterIndex);
        } else {
            n = this.currentPositionedParameterIndex;
        }
        int assignedParameterIndex = n;
        FirValueParameter parameter2 = (FirValueParameter)CollectionsKt.getOrNull(this.getParameters(), (int)assignedParameterIndex);
        if (parameter2 == null) {
            this.addDiagnostic(new TooManyArguments(argument2, this.function));
            return;
        }
        if (!parameter2.isVararg()) {
            int n2 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n2 + 1;
            ((Map)this.result).put(parameter2, new ResolvedCallArgument.SimpleArgument(argument2));
            this.state = State.POSITION_ARGUMENTS;
        } else {
            this.addVarargArgument(argument2);
            this.state = State.VARARG_POSITION;
        }
    }

    private final void processNamedArgument(FirNamedArgumentExpression argument2) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget2 = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget2 != null) {
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget2;
            boolean bl = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(argument2, this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument2);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter2 = firValueParameter;
        ResolvedCallArgument resolvedCallArgument = this.result.get(parameter2);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument it = resolvedCallArgument;
            boolean bl = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument2));
            return;
        }
        ((Map)this.result).put(parameter2, new ResolvedCallArgument.SimpleArgument(argument2));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex), (Object)parameter2)) {
            this.state = State.POSITION_ARGUMENTS;
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull FirExpression externalArgument) {
        Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
        FirValueParameter lastParameter = (FirValueParameter)CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
            return;
        }
        if (!Intrinsics.areEqual((Object)this.function.getOrigin(), (Object)FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            if (lastParameter.isVararg()) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter);
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.function));
                return;
            }
            ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument(externalArgument));
        } else {
            ResolvedCallArgument existing = this.result.get(lastParameter);
            if (existing == null) {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument(externalArgument));
            } else {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.plus((Collection)existing.getArguments(), (Object)externalArgument)));
            }
        }
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends FirExpression> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, (String)"excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirExpression arg = (FirExpression)element$iv;
            boolean bl = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        for (Map.Entry entry : ((Map)this.result).entrySet()) {
            FirValueParameter parameter2 = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            if (parameter2.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Incorrect resolved argument for parameter " + parameter2.getClass() + ": " + resolvedArgument.getClass();
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$processDefaultsAndRunChecks_u24lambda_u244 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$processDefaultsAndRunChecks_u24lambda_u244, "parameter", parameter2);
                $this$processDefaultsAndRunChecks_u24lambda_u244.withEntryGroup("arguments", (Function1<? super ExceptionAttachmentBuilder, Unit>)((Function1)new Function1<ExceptionAttachmentBuilder, Unit>(resolvedArgument){
                    final /* synthetic */ ResolvedCallArgument $resolvedArgument;
                    {
                        this.$resolvedArgument = $resolvedArgument;
                        super(1);
                    }

                    public final void invoke(ExceptionAttachmentBuilder $this$withEntryGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$withEntryGroup, (String)"$this$withEntryGroup");
                        Iterator<T> iterator2 = ((Iterable)this.$resolvedArgument.getArguments()).iterator();
                        int n = 0;
                        while (iterator2.hasNext()) {
                            int index2 = n++;
                            FirExpression argument2 = (FirExpression)iterator2.next();
                            FirExceptionUtilsKt.withFirEntry($this$withEntryGroup, "argument" + index2, argument2);
                        }
                    }
                }));
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            if (!this.isSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument())) continue;
            this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
        }
        Iterator iterator2 = ((Iterable)this.getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirValueParameter parameter3 = (FirValueParameter)((Object)iterator2.next());
            if (this.result.containsKey(parameter3)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(this.useSiteSession, this.bodyResolveComponents.getScopeSession(), this.function, this.originScope, index2)) {
                ((Map)this.result).put(parameter3, ResolvedCallArgument.DefaultArgument.INSTANCE);
                continue;
            }
            if (parameter3.isVararg()) {
                ((Map)this.result).put(parameter3, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter3, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl;
        boolean bl2 = bl = this.state == State.VARARG_POSITION;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Incorrect state: " + (Object)((Object)this.state);
            throw new AssertionError((Object)string2);
        }
        FirValueParameter parameter2 = this.getParameters().get(this.currentPositionedParameterIndex);
        Map map = this.result;
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        map.put(parameter2, new ResolvedCallArgument.VarargArgument(list2));
    }

    private final void addVarargArgument(FirExpression argument2) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<FirExpression> list2 = this.varargArguments;
        Intrinsics.checkNotNull(list2);
        list2.add(argument2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name2) {
        if (this.nameToParameter == null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = this.getParameters();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FirValueParameter firValueParameter = (FirValueParameter)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getName(), element$iv$iv);
            }
            firCallArgumentsProcessor.nameToParameter = destination$iv$iv;
        }
        Map<Name, ? extends FirValueParameter> map = this.nameToParameter;
        Intrinsics.checkNotNull(map);
        return map.get(name2);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument2) {
        Ref.ObjectRef parameter2;
        block8: {
            int n;
            int n2;
            Ref.IntRef matchedIndex;
            FirNamedFunctionSymbol symbol2;
            block6: {
                void $this$indexOfFirst$iv;
                block7: {
                    parameter2 = new Ref.ObjectRef();
                    parameter2.element = this.getParameterByName(argument2.getName());
                    FirFunctionSymbol<? extends FirFunction> firFunctionSymbol = this.function.getSymbol();
                    symbol2 = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                    matchedIndex = new Ref.IntRef();
                    matchedIndex.element = -1;
                    if (parameter2.element != null) break block7;
                    if (symbol2 != null && ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function)) {
                        Ref.ObjectRef allowedParameters = new Ref.ObjectRef();
                        FirScope firScope2 = this.originScope;
                        FirTypeScope firTypeScope = firScope2 instanceof FirTypeScope ? (FirTypeScope)firScope2 : null;
                        if (firTypeScope != null) {
                            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(this, matchedIndex, (Ref.ObjectRef<FirValueParameter>)parameter2, (Ref.ObjectRef<List<FirValueParameterSymbol>>)allowedParameters, argument2){
                                final /* synthetic */ FirCallArgumentsProcessor this$0;
                                final /* synthetic */ Ref.IntRef $matchedIndex;
                                final /* synthetic */ Ref.ObjectRef<FirValueParameter> $parameter;
                                final /* synthetic */ Ref.ObjectRef<List<FirValueParameterSymbol>> $allowedParameters;
                                final /* synthetic */ FirNamedArgumentExpression $argument;
                                {
                                    this.this$0 = $receiver;
                                    this.$matchedIndex = $matchedIndex;
                                    this.$parameter = $parameter;
                                    this.$allowedParameters = $allowedParameters;
                                    this.$argument = $argument;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                                    ProcessorAction processorAction;
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    if (ResolveUtilsKt.getAsForbiddenNamedArgumentsTarget$default((FirFunction)it.getFir(), FirCallArgumentsProcessor.access$getUseSiteSession$p(this.this$0), null, 2, null) != null) {
                                        return ProcessorAction.NEXT;
                                    }
                                    List<FirValueParameterSymbol> someParameterSymbols = it.getValueParameterSymbols();
                                    if (this.$matchedIndex.element != -1) {
                                        processorAction = FirCallArgumentsProcessor.access$findParameterByName$findAndReportValueParameterWithDifferentName(someParameterSymbols, this.$matchedIndex, this.$argument, this.this$0);
                                    } else {
                                        int n;
                                        int n2;
                                        block9: {
                                            void $this$indexOfFirst$iv;
                                            List<FirValueParameterSymbol> list2 = someParameterSymbols;
                                            FirNamedArgumentExpression firNamedArgumentExpression = this.$argument;
                                            Ref.IntRef intRef = this.$matchedIndex;
                                            boolean $i$f$indexOfFirst = false;
                                            int index$iv = 0;
                                            for (E item$iv : $this$indexOfFirst$iv) {
                                                FirValueParameterSymbol originalParameter = (FirValueParameterSymbol)item$iv;
                                                boolean bl = false;
                                                if (Intrinsics.areEqual((Object)originalParameter.getName(), (Object)firNamedArgumentExpression.getName())) {
                                                    n2 = index$iv;
                                                    break block9;
                                                }
                                                ++index$iv;
                                            }
                                            n2 = -1;
                                        }
                                        intRef.element = n = n2;
                                        if (this.$matchedIndex.element != -1) {
                                            FirValueParameter someParameter;
                                            this.$parameter.element = FirCallArgumentsProcessor.access$getParameters(this.this$0).get(this.$matchedIndex.element);
                                            Object object = (List)this.$allowedParameters.element;
                                            FirValueParameter firValueParameter = object != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull((List)object, (int)this.$matchedIndex.element)) != null ? (FirValueParameter)((FirBasedSymbol)object).getFir() : (someParameter = null);
                                            if (someParameter != null) {
                                                FirCallArgumentsProcessor.access$addDiagnostic(this.this$0, new NameForAmbiguousParameter(this.$argument));
                                                processorAction = ProcessorAction.STOP;
                                            } else {
                                                processorAction = ProcessorAction.NEXT;
                                            }
                                        } else {
                                            this.$allowedParameters.element = someParameterSymbols;
                                            processorAction = ProcessorAction.NEXT;
                                        }
                                    }
                                    return processorAction;
                                }
                            }));
                        }
                    }
                    if (parameter2.element != null) break block8;
                    this.addDiagnostic(new NameNotFound(argument2, this.function));
                    break block8;
                }
                if (symbol2 == null || !ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function)) break block8;
                List<FirValueParameter> allowedParameters = this.getParameters();
                Ref.IntRef intRef = matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FirValueParameter originalParameter = (FirValueParameter)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)originalParameter.getName(), (Object)argument2.getName())) {
                        n2 = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if (matchedIndex.element != -1) {
                FirScope firScope3 = this.originScope;
                FirTypeScope firTypeScope = firScope3 instanceof FirTypeScope ? (FirTypeScope)firScope3 : null;
                if (firTypeScope != null) {
                    FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol2, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(this, matchedIndex, argument2){
                        final /* synthetic */ FirCallArgumentsProcessor this$0;
                        final /* synthetic */ Ref.IntRef $matchedIndex;
                        final /* synthetic */ FirNamedArgumentExpression $argument;
                        {
                            this.this$0 = $receiver;
                            this.$matchedIndex = $matchedIndex;
                            this.$argument = $argument;
                            super(1);
                        }

                        public final ProcessorAction invoke(FirNamedFunctionSymbol it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (ResolveUtilsKt.getAsForbiddenNamedArgumentsTarget$default((FirFunction)it.getFir(), FirCallArgumentsProcessor.access$getUseSiteSession$p(this.this$0), null, 2, null) != null) {
                                return ProcessorAction.NEXT;
                            }
                            return FirCallArgumentsProcessor.access$findParameterByName$findAndReportValueParameterWithDifferentName(it.getValueParameterSymbols(), this.$matchedIndex, this.$argument, this.this$0);
                        }
                    }));
                }
            }
        }
        return (FirValueParameter)parameter2.element;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list2 = this.diagnostics;
        Intrinsics.checkNotNull(list2);
        list2.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirWrappedArgumentExpression && ((FirWrappedArgumentExpression)$this$isSpread).isSpread();
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private static final ProcessorAction findParameterByName$findAndReportValueParameterWithDifferentName(List<FirValueParameterSymbol> $this$findParameterByName_u24findAndReportValueParameterWithDifferentName, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        Name someName;
        FirValueParameter someParameter;
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.getOrNull($this$findParameterByName_u24findAndReportValueParameterWithDifferentName, (int)matchedIndex.element);
        FirValueParameter firValueParameter = someParameter = firValueParameterSymbol != null ? (FirValueParameter)firValueParameterSymbol.getFir() : null;
        Name name2 = someName = firValueParameter != null ? firValueParameter.getName() : null;
        if (someName != null && !Intrinsics.areEqual((Object)someName, (Object)$argument.getName())) {
            this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    public static final /* synthetic */ FirSession access$getUseSiteSession$p(FirCallArgumentsProcessor $this) {
        return $this.useSiteSession;
    }

    public static final /* synthetic */ ProcessorAction access$findParameterByName$findAndReportValueParameterWithDifferentName(List $receiver, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        return FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName($receiver, matchedIndex, $argument, this$0);
    }

    public static final /* synthetic */ List access$getParameters(FirCallArgumentsProcessor $this) {
        return $this.getParameters();
    }

    public static final /* synthetic */ void access$addDiagnostic(FirCallArgumentsProcessor $this, ResolutionDiagnostic diagnostic) {
        $this.addDiagnostic(diagnostic);
    }

    public static final /* synthetic */ FirFunction access$getFunction$p(FirCallArgumentsProcessor $this) {
        return $this.function;
    }

    public static final /* synthetic */ FirScope access$getOriginScope$p(FirCallArgumentsProcessor $this) {
        return $this.originScope;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/FirCallArgumentsProcessor$State;", "", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolve"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

