/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util;

import javax.swing.Icon;
import ksp.com.intellij.psi.PsiModifierList;
import ksp.com.intellij.ui.IconManager;
import ksp.com.intellij.ui.icons.RowIcon;
import ksp.com.intellij.util.PlatformIcons;

public final class VisibilityIcons {
    private VisibilityIcons() {
    }

    public static void setVisibilityIcon(PsiModifierList modifierList2, RowIcon baseIcon) {
        if (modifierList2 != null) {
            if (modifierList2.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList2.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList2.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList2.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                Icon emptyIcon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else if (PlatformIcons.PUBLIC_ICON != null) {
            Icon emptyIcon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        switch (accessLevel) {
            case 4: {
                icon = PlatformIcons.PUBLIC_ICON;
                break;
            }
            case 3: {
                icon = PlatformIcons.PROTECTED_ICON;
                break;
            }
            case 2: {
                icon = PlatformIcons.PACKAGE_LOCAL_ICON;
                break;
            }
            case 1: {
                icon = PlatformIcons.PRIVATE_ICON;
                break;
            }
            default: {
                if (PlatformIcons.PUBLIC_ICON != null) {
                    icon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
                    break;
                }
                return;
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

