/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiConditionalExpression;
import ksp.com.intellij.psi.PsiConditionalLoopStatement;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiGuardedPattern;
import ksp.com.intellij.psi.PsiIfStatement;
import ksp.com.intellij.psi.PsiInstanceOfExpression;
import ksp.com.intellij.psi.PsiParenthesizedExpression;
import ksp.com.intellij.psi.PsiParenthesizedPattern;
import ksp.com.intellij.psi.PsiPattern;
import ksp.com.intellij.psi.PsiPatternVariable;
import ksp.com.intellij.psi.PsiPolyadicExpression;
import ksp.com.intellij.psi.PsiPrefixExpression;
import ksp.com.intellij.psi.PsiPrimaryPattern;
import ksp.com.intellij.psi.PsiPrimitiveType;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeTestPattern;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.util.InheritanceUtil;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiTypesUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression2) {
        PsiElement parent2;
        boolean parentMayAccept;
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        boolean bl = parentMayAccept = (parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent2).getOperationTokenType().equals(JavaTokenType.EXCL) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.OROR) || parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiIfStatement || parent2 instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            List<PsiPatternVariable> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<PsiPatternVariable> list3 = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list3, false);
        ArrayList<PsiPatternVariable> arrayList = list3;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiPatternVariable> list2 = new ArrayList<PsiPatternVariable>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list2, true);
        ArrayList<PsiPatternVariable> arrayList = list2;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable2) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        if ((instanceOf = ObjectUtils.tryCast((pattern = variable2.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiExpression operand = instanceOf.getOperand();
            PsiTypeElement checkType2 = ((PsiTypeTestPattern)pattern).getCheckType();
            if (checkType2 == null) {
                return null;
            }
            if (checkType2.getType().equals(operand.getType())) {
                return operand.getText();
            }
            return "(" + checkType2.getText() + ")" + operand.getText();
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiPattern skipParenthesizedPatternDown(PsiPattern pattern) {
        while (pattern instanceof PsiParenthesizedPattern) {
            pattern = ((PsiParenthesizedPattern)pattern).getPattern();
        }
        return pattern;
    }

    public static PsiElement skipParenthesizedPatternUp(PsiElement parent2) {
        while (parent2 instanceof PsiParenthesizedPattern) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPatternVariable getPatternVariable(@Nullable PsiPattern pattern) {
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        return null;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiType getPatternType(@Nullable PsiPattern pattern) {
        PsiTypeElement checkType2;
        if (pattern == null) {
            return null;
        }
        if (pattern instanceof PsiGuardedPattern) {
            return JavaPsiPatternUtil.getPatternType(((PsiGuardedPattern)pattern).getPrimaryPattern());
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternType(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern && (checkType2 = ((PsiTypeTestPattern)pattern).getCheckType()) != null) {
            return checkType2.getType();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isTotalForType(@Nullable PsiPattern pattern, @NotNull PsiType type2) {
        if (type2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            return false;
        }
        if (pattern instanceof PsiGuardedPattern) {
            PsiGuardedPattern guarded = (PsiGuardedPattern)pattern;
            Object constVal = JavaPsiPatternUtil.evaluateConstant(guarded.getGuardingExpression());
            return JavaPsiPatternUtil.isTotalForType(guarded.getPrimaryPattern(), type2) && Boolean.TRUE.equals(constVal);
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.isTotalForType(((PsiParenthesizedPattern)pattern).getPattern(), type2);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            type2 = TypeConversionUtil.erasure(type2);
            PsiType baseType2 = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(pattern));
            if (type2 instanceof PsiArrayType || baseType2 instanceof PsiArrayType) {
                return baseType2 != null && TypeConversionUtil.isAssignable(baseType2, type2);
            }
            PsiClass typeClass = PsiTypesUtil.getPsiClass(type2);
            PsiClass baseTypeClass = PsiTypesUtil.getPsiClass(baseType2);
            return typeClass != null && baseTypeClass != null && InheritanceUtil.isInheritorOrSelf(typeClass, baseTypeClass, true);
        }
        return false;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean dominates(@Nullable PsiPattern who, @NotNull PsiPattern overWhom) {
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        if (who == null) {
            return false;
        }
        if (overWhom instanceof PsiGuardedPattern) {
            if (who instanceof PsiTypeTestPattern) {
                PsiType whoType = JavaPsiPatternUtil.getPatternType(who);
                PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
                if (whoType != null && overWhomType != null && whoType.equalsToText(overWhomType.getCanonicalText())) {
                    return true;
                }
            } else {
                if (who instanceof PsiParenthesizedPattern) {
                    return JavaPsiPatternUtil.dominates(((PsiParenthesizedPattern)who).getPattern(), overWhom);
                }
                if (who instanceof PsiGuardedPattern) {
                    boolean dominates = JavaPsiPatternUtil.dominates((PsiPattern)((PsiGuardedPattern)who).getPrimaryPattern(), overWhom);
                    if (!dominates) {
                        return false;
                    }
                    Object constVal = JavaPsiPatternUtil.evaluateConstant(((PsiGuardedPattern)who).getGuardingExpression());
                    return Boolean.TRUE.equals(constVal);
                }
                return false;
            }
            return JavaPsiPatternUtil.dominates(who, ((PsiGuardedPattern)overWhom).getPrimaryPattern());
        }
        if (overWhom instanceof PsiParenthesizedPattern) {
            PsiPattern pattern = ((PsiParenthesizedPattern)overWhom).getPattern();
            if (pattern == null) {
                return false;
            }
            return JavaPsiPatternUtil.dominates(who, pattern);
        }
        if (overWhom instanceof PsiTypeTestPattern) {
            PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
            return overWhomType != null && JavaPsiPatternUtil.isTotalForType(who, overWhomType);
        }
        return false;
    }

    @Contract(value="_,null -> false", pure=true)
    public static boolean dominates(@NotNull PsiPattern who, @Nullable PsiType overWhom) {
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(8);
        }
        if (overWhom == null) {
            return false;
        }
        PsiType whoType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(who));
        if (whoType == null) {
            return false;
        }
        PsiType overWhomType = null;
        if (overWhom instanceof PsiPrimitiveType) {
            overWhomType = ((PsiPrimitiveType)overWhom).getBoxedType(who);
        } else if (overWhom instanceof PsiClassType) {
            overWhomType = overWhom;
        }
        return overWhomType != null && TypeConversionUtil.areTypesConvertible(overWhomType, whoType);
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope, @NotNull PsiExpression expression2, Collection<PsiPatternVariable> candidates2, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPatternVariable variable2;
        PsiPrimaryPattern pattern;
        if (scope == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(9);
        }
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(10);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression2 = ((PsiPrefixExpression)expression2).getOperand();
        }
        if (expression2 instanceof PsiInstanceOfExpression && (pattern = ((PsiInstanceOfExpression)expression2).getPattern()) instanceof PsiTypeTestPattern && (variable2 = ((PsiTypeTestPattern)pattern).getPatternVariable()) != null && !PsiTreeUtil.isAncestor(scope, variable2.getDeclarationScope(), strict)) {
            candidates2.add(variable2);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope, operand, candidates2, strict);
            }
        }
    }

    @Nullable
    private static Object evaluateConstant(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(expression2.getProject()).getConstantEvaluationHelper().computeConstantExpression(expression2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTotalForType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

