/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types.expressions;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DescriptorResolver;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.NewSchemeOfIntegerOperatorResolutionChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import ksp.org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import ksp.org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import ksp.org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import ksp.org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JD\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "expressionTypingServices", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "constantExpressionEvaluator", "Lksp/org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lksp/org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "resolveDefaultValue", "", "valueParameterDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "Lksp/org/jetbrains/kotlin/psi/KtParameter;", "context", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveValueParameters", "valueParameters", "", "valueParameterDescriptors", "declaringScope", "Lksp/org/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lksp/org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "inferenceSession", "Lksp/org/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "frontend"})
public final class ValueParameterResolver {
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.languageVersionSettings = languageVersionSettings2;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters2, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(valueParameters2, "valueParameters");
        Intrinsics.checkNotNullParameter(valueParameterDescriptors, "valueParameterDescriptors");
        Intrinsics.checkNotNullParameter(declaringScope, "declaringScope");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(trace, "trace");
        LexicalScopeImpl scopeForDefaultValue = new LexicalScopeImpl(declaringScope, declaringScope.getOwnerDescriptor(), false, null, CollectionsKt.emptyList(), LexicalScopeKind.DEFAULT_VALUE, null, null, 192, null);
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, scopeForDefaultValue, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        Intrinsics.checkNotNullExpressionValue(expressionTypingContext, "newContext(...)");
        ExpressionTypingContext contextForDefaultValue = expressionTypingContext;
        for (Pair pair : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters2)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component1();
            KtParameter parameter2 = (KtParameter)pair.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.resolveDefaultValue(descriptor2, parameter2, contextForDefaultValue);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter parameter2, ExpressionTypingContext context2) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = parameter2.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType type2 = kotlinType;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context2.replaceExpectedType(type2));
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        NewSchemeOfIntegerOperatorResolutionChecker.checkArgument(type2, defaultValue, bindingTrace, this.constantExpressionEvaluator.getModule$frontend());
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context2.scope))) {
            BindingTrace bindingTrace2 = context2.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
            CompileTimeConstant<?> constant = this.constantExpressionEvaluator.evaluateExpression(defaultValue, bindingTrace2, type2);
            if ((constant == null || constant.getUsesNonConstValAsConstant()) && !KotlinTypeKt.isError(type2)) {
                context2.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
            }
        }
    }
}

