/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import ksp.org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.ContractDescription;
import ksp.org.jetbrains.kotlin.contracts.description.ContractDescriptionElement;
import ksp.org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import ksp.org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import ksp.org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import ksp.org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import ksp.org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.deserialization.Flags;
import ksp.org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/serialization/ContractSerializer;", "", "()V", "serializeContractOfFunctionIfAny", "", "functionDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "proto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "parentSerializer", "Lksp/org/jetbrains/kotlin/serialization/DescriptorSerializer;", "ContractSerializerWorker", "serialization"})
public final class ContractSerializer {
    public final void serializeContractOfFunctionIfAny(@NotNull FunctionDescriptor functionDescriptor, @NotNull ProtoBuf.Function.Builder proto, @NotNull DescriptorSerializer parentSerializer) {
        ContractDescription contractDescription;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(parentSerializer, "parentSerializer");
        AbstractContractProvider abstractContractProvider = (AbstractContractProvider)functionDescriptor.getUserData(ContractProviderKey.INSTANCE);
        ContractDescription contractDescription2 = contractDescription = abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null;
        if (contractDescription != null) {
            ContractSerializerWorker worker = new ContractSerializerWorker(parentSerializer);
            proto.setContract(worker.contractProto(contractDescription));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker;", "", "parentSerializer", "Lksp/org/jetbrains/kotlin/serialization/DescriptorSerializer;", "(Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;)V", "constantValueProtobufEnum", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "constantReference", "Lksp/org/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "contractExpressionProto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Expression$Builder;", "contractDescriptionElement", "Lksp/org/jetbrains/kotlin/contracts/description/ContractDescriptionElement;", "contractDescription", "Lksp/org/jetbrains/kotlin/contracts/description/ContractDescription;", "contractProto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Contract$Builder;", "effectProto", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Effect$Builder;", "effectDeclaration", "Lksp/org/jetbrains/kotlin/contracts/description/EffectDeclaration;", "fillEffectProto", "", "builder", "invocationKindProtobufEnum", "Lksp/org/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "kind", "Lksp/org/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "writeFlags", "newFlagsValue", "", "serialization"})
    @SourceDebugExtension(value={"SMAP\nContractSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractSerializer.kt\norg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1853#2,2:212\n*S KotlinDebug\n*F\n+ 1 ContractSerializer.kt\norg/jetbrains/kotlin/serialization/ContractSerializer$ContractSerializerWorker\n*L\n43#1:212,2\n*E\n"})
    private static final class ContractSerializerWorker {
        @NotNull
        private final DescriptorSerializer parentSerializer;

        public ContractSerializerWorker(@NotNull DescriptorSerializer parentSerializer) {
            Intrinsics.checkNotNullParameter(parentSerializer, "parentSerializer");
            this.parentSerializer = parentSerializer;
        }

        @NotNull
        public final ProtoBuf.Contract.Builder contractProto(@NotNull ContractDescription contractDescription) {
            ProtoBuf.Contract.Builder builder2;
            Intrinsics.checkNotNullParameter(contractDescription, "contractDescription");
            ProtoBuf.Contract.Builder $this$contractProto_u24lambda_u241 = builder2 = ProtoBuf.Contract.newBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = contractDescription.getEffects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EffectDeclaration it = (EffectDeclaration)element$iv;
                boolean bl2 = false;
                $this$contractProto_u24lambda_u241.addEffect(this.effectProto(it, contractDescription));
            }
            ProtoBuf.Contract.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue(builder3, "apply(...)");
            return builder3;
        }

        private final ProtoBuf.Effect.Builder effectProto(EffectDeclaration effectDeclaration, ContractDescription contractDescription) {
            ProtoBuf.Effect.Builder builder2;
            ProtoBuf.Effect.Builder $this$effectProto_u24lambda_u242 = builder2 = ProtoBuf.Effect.newBuilder();
            boolean bl = false;
            Intrinsics.checkNotNull($this$effectProto_u24lambda_u242);
            this.fillEffectProto($this$effectProto_u24lambda_u242, effectDeclaration, contractDescription);
            ProtoBuf.Effect.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue(builder3, "apply(...)");
            return builder3;
        }

        private final void fillEffectProto(ProtoBuf.Effect.Builder builder2, EffectDeclaration effectDeclaration, ContractDescription contractDescription) {
            EffectDeclaration effectDeclaration2 = effectDeclaration;
            if (effectDeclaration2 instanceof ConditionalEffectDeclaration) {
                builder2.setConclusionOfConditionalEffect(this.contractExpressionProto(((ConditionalEffectDeclaration)effectDeclaration).getCondition(), contractDescription));
                this.fillEffectProto(builder2, ((ConditionalEffectDeclaration)effectDeclaration).getEffect(), contractDescription);
            } else if (effectDeclaration2 instanceof ReturnsEffectDeclaration) {
                if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getNOT_NULL())) {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
                } else if (Intrinsics.areEqual(((ReturnsEffectDeclaration)effectDeclaration).getValue(), ConstantReference.Companion.getWILDCARD())) {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                } else {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                    builder2.addEffectConstructorArgument(this.contractExpressionProto(((ReturnsEffectDeclaration)effectDeclaration).getValue(), contractDescription));
                }
            } else if (effectDeclaration2 instanceof CallsEffectDeclaration) {
                builder2.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                builder2.addEffectConstructorArgument(this.contractExpressionProto(((CallsEffectDeclaration)effectDeclaration).getVariableReference(), contractDescription));
                ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum = this.invocationKindProtobufEnum(((CallsEffectDeclaration)effectDeclaration).getKind());
                if (invocationKindProtobufEnum != null) {
                    builder2.setKind(invocationKindProtobufEnum);
                }
            }
        }

        private final ProtoBuf.Expression.Builder contractExpressionProto(ContractDescriptionElement contractDescriptionElement, ContractDescription contractDescription) {
            return (ProtoBuf.Expression.Builder)contractDescriptionElement.accept((ContractDescriptionVisitor)new ContractDescriptionVisitor<ProtoBuf.Expression.Builder, Unit>(this, contractDescription){
                final /* synthetic */ ContractSerializerWorker this$0;
                final /* synthetic */ ContractDescription $contractDescription;
                {
                    this.this$0 = $receiver;
                    this.$contractDescription = $contractDescription;
                }

                public ProtoBuf.Expression.Builder visitLogicalOr(LogicalOr logicalOr, Unit data2) {
                    ProtoBuf.Expression.Builder builder2;
                    Intrinsics.checkNotNullParameter(logicalOr, "logicalOr");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalOr.getLeft().accept(this, data2);
                    if (leftBuilder.getAndArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder3 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u240 = builder3;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(leftBuilder);
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), contractDescription));
                        ProtoBuf.Expression.Builder builder4 = builder3;
                        Intrinsics.checkNotNull(builder4);
                        builder2 = builder4;
                    } else {
                        ProtoBuf.Expression.Builder builder5 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u241 = builder5;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u241.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), contractDescription));
                        builder2 = builder5;
                    }
                    return builder2;
                }

                public ProtoBuf.Expression.Builder visitLogicalAnd(LogicalAnd logicalAnd, Unit data2) {
                    ProtoBuf.Expression.Builder builder2;
                    Intrinsics.checkNotNullParameter(logicalAnd, "logicalAnd");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalAnd.getLeft().accept(this, data2);
                    if (leftBuilder.getOrArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder3 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u242 = builder3;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(leftBuilder);
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), contractDescription));
                        ProtoBuf.Expression.Builder builder4 = builder3;
                        Intrinsics.checkNotNull(builder4);
                        builder2 = builder4;
                    } else {
                        ProtoBuf.Expression.Builder builder5 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        ContractDescription contractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u243 = builder5;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u243.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), contractDescription));
                        builder2 = builder5;
                    }
                    return builder2;
                }

                public ProtoBuf.Expression.Builder visitLogicalNot(LogicalNot logicalNot, Unit data2) {
                    Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    R r = logicalNot.getArg().accept(this, data2);
                    ContractSerializerWorker contractSerializerWorker = this.this$0;
                    ProtoBuf.Expression.Builder $this$visitLogicalNot_u24lambda_u244 = (ProtoBuf.Expression.Builder)r;
                    boolean bl = false;
                    ContractSerializerWorker.access$writeFlags(contractSerializerWorker, $this$visitLogicalNot_u24lambda_u244, Flags.IS_NEGATED.invert($this$visitLogicalNot_u24lambda_u244.getFlags()));
                    return (ProtoBuf.Expression.Builder)r;
                }

                public ProtoBuf.Expression.Builder visitIsInstancePredicate(IsInstancePredicate isInstancePredicate, Unit data2) {
                    Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder2 = this.visitVariableReference(isInstancePredicate.getArg(), data2);
                    builder2.setIsInstanceTypeId(ContractSerializerWorker.access$getParentSerializer$p(this.this$0).typeId(isInstancePredicate.getType()));
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder2, Flags.getContractExpressionFlags(isInstancePredicate.isNegated(), false));
                    return builder2;
                }

                public ProtoBuf.Expression.Builder visitIsNullPredicate(IsNullPredicate isNullPredicate, Unit data2) {
                    Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder2 = this.visitVariableReference(isNullPredicate.getArg(), data2);
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder2, Flags.getContractExpressionFlags(isNullPredicate.isNegated(), true));
                    return builder2;
                }

                public ProtoBuf.Expression.Builder visitConstantDescriptor(ConstantReference constantReference, Unit data2) {
                    Intrinsics.checkNotNullParameter(constantReference, "constantReference");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                    ProtoBuf.Expression.ConstantValue constantValueProtobufEnum = ContractSerializerWorker.access$constantValueProtobufEnum(this.this$0, constantReference);
                    if (constantValueProtobufEnum != null) {
                        builder2.setConstantValue(constantValueProtobufEnum);
                    }
                    Intrinsics.checkNotNull(builder2);
                    return builder2;
                }

                public ProtoBuf.Expression.Builder visitVariableReference(VariableReference variableReference, Unit data2) {
                    Integer indexOfParameter;
                    Integer n;
                    ParameterDescriptor descriptor2;
                    Intrinsics.checkNotNullParameter(variableReference, "variableReference");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                    ParameterDescriptor parameterDescriptor = descriptor2 = variableReference.getDescriptor();
                    if (parameterDescriptor instanceof ReceiverParameterDescriptor) {
                        n = 0;
                    } else if (parameterDescriptor instanceof ValueParameterDescriptor) {
                        Integer n2 = this.$contractDescription.getOwnerFunction().getValueParameters().indexOf(descriptor2);
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        Integer n3 = it != -1 ? n2 : null;
                        n = n3 != null ? Integer.valueOf(n3 + 1) : null;
                    } else {
                        n = null;
                    }
                    Integer n4 = indexOfParameter = n;
                    if (n4 == null) {
                        Intrinsics.checkNotNull(builder2);
                        return builder2;
                    }
                    builder2.setValueParameterReference(n4);
                    Intrinsics.checkNotNull(builder2);
                    return builder2;
                }
            }, Unit.INSTANCE);
        }

        private final void writeFlags(ProtoBuf.Expression.Builder $this$writeFlags, int newFlagsValue) {
            if ($this$writeFlags.getFlags() != newFlagsValue) {
                $this$writeFlags.setFlags(newFlagsValue);
            }
        }

        private final ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum(EventOccurrencesRange kind) {
            ProtoBuf.Effect.InvocationKind invocationKind;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    invocationKind = null;
                }
            }
            return invocationKind;
        }

        private final ProtoBuf.Expression.ConstantValue constantValueProtobufEnum(ConstantReference constantReference) {
            ProtoBuf.Expression.ConstantValue constantValue;
            ConstantReference constantReference2 = constantReference;
            if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getTRUE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.TRUE;
            } else if (Intrinsics.areEqual(constantReference2, BooleanConstantReference.Companion.getFALSE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.FALSE;
            } else if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNULL())) {
                constantValue = ProtoBuf.Expression.ConstantValue.NULL;
            } else {
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getNOT_NULL())) {
                    throw new IllegalStateException("Internal error during serialization of function contract: NOT_NULL constant isn't denotable in protobuf format. Its serialization should be handled at higher level");
                }
                if (Intrinsics.areEqual(constantReference2, ConstantReference.Companion.getWILDCARD())) {
                    constantValue = null;
                } else {
                    throw new IllegalArgumentException("Unknown constant: " + constantReference);
                }
            }
            return constantValue;
        }

        public static final /* synthetic */ DescriptorSerializer access$getParentSerializer$p(ContractSerializerWorker $this) {
            return $this.parentSerializer;
        }

        public static final /* synthetic */ void access$writeFlags(ContractSerializerWorker $this, ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            $this.writeFlags($receiver, newFlagsValue);
        }

        public static final /* synthetic */ ProtoBuf.Expression.ConstantValue access$constantValueProtobufEnum(ContractSerializerWorker $this, ConstantReference constantReference) {
            return $this.constantValueProtobufEnum(constantReference);
        }

        public static final /* synthetic */ ProtoBuf.Expression.Builder access$contractExpressionProto(ContractSerializerWorker $this, ContractDescriptionElement contractDescriptionElement, ContractDescription contractDescription) {
            return $this.contractExpressionProto(contractDescriptionElement, contractDescription);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EventOccurrencesRange.values().length];
                try {
                    nArray[EventOccurrencesRange.AT_MOST_ONCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.EXACTLY_ONCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

