/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.UpperBoundChecker;
import ksp.org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import ksp.org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jh\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142 \b\u0002\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0016J\\\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/WarningAwareUpperBoundChecker;", "Lksp/org/jetbrains/kotlin/resolve/UpperBoundChecker;", "typeChecker", "Lksp/org/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;)V", "checkBounds", "", "argumentReference", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "argumentType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "typeParameterDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "substitutor", "Lksp/org/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasUsageElement", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "withOnlyCheckForWarning", "", "diagnosticForTypeAliases", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "checkBoundsOfExpandedTypeAlias", "type", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "frontend.java"})
public final class WarningAwareUpperBoundChecker
extends UpperBoundChecker {
    public WarningAwareUpperBoundChecker(@NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        super(typeChecker);
    }

    @Override
    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        List<TypeParameterDescriptor> list2 = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getParameters(...)");
        List<TypeParameterDescriptor> typeParameters2 = list2;
        Iterator<TypeProjection> iterator2 = type2.getArguments().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            TypeProjection arg = iterator2.next();
            KotlinType kotlinType = arg.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            TypeParameterDescriptor typeParameterDescriptor = typeParameters2.get(index2);
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "get(...)");
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
            Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
            WarningAwareUpperBoundChecker.checkBounds$default(this, null, kotlinType, typeParameterDescriptor, typeSubstitutor2, trace, expression2, true, null, 128, null);
        }
    }

    @Override
    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        this.checkBounds(argumentReference, argumentType, typeParameterDescriptor, substitutor2, trace, typeAliasUsageElement, false, diagnosticForTypeAliases);
    }

    public final void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, boolean withOnlyCheckForWarning, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, diagnosticForTypeAliases, 8, null);
        DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> diagnosticFactory2 = ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS");
        DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticFactory3 = ErrorsJvm.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "UPPER_BOUND_VIOLATED_IN_\u2026BASED_ON_JAVA_ANNOTATIONS");
        UpperBoundViolatedReporter diagnosticsReporterForWarnings = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, diagnosticFactory2, diagnosticFactory3);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType enhancedBound;
            if (!withOnlyCheckForWarning) {
                Intrinsics.checkNotNull(bound);
                boolean isBaseCheckPassed = this.checkBound(bound, argumentType, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporter);
                if (!isBaseCheckPassed) continue;
            }
            Intrinsics.checkNotNull(bound);
            if (TypeWithEnhancementKt.getEnhancementDeeply(bound) == null) continue;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply(argumentType);
            if (kotlinType == null) {
                kotlinType = argumentType;
            }
            KotlinType argumentTypeEnhancement = kotlinType;
            this.checkBound(enhancedBound, argumentTypeEnhancement, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporterForWarnings);
        }
    }

    public static /* synthetic */ void checkBounds$default(WarningAwareUpperBoundChecker warningAwareUpperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor2, BindingTrace bindingTrace, KtElement ktElement, boolean bl, DiagnosticFactory3 diagnosticFactory3, int n, Object object) {
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticFactory32 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory32, "UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION");
            diagnosticFactory3 = diagnosticFactory32;
        }
        warningAwareUpperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor2, bindingTrace, ktElement, bl, diagnosticFactory3);
    }
}

