/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotated;
import ksp.org.jetbrains.kotlin.diagnostics.AbstractDiagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.Diagnostic;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AssignmentCheckUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AssignmentChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import ksp.org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeProjection;
import ksp.org.jetbrains.kotlin.types.TypeSubstitutor;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u009f\u0001\u0010\u0003\u001a\u0092\u0001\u0012\u008d\u0001\u0012\u008a\u0001\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0014\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\b \u0007*D\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012.\b\u0001\u0012*\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0014\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\b\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/AssignmentChecker;", "()V", "TYPE_MISMATCH_ERRORS", "", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticFactoryWithPsiElement;", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "kotlin.jvm.PlatformType", "Lksp/org/jetbrains/kotlin/diagnostics/AbstractDiagnostic;", "check", "", "assignmentExpression", "Lksp/org/jetbrains/kotlin/psi/KtBinaryExpression;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSyntheticAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n37#2,2:66\n2622#3,3:68\n*S KotlinDebug\n*F\n+ 1 JvmSyntheticAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSyntheticAssignmentChecker\n*L\n49#1:66,2\n60#1:68,3\n*E\n"})
public final class JvmSyntheticAssignmentChecker
implements AssignmentChecker {
    @NotNull
    public static final JvmSyntheticAssignmentChecker INSTANCE = new JvmSyntheticAssignmentChecker();
    @NotNull
    private static final Set<DiagnosticFactoryWithPsiElement<? extends KtExpression, ? extends AbstractDiagnostic<? extends KtExpression>>> TYPE_MISMATCH_ERRORS;

    private JvmSyntheticAssignmentChecker() {
    }

    @Override
    public void check(@NotNull KtBinaryExpression assignmentExpression, @NotNull CallCheckerContext context2) {
        boolean bl;
        KotlinType rValueType;
        KtExpression rValue;
        KotlinType substitutedPropertyType;
        block18: {
            Intrinsics.checkNotNullParameter(assignmentExpression, "assignmentExpression");
            Intrinsics.checkNotNullParameter(context2, "context");
            KtExpression ktExpression = assignmentExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KtElement ktElement = left;
            BindingContext bindingContext = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 == null) {
                return;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
            if (!TowerUtilsKt.isSynthesized(resultingDescriptor)) {
                return;
            }
            if (!(resultingDescriptor instanceof SyntheticJavaPropertyDescriptor)) {
                return;
            }
            Object object = resolvedCall3.getExtensionReceiver();
            if (object == null || (object = object.getType()) == null) {
                return;
            }
            Object receiverType2 = object;
            Annotated annotated = resolvedCall3.getCandidateDescriptor().getExtensionReceiverParameter();
            if (annotated == null || (annotated = annotated.getType()) == null) {
                return;
            }
            Annotated unsubstitutedReceiverType = annotated;
            if (((KotlinType)receiverType2).getConstructor() != ((KotlinType)unsubstitutedReceiverType).getConstructor()) {
                return;
            }
            KotlinType kotlinType = resolvedCall3.getCandidateDescriptor().getReturnType();
            if (kotlinType == null) {
                return;
            }
            KotlinType propertyType = kotlinType;
            List substitutionParameters = new ArrayList();
            List substitutionArguments = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)((KotlinType)unsubstitutedReceiverType).getArguments(), (Iterable)((KotlinType)receiverType2).getArguments())) {
                TypeParameterDescriptor typeParameter;
                TypeProjection unsubstitutedArgument = (TypeProjection)pair.component1();
                TypeProjection substitutedArgument = (TypeProjection)pair.component2();
                ClassifierDescriptor classifierDescriptor = unsubstitutedArgument.getType().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null) == null) continue;
                typeParameter = typeParameter;
                ((Collection)substitutionParameters).add(typeParameter);
                ((Collection)substitutionArguments).add(substitutedArgument);
            }
            Collection $this$toTypedArray$iv = substitutionParameters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = substitutionArguments;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new IndexedParametersSubstitution(thisCollection$iv.toArray(new TypeParameterDescriptor[0]), thisCollection$iv.toArray(new TypeProjection[0]), true));
            Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
            TypeSubstitutor substitutor2 = typeSubstitutor2;
            KotlinType kotlinType2 = substitutor2.substitute(propertyType.unwrap(), Variance.IN_VARIANCE);
            if (kotlinType2 == null) {
                return;
            }
            substitutedPropertyType = kotlinType2;
            if (TypeUtilsKt.isNothing(substitutedPropertyType)) {
                context2.getTrace().report(ErrorsJvm.SYNTHETIC_SETTER_PROJECTED_OUT.on((KtExpression)((PsiElement)left), resultingDescriptor));
                return;
            }
            KtExpression ktExpression2 = assignmentExpression.getRight();
            if (ktExpression2 == null) {
                return;
            }
            rValue = ktExpression2;
            BindingContext bindingContext2 = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
            KotlinType kotlinType3 = CallUtilKt.getType(rValue, bindingContext2);
            if (kotlinType3 == null) {
                return;
            }
            rValueType = kotlinType3;
            if (AssignmentCheckUtilsKt.isAssignmentCorrectWithDataFlowInfo(substitutedPropertyType, rValue, rValueType, context2)) {
                return;
            }
            Iterable $this$none$iv = context2.getTrace().getBindingContext().getDiagnostics().forElement(rValue);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!CollectionsKt.contains((Iterable)TYPE_MISMATCH_ERRORS, it.getFactory())) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            context2.getTrace().report(Errors.TYPE_MISMATCH_WARNING.on((KtExpression)((PsiElement)rValue), substitutedPropertyType, rValueType));
        }
    }

    static {
        DiagnosticFactoryWithPsiElement[] diagnosticFactoryWithPsiElementArray = new DiagnosticFactoryWithPsiElement[]{Errors.TYPE_MISMATCH, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE};
        TYPE_MISMATCH_ERRORS = SetsKt.setOf(diagnosticFactoryWithPsiElementArray);
    }
}

