/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import ksp.org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import ksp.org.jetbrains.kotlin.resolve.OverloadFilter;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/JvmOverloadFilter;", "Lksp/org/jetbrains/kotlin/resolve/OverloadFilter;", "()V", "filterPackageMemberOverloads", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "overloads", "frontend.java"})
public final class JvmOverloadFilter
implements OverloadFilter {
    @NotNull
    public static final JvmOverloadFilter INSTANCE = new JvmOverloadFilter();

    private JvmOverloadFilter() {
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptorNonRoot> filterPackageMemberOverloads(@NotNull Collection<? extends DeclarationDescriptorNonRoot> overloads) {
        Intrinsics.checkNotNullParameter(overloads, "overloads");
        ArrayList<DeclarationDescriptorNonRoot> result2 = new ArrayList<DeclarationDescriptorNonRoot>();
        HashSet<FqName> sourceClassesFQNs = new HashSet<FqName>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            KtFile file2;
            if (DescriptorToSourceUtils.getContainingFile(declarationDescriptorNonRoot) == null) continue;
            result2.add(declarationDescriptorNonRoot);
            sourceClassesFQNs.add(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : overloads) {
            FqName implClassFQN;
            if (declarationDescriptorNonRoot instanceof ConstructorDescriptor || !(declarationDescriptorNonRoot instanceof DeserializedCallableMemberDescriptor) || sourceClassesFQNs.contains(implClassFQN = JvmFileClassUtil.INSTANCE.getPartFqNameForDeserialized((DeserializedMemberDescriptor)declarationDescriptorNonRoot))) continue;
            result2.add(declarationDescriptorNonRoot);
        }
        return result2;
    }
}

