/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/ExpectActualClassifiersAreInBetaChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class ExpectActualClassifiersAreInBetaChecker
implements DeclarationChecker {
    @NotNull
    public static final ExpectActualClassifiersAreInBetaChecker INSTANCE = new ExpectActualClassifiersAreInBetaChecker();

    private ExpectActualClassifiersAreInBetaChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (CommonConfigurationKeysKt.getAreExpectActualClassesStable(context2.getLanguageVersionSettings())) {
            return;
        }
        if (!(descriptor2 instanceof TypeAliasDescriptor) && !(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtClassOrObject || declaration2 instanceof KtTypeAlias)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        if (!(declaration2 instanceof KtClassLikeDeclaration)) {
            String string3 = "Check failed.";
            throw new IllegalStateException(string3.toString());
        }
        if (!(descriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
            String string4 = "Check failed.";
            throw new IllegalStateException(string4.toString());
        }
        if (((ClassifierDescriptorWithTypeParameters)descriptor2).isExpect() || ((ClassifierDescriptorWithTypeParameters)descriptor2).isActual()) {
            context2.getTrace().report(Errors.EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING.on((KtClassLikeDeclaration)declaration2));
        }
    }
}

