/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import ksp.org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/SuspendConversionCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class SuspendConversionCallChecker
implements CallChecker {
    @NotNull
    public static final SuspendConversionCallChecker INSTANCE = new SuspendConversionCallChecker();

    private SuspendConversionCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendConversion)) {
            return;
        }
        Map<KotlinCallArgument, UnwrappedType> argumentsWithSuspendConversion = ((NewResolvedCallImpl)resolvedCall2).getResolvedCallAtom().getArgumentsWithSuspendConversion();
        for (KotlinCallArgument argumentWithSuspendConversion : argumentsWithSuspendConversion.keySet()) {
            context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(NewCallArgumentsKt.getPsiCallArgument(argumentWithSuspendConversion).getValueArgument().asElement(), TuplesKt.to(LanguageFeature.SuspendConversion, context2.getLanguageVersionSettings())));
        }
    }
}

