/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\"\u0010\u0003\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "checkersCache", "Ljava/lang/ref/WeakReference;", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "getChecker", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nInlineCheckerWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCheckerWrapper.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,50:1\n372#2,7:51\n*S KotlinDebug\n*F\n+ 1 InlineCheckerWrapper.kt\norg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper\n*L\n47#1:51,7\n*E\n"})
public final class InlineCheckerWrapper
implements CallChecker {
    @Nullable
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.isAnnotationContext()) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context2.getScope().getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            CallChecker checker = this.getChecker((FunctionDescriptor)parentDescriptor);
            checker.check(resolvedCall2, reportOn, context2);
        }
    }

    private final CallChecker getChecker(FunctionDescriptor descriptor2) {
        Object object;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference = this.checkersCache;
        Map map = weakReference != null ? (Map)weakReference.get() : null;
        Map map2 = map == null ? (Map)new HashMap() : map;
        WeakReference<Map> weakReference2 = this.checkersCache;
        if (weakReference2 == null) {
            weakReference2 = new WeakReference<Map>(map2);
        }
        this.checkersCache = weakReference2;
        Map $this$getOrPut$iv = map2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CallChecker answer$iv = new InlineChecker(descriptor2);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CallChecker)object;
    }
}

