/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/InfixCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class InfixCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object obj = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor = obj instanceof FunctionDescriptor ? (FunctionDescriptor)obj : null;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (functionDescriptor2.isInfix() || DynamicCallsKt.isDynamic(functionDescriptor2) || ErrorUtils.isError(functionDescriptor2)) {
            return;
        }
        Object object = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        if (object == null || (object = object.getVariableCall()) == null) {
            object = resolvedCall2;
        }
        Call call2 = object.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        Call call3 = call2;
        if (CallResolverUtilKt.isInfixCall(call3)) {
            DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            String string2 = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String containingDeclarationName = string2;
            context2.getTrace().report(Errors.INFIX_MODIFIER_REQUIRED.on(reportOn, functionDescriptor2, containingDeclarationName));
        }
    }
}

