/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker
implements CallChecker {
    @NotNull
    public static final CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker INSTANCE = new CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker();

    private CompanionIncorrectlyUnboundedWhenUsedAsLHSCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        PsiElement psiElement = resolvedCall2.getCall().getCallElement().getParent();
        KtCallableReferenceExpression ktCallableReferenceExpression = psiElement instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)psiElement : null;
        if (ktCallableReferenceExpression == null) {
            return;
        }
        KtCallableReferenceExpression callableReference2 = ktCallableReferenceExpression;
        Receiver receiver = resolvedCall2.getCall().getExplicitReceiver();
        ClassQualifier classQualifier = receiver instanceof ClassQualifier ? (ClassQualifier)receiver : null;
        if (classQualifier == null) {
            return;
        }
        ClassQualifier classQualifier2 = classQualifier;
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (receiverValue == null) {
            return;
        }
        ReceiverValue dispatchReceiver = receiverValue;
        if (!Intrinsics.areEqual(dispatchReceiver, classQualifier2.getClassValueReceiver())) {
            return;
        }
        if (!(context2.getResolutionContext().callPosition instanceof CallPosition.CallableReferenceRhs)) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = dispatchReceiver.getType().getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor2 == null) {
            return;
        }
        ClassDescriptor referencedClass = classDescriptor2;
        if (!referencedClass.isCompanionObject()) {
            return;
        }
        context2.getTrace().report(Errors.INCORRECT_CALLABLE_REFERENCE_RESOLUTION_FOR_COMPANION_LHS.on(callableReference2));
    }
}

