/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AssignmentCheckUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import ksp.org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nBuilderInferenceAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderInferenceAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n125#2:43\n1#3:44\n*S KotlinDebug\n*F\n+ 1 BuilderInferenceAssignmentChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/BuilderInferenceAssignmentChecker\n*L\n30#1:43\n*E\n"})
public final class BuilderInferenceAssignmentChecker
implements CallChecker {
    @NotNull
    public static final BuilderInferenceAssignmentChecker INSTANCE = new BuilderInferenceAssignmentChecker();

    private BuilderInferenceAssignmentChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        KotlinType kotlinType;
        KtBinaryExpression binaryExpression;
        block14: {
            block13: {
                KotlinType kotlinType2;
                void $this$getParentOfType$iv;
                Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
                Intrinsics.checkNotNullParameter(reportOn, "reportOn");
                Intrinsics.checkNotNullParameter(context2, "context");
                Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
                if (!(resultingDescriptor instanceof PropertyDescriptor)) {
                    return;
                }
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NoBuilderInferenceWithoutAnnotationRestriction)) {
                    return;
                }
                if (!(resolvedCall2.getCandidateDescriptor().getReturnType() instanceof StubTypeForBuilderInference)) {
                    return;
                }
                KtElement ktElement = resolvedCall2.getCall().getCallElement();
                Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
                KtElement callElement = ktElement;
                if (!(callElement instanceof KtNameReferenceExpression)) {
                    return;
                }
                PsiElement psiElement = callElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                KtBinaryExpression ktBinaryExpression = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtBinaryExpression.class, strict$iv);
                if (ktBinaryExpression == null) {
                    return;
                }
                binaryExpression = ktBinaryExpression;
                if (!Intrinsics.areEqual(binaryExpression.getOperationToken(), KtTokens.EQ)) {
                    return;
                }
                if (!BasicExpressionTypingVisitor.isLValue((KtSimpleNameExpression)callElement, binaryExpression)) {
                    return;
                }
                kotlinType = ((PropertyDescriptor)resultingDescriptor).getReturnType();
                if (kotlinType == null) break block13;
                KotlinType it = kotlinType2 = kotlinType;
                boolean bl = false;
                kotlinType = !KotlinTypeKt.isError(it) ? kotlinType2 : null;
                if (kotlinType != null) break block14;
            }
            return;
        }
        KotlinType leftType = kotlinType;
        KtExpression ktExpression = binaryExpression.getRight();
        if (ktExpression == null) {
            return;
        }
        KtExpression right = ktExpression;
        BindingContext bindingContext = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        KotlinType kotlinType3 = CallUtilKt.getType(right, bindingContext);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType rightType = kotlinType3;
        if (AssignmentCheckUtilsKt.isAssignmentCorrectWithDataFlowInfo(leftType, right, rightType, context2)) {
            return;
        }
        context2.getTrace().report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)right), leftType, rightType));
    }
}

