/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import ksp.org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation3;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtConstructor;
import ksp.org.jetbrains.kotlin.psi.KtFunction;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.KotlinTypeKt;
import ksp.org.jetbrains.kotlin.types.SimpleType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*JO\u0010+\u001a\u00020&\"\b\b\u0000\u0010,*\u00020-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002000/2\u0006\u00102\u001a\u0002H,2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u000201H\u0002\u00a2\u0006\u0002\u00105JO\u00106\u001a\u00020&\"\b\b\u0000\u0010,*\u00020-2\u001e\u0010.\u001a\u001a\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000200072\u0006\u00102\u001a\u0002H,2\u0006\u00103\u001a\u0002002\u0006\u00104\u001a\u000201H\u0002\u00a2\u0006\u0002\u00108R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lksp/org/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "checkClassHeader", "", "klass", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lksp/org/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorVisibility;", "checkFunction", "function", "Lksp/org/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lksp/org/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "checkTypeAlias", "", "typeAlias", "Lksp/org/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lksp/org/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "reportExposure", "E", "Lksp/com/intellij/psi/PsiElement;", "diagnostic", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lksp/org/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lksp/org/jetbrains/kotlin/descriptors/DescriptorWithRelation;", "element", "elementVisibility", "restrictingDescriptor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "reportExposureForDeprecation", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactoryForDeprecation3;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Lorg/jetbrains/kotlin/descriptors/DescriptorWithRelation;)V", "frontend"})
@SourceDebugExtension(value={"SMAP\nExposedVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedVisibilityChecker.kt\norg/jetbrains/kotlin/resolve/ExposedVisibilityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1862#2,3:225\n1862#2,3:228\n1862#2,3:231\n*S KotlinDebug\n*F\n+ 1 ExposedVisibilityChecker.kt\norg/jetbrains/kotlin/resolve/ExposedVisibilityChecker\n*L\n124#1:225,3\n187#1:228,3\n209#1:231,3\n*E\n"})
public final class ExposedVisibilityChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @Nullable
    private final BindingTrace trace;

    public ExposedVisibilityChecker(@NotNull LanguageVersionSettings languageVersionSettings2, @Nullable BindingTrace trace) {
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings2;
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(LanguageVersionSettings languageVersionSettings2, BindingTrace bindingTrace, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bindingTrace = null;
        }
        this(languageVersionSettings2, bindingTrace);
    }

    private final <E extends PsiElement> void reportExposure(DiagnosticFactory3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element2, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.PrivateInFileEffectiveVisibility) && Intrinsics.areEqual(elementVisibility, EffectiveVisibility.PrivateInFile.INSTANCE)) {
            trace.report(Errors.EXPOSED_FROM_PRIVATE_IN_FILE.on(element2, elementVisibility, restrictingDescriptor, restrictingVisibility));
        } else {
            trace.report(diagnostic.on(element2, elementVisibility, restrictingDescriptor, restrictingVisibility));
        }
    }

    private final <E extends PsiElement> void reportExposureForDeprecation(DiagnosticFactoryForDeprecation3<E, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnostic, E element2, EffectiveVisibility elementVisibility, DescriptorWithRelation restrictingDescriptor) {
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            return;
        }
        BindingTrace trace = bindingTrace;
        EffectiveVisibility restrictingVisibility = restrictingDescriptor.effectiveVisibility();
        trace.report(diagnostic.on(this.languageVersionSettings, element2, elementVisibility, restrictingDescriptor, restrictingVisibility));
    }

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass, @NotNull ClassDescriptor classDescriptor2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(classDescriptor2, "classDescriptor");
        boolean result2 = this.checkSupertypes(klass, classDescriptor2);
        result2 &= this.checkParameterBounds(klass, classDescriptor2);
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return result2;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, constructor2, constructorDescriptor, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter(modifierListOwner, "modifierListOwner");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(visibility2, "visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility2) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility2) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        Intrinsics.checkNotNullParameter(typeAliasDescriptor, "typeAliasDescriptor");
        SimpleType expandedType2 = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType2)) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(expandedType2, typeAliasVisibility);
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_TYPEALIAS_EXPANDED_TYPE");
            PsiElement psiElement = typeAlias.getNameIdentifier();
            if (psiElement == null) {
                psiElement = typeAlias;
            }
            this.reportExposure(diagnosticFactory3, psiElement, typeAliasVisibility, restricting);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(visibility2, "visibility");
        EffectiveVisibility functionVisibility = null;
        functionVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(functionDescriptor, visibility2, false, 2, null);
        if (functionDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getConstructedClass(...)");
            if (DescriptorUtilKt.isSealed(classDescriptor2) && KtPsiUtilKt.visibilityModifier(function2) == null) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean result2 = false;
        result2 = true;
        if (!(function2 instanceof KtConstructor)) {
            DescriptorWithRelation restricting;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            DescriptorWithRelation descriptorWithRelation = restricting = kotlinType != null ? EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_FUNCTION_RETURN_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_FUNCTION_RETURN_TYPE");
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                this.reportExposure(diagnosticFactory3, psiElement, functionVisibility, restricting);
                result2 = false;
            }
        }
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= function2.getValueParameters().size()) continue;
            KtParameter valueParameter2 = function2.getValueParameters().get(i);
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, functionVisibility);
            if (restricting != null) {
                DiagnosticFactory3<KtParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PARAMETER_TYPE;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_PARAMETER_TYPE");
                this.reportExposure(diagnosticFactory3, (PsiElement)valueParameter2, functionVisibility, restricting);
                result2 = false;
                continue;
            }
            if (!(functionDescriptor instanceof ClassConstructorDescriptor) || !valueParameter2.hasValOrVar()) continue;
            BindingTrace bindingTrace = this.trace;
            PropertyDescriptor propertyDescriptor = bindingTrace != null ? (PropertyDescriptor)bindingTrace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor) : null;
            MemberDescriptor memberDescriptor = propertyDescriptor;
            if (memberDescriptor == null) {
                ClassDescriptor classDescriptor3 = ((ClassConstructorDescriptor)functionDescriptor).getConstructedClass();
                memberDescriptor = classDescriptor3;
                Intrinsics.checkNotNullExpressionValue(classDescriptor3, "getConstructedClass(...)");
            }
            EffectiveVisibility propertyOrClassVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(memberDescriptor, null, false, 3, null);
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            DescriptorWithRelation restrictingByProperty = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType2, propertyOrClassVisibility);
            if (restrictingByProperty == null) continue;
            DiagnosticFactoryForDeprecation3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactoryForDeprecation3 = Errors.EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactoryForDeprecation3, "EXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR");
            PsiElement psiElement = valueParameter2.getNameIdentifier();
            if (psiElement == null) {
                psiElement = valueParameter2;
            }
            this.reportExposureForDeprecation(diagnosticFactoryForDeprecation3, psiElement, propertyOrClassVisibility, restrictingByProperty);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor, visibility2);
    }

    public static /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = functionDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "getVisibility(...)");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor, descriptorVisibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull DescriptorVisibility visibility2) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkNotNullParameter(visibility2, "visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(propertyDescriptor, visibility2, false, 2, null);
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            DiagnosticFactory3<PsiElement, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_PROPERTY_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_PROPERTY_TYPE");
            PsiElement psiElement = property.getNameIdentifier();
            if (psiElement == null) {
                psiElement = property;
            }
            this.reportExposure(diagnosticFactory3, psiElement, propertyVisibility, restricting);
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property.getReceiverTypeReference(), propertyDescriptor, visibility2);
    }

    public static /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, DescriptorVisibility descriptorVisibility, int n, Object object) {
        if ((n & 4) != 0) {
            DescriptorVisibility descriptorVisibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility2, "getVisibility(...)");
            descriptorVisibility = descriptorVisibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, descriptorVisibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor, DescriptorVisibility visibility2) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(memberDescriptor, visibility2, false, 2, null);
        KotlinType kotlinType = receiverParameterDescriptor2.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(kotlinType, memberVisibility);
        if (restricting != null) {
            DiagnosticFactory3<KtTypeReference, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_RECEIVER_TYPE;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_RECEIVER_TYPE");
            this.reportExposure(diagnosticFactory3, (PsiElement)typeReference, memberVisibility, restricting);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        boolean isInterface = classDescriptor2.getKind() == ClassKind.INTERFACE;
        List<KtSuperTypeListEntry> delegationList = klass.getSuperTypeListEntries();
        boolean result2 = false;
        result2 = true;
        Collection<KotlinType> collection = classDescriptor2.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, "getSupertypes(...)");
        Iterable $this$forEachIndexed$iv = collection;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean superIsInterface;
            ClassDescriptor classDescriptor3;
            void superType2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= delegationList.size()) {
                return result2;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType2) == null) continue;
            Intrinsics.checkNotNull(classDescriptor3);
            ClassDescriptor superDescriptor = classDescriptor3;
            boolean bl2 = superIsInterface = superDescriptor.getKind() == ClassKind.INTERFACE;
            if (superIsInterface != isInterface) continue;
            Intrinsics.checkNotNull(superType2);
            DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor((KotlinType)superType2, classVisibility);
            if (restricting == null) continue;
            DiagnosticFactory3<KtSuperTypeListEntry, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = isInterface ? Errors.EXPOSED_SUPER_INTERFACE : Errors.EXPOSED_SUPER_CLASS;
            Intrinsics.checkNotNull(diagnosticFactory3);
            this.reportExposure(diagnosticFactory3, (PsiElement)delegationList.get(i), classVisibility, restricting);
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass, ClassDescriptor classDescriptor2) {
        EffectiveVisibility classVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility$default(classDescriptor2, false, 1, null);
        List<KtTypeParameter> list2 = klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
        List<KtTypeParameter> typeParameterList = list2;
        boolean result2 = false;
        result2 = true;
        List<TypeParameterDescriptor> list3 = classDescriptor2.getDeclaredTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "getDeclaredTypeParameters(...)");
        Iterable $this$forEachIndexed$iv = list3;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block0: for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterDescriptor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            boolean bl = false;
            if (i >= typeParameterList.size()) {
                return result2;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                Intrinsics.checkNotNull(upperBound);
                DescriptorWithRelation restricting = EffectiveVisibilityUtilsKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                DiagnosticFactory3<KtTypeParameter, EffectiveVisibility, DescriptorWithRelation, EffectiveVisibility> diagnosticFactory3 = Errors.EXPOSED_TYPE_PARAMETER_BOUND;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, "EXPOSED_TYPE_PARAMETER_BOUND");
                this.reportExposure(diagnosticFactory3, (PsiElement)typeParameterList.get(i), classVisibility, restricting);
                result2 = false;
                continue block0;
            }
        }
        return result2;
    }
}

