/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.navigation.ItemPresentation;
import ksp.com.intellij.navigation.ItemPresentationProviders;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtBackingField;
import ksp.org.jetbrains.kotlin.psi.KtBlockExpression;
import ksp.org.jetbrains.kotlin.psi.KtClassBody;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtContextReceiver;
import ksp.org.jetbrains.kotlin.psi.KtContextReceiverList;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor;
import ksp.org.jetbrains.kotlin.psi.KtPropertyDelegate;
import ksp.org.jetbrains.kotlin.psi.KtPsiFactory;
import ksp.org.jetbrains.kotlin.psi.KtScript;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtVariableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtVisitor;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import ksp.org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KtProperty
extends KtTypeParameterListOwnerStub<KotlinPropertyStub>
implements KtVariableDeclaration {
    private static final Logger LOG = Logger.getInstance(KtProperty.class);
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);

    public KtProperty(@NotNull ASTNode node) {
        if (node == null) {
            KtProperty.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtProperty(@NotNull KotlinPropertyStub stub) {
        if (stub == null) {
            KtProperty.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType)KtStubElementTypes.PROPERTY);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtProperty.$$$reportNull$$$0(2);
        }
        return visitor2.visitProperty(this, data2);
    }

    @Override
    public boolean isVar() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isVar();
        }
        return this.getNode().findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        return !this.isTopLevel() && !this.isMember();
    }

    public boolean isMember() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof KtClassOrObject || parent2 instanceof KtClassBody || parent2 instanceof KtBlockExpression && parent2.getParent() instanceof KtScript;
    }

    public boolean isTopLevel() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof KtFile;
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list2 = Collections.emptyList();
        if (list2 == null) {
            KtProperty.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
        }
        return this.getReceiverTypeRefByTree();
    }

    @Override
    @NotNull
    public List<KtContextReceiver> getContextReceivers() {
        KtContextReceiverList contextReceiverList = (KtContextReceiverList)this.getStubOrPsiChild(KtStubElementTypes.CONTEXT_RECEIVER_LIST);
        if (contextReceiverList != null) {
            List<KtContextReceiver> list2 = contextReceiverList.contextReceivers();
            if (list2 == null) {
                KtProperty.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<KtContextReceiver> list3 = Collections.emptyList();
        if (list3 == null) {
            KtProperty.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Nullable
    private KtTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != KtTokens.COLON; node = node.getTreeNext()) {
            if (tt != KtNodeTypes.TYPE_REFERENCE) continue;
            return (KtTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            int returnTypeRefPositionInPsi;
            if (!stub.hasReturnTypeRef()) {
                return null;
            }
            List typeReferences = this.getStubOrPsiChildrenAsList(KtStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeRefPositionInPsi = stub.isExtension() ? 1 : 0;
            if (typeReferences.size() <= returnTypeRefPositionInPsi) {
                LOG.error("Invalid stub structure built for property:\n" + this.getText());
                return null;
            }
            return (KtTypeReference)typeReferences.get(returnTypeRefPositionInPsi);
        }
        return TypeRefHelpersKt.getTypeReference(this);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @NotNull
    public List<KtPropertyAccessor> getAccessors() {
        List<KtPropertyAccessor> list2 = this.getStubOrPsiChildrenAsList(KtStubElementTypes.PROPERTY_ACCESSOR);
        if (list2 == null) {
            KtProperty.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public KtPropertyAccessor getGetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public KtPropertyAccessor getSetter() {
        for (KtPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public KtBackingField getFieldDeclaration() {
        Iterator<KtBackingField> iterator2 = this.getStubOrPsiChildrenAsList(KtStubElementTypes.BACKING_FIELD).iterator();
        if (iterator2.hasNext()) {
            KtBackingField field2 = iterator2.next();
            return field2;
        }
        return null;
    }

    public boolean hasDelegate() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegate();
        }
        return this.getDelegate() != null;
    }

    @Nullable
    public KtPropertyDelegate getDelegate() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null && !stub.hasDelegate()) {
            return null;
        }
        return (KtPropertyDelegate)this.findChildByType(KtNodeTypes.PROPERTY_DELEGATE);
    }

    public boolean hasDelegateExpression() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegateExpression();
        }
        return this.getDelegateExpression() != null;
    }

    @Nullable
    public KtExpression getDelegateExpression() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null && !stub.hasDelegateExpression()) {
            return null;
        }
        KtPropertyDelegate delegate2 = this.getDelegate();
        if (delegate2 != null) {
            return delegate2.getExpression();
        }
        return null;
    }

    @Override
    public boolean hasInitializer() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            if (!stub.hasInitializer()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(KtTokens.EQ), KtExpression.class);
    }

    public boolean hasDelegateExpressionOrInitializer() {
        return this.hasDelegateExpression() || this.hasInitializer();
    }

    @Nullable
    public KtExpression setInitializer(@Nullable KtExpression initializer2) {
        KtExpression oldInitializer = this.getInitializer();
        if (oldInitializer != null) {
            if (initializer2 != null) {
                return (KtExpression)oldInitializer.replace(initializer2);
            }
            PsiElement nextSibling = oldInitializer.getNextSibling();
            KtExpression last = nextSibling != null && nextSibling.getNode() != null && nextSibling.getNode().getElementType() == KtTokens.SEMICOLON ? nextSibling : oldInitializer;
            this.deleteChildRange((PsiElement)this.findChildByType(KtTokens.EQ), last);
            return null;
        }
        if (initializer2 != null) {
            PsiElement addAfter = this.getTypeReference();
            if (addAfter == null) {
                addAfter = this.getNameIdentifier();
            }
            PsiElement eq = this.addAfter(new KtPsiFactory(this.getProject()).createEQ(), addAfter);
            return (KtExpression)this.addAfter(initializer2, eq);
        }
        return null;
    }

    @Nullable
    public KtExpression getDelegateExpressionOrInitializer() {
        KtExpression expression2 = this.getDelegateExpression();
        if (expression2 == null) {
            return this.getInitializer();
        }
        return expression2;
    }

    @Override
    @NotNull
    public PsiElement getValOrVarKeyword() {
        Object element2 = this.findChildByType(VAL_VAR_TOKEN_SET);
        assert (element2 != null) : "Val or var should always exist for property" + this.getText();
        Object t = element2;
        if (t == null) {
            KtProperty.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }

    public boolean hasBody() {
        if (this.hasDelegateExpressionOrInitializer()) {
            return true;
        }
        KtPropertyAccessor getter2 = this.getGetter();
        if (getter2 != null && getter2.hasBody()) {
            return true;
        }
        KtPropertyAccessor setter2 = this.getSetter();
        return setter2 != null && setter2.hasBody();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/psi/KtProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/psi/KtProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextReceivers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValOrVarKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

